/*
  This file is part of the MKRNB library.
  Copyright (C) 2018 Arduino SA (http://www.arduino.cc/)

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _NBROOT_CERTS_H_INCLUDED
#define _NBROOT_CERTS_H_INCLUDED

#include <stddef.h>
#include <stdint.h>

struct NBRootCert {
  const char* name;
  const uint8_t* data;
  const int size;
};

static const NBRootCert NB_ROOT_CERTS[] = {
  {
    "AddTrust_External_CA_Root",
    (const uint8_t[]){
      0x30, 0x82, 0x04, 0x36, 0x30, 0x82, 0x03, 0x1e, 0xa0, 0x03, 0x02, 0x01,
      0x02, 0x02, 0x01, 0x01, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
      0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x6f, 0x31, 0x0b, 0x30,
      0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x53, 0x45, 0x31, 0x14,
      0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0b, 0x41, 0x64, 0x64,
      0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x41, 0x42, 0x31, 0x26, 0x30, 0x24,
      0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x1d, 0x41, 0x64, 0x64, 0x54, 0x72,
      0x75, 0x73, 0x74, 0x20, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
      0x20, 0x54, 0x54, 0x50, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
      0x31, 0x22, 0x30, 0x20, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x19, 0x41,
      0x64, 0x64, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x45, 0x78, 0x74, 0x65,
      0x72, 0x6e, 0x61, 0x6c, 0x20, 0x43, 0x41, 0x20, 0x52, 0x6f, 0x6f, 0x74,
      0x30, 0x1e, 0x17, 0x0d, 0x30, 0x30, 0x30, 0x35, 0x33, 0x30, 0x31, 0x30,
      0x34, 0x38, 0x33, 0x38, 0x5a, 0x17, 0x0d, 0x32, 0x30, 0x30, 0x35, 0x33,
      0x30, 0x31, 0x30, 0x34, 0x38, 0x33, 0x38, 0x5a, 0x30, 0x6f, 0x31, 0x0b,
      0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x53, 0x45, 0x31,
      0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0b, 0x41, 0x64,
      0x64, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x41, 0x42, 0x31, 0x26, 0x30,
      0x24, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x1d, 0x41, 0x64, 0x64, 0x54,
      0x72, 0x75, 0x73, 0x74, 0x20, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
      0x6c, 0x20, 0x54, 0x54, 0x50, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
      0x6b, 0x31, 0x22, 0x30, 0x20, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x19,
      0x41, 0x64, 0x64, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x45, 0x78, 0x74,
      0x65, 0x72, 0x6e, 0x61, 0x6c, 0x20, 0x43, 0x41, 0x20, 0x52, 0x6f, 0x6f,
      0x74, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48,
      0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0f,
      0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xb7, 0xf7,
      0x1a, 0x33, 0xe6, 0xf2, 0x00, 0x04, 0x2d, 0x39, 0xe0, 0x4e, 0x5b, 0xed,
      0x1f, 0xbc, 0x6c, 0x0f, 0xcd, 0xb5, 0xfa, 0x23, 0xb6, 0xce, 0xde, 0x9b,
      0x11, 0x33, 0x97, 0xa4, 0x29, 0x4c, 0x7d, 0x93, 0x9f, 0xbd, 0x4a, 0xbc,
      0x93, 0xed, 0x03, 0x1a, 0xe3, 0x8f, 0xcf, 0xe5, 0x6d, 0x50, 0x5a, 0xd6,
      0x97, 0x29, 0x94, 0x5a, 0x80, 0xb0, 0x49, 0x7a, 0xdb, 0x2e, 0x95, 0xfd,
      0xb8, 0xca, 0xbf, 0x37, 0x38, 0x2d, 0x1e, 0x3e, 0x91, 0x41, 0xad, 0x70,
      0x56, 0xc7, 0xf0, 0x4f, 0x3f, 0xe8, 0x32, 0x9e, 0x74, 0xca, 0xc8, 0x90,
      0x54, 0xe9, 0xc6, 0x5f, 0x0f, 0x78, 0x9d, 0x9a, 0x40, 0x3c, 0x0e, 0xac,
      0x61, 0xaa, 0x5e, 0x14, 0x8f, 0x9e, 0x87, 0xa1, 0x6a, 0x50, 0xdc, 0xd7,
      0x9a, 0x4e, 0xaf, 0x05, 0xb3, 0xa6, 0x71, 0x94, 0x9c, 0x71, 0xb3, 0x50,
      0x60, 0x0a, 0xc7, 0x13, 0x9d, 0x38, 0x07, 0x86, 0x02, 0xa8, 0xe9, 0xa8,
      0x69, 0x26, 0x18, 0x90, 0xab, 0x4c, 0xb0, 0x4f, 0x23, 0xab, 0x3a, 0x4f,
      0x84, 0xd8, 0xdf, 0xce, 0x9f, 0xe1, 0x69, 0x6f, 0xbb, 0xd7, 0x42, 0xd7,
      0x6b, 0x44, 0xe4, 0xc7, 0xad, 0xee, 0x6d, 0x41, 0x5f, 0x72, 0x5a, 0x71,
      0x08, 0x37, 0xb3, 0x79, 0x65, 0xa4, 0x59, 0xa0, 0x94, 0x37, 0xf7, 0x00,
      0x2f, 0x0d, 0xc2, 0x92, 0x72, 0xda, 0xd0, 0x38, 0x72, 0xdb, 0x14, 0xa8,
      0x45, 0xc4, 0x5d, 0x2a, 0x7d, 0xb7, 0xb4, 0xd6, 0xc4, 0xee, 0xac, 0xcd,
      0x13, 0x44, 0xb7, 0xc9, 0x2b, 0xdd, 0x43, 0x00, 0x25, 0xfa, 0x61, 0xb9,
      0x69, 0x6a, 0x58, 0x23, 0x11, 0xb7, 0xa7, 0x33, 0x8f, 0x56, 0x75, 0x59,
      0xf5, 0xcd, 0x29, 0xd7, 0x46, 0xb7, 0x0a, 0x2b, 0x65, 0xb6, 0xd3, 0x42,
      0x6f, 0x15, 0xb2, 0xb8, 0x7b, 0xfb, 0xef, 0xe9, 0x5d, 0x53, 0xd5, 0x34,
      0x5a, 0x27, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x81, 0xdc, 0x30, 0x81,
      0xd9, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14,
      0xad, 0xbd, 0x98, 0x7a, 0x34, 0xb4, 0x26, 0xf7, 0xfa, 0xc4, 0x26, 0x54,
      0xef, 0x03, 0xbd, 0xe0, 0x24, 0xcb, 0x54, 0x1a, 0x30, 0x0b, 0x06, 0x03,
      0x55, 0x1d, 0x0f, 0x04, 0x04, 0x03, 0x02, 0x01, 0x06, 0x30, 0x0f, 0x06,
      0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01,
      0x01, 0xff, 0x30, 0x81, 0x99, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x81,
      0x91, 0x30, 0x81, 0x8e, 0x80, 0x14, 0xad, 0xbd, 0x98, 0x7a, 0x34, 0xb4,
      0x26, 0xf7, 0xfa, 0xc4, 0x26, 0x54, 0xef, 0x03, 0xbd, 0xe0, 0x24, 0xcb,
      0x54, 0x1a, 0xa1, 0x73, 0xa4, 0x71, 0x30, 0x6f, 0x31, 0x0b, 0x30, 0x09,
      0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x53, 0x45, 0x31, 0x14, 0x30,
      0x12, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0b, 0x41, 0x64, 0x64, 0x54,
      0x72, 0x75, 0x73, 0x74, 0x20, 0x41, 0x42, 0x31, 0x26, 0x30, 0x24, 0x06,
      0x03, 0x55, 0x04, 0x0b, 0x13, 0x1d, 0x41, 0x64, 0x64, 0x54, 0x72, 0x75,
      0x73, 0x74, 0x20, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x20,
      0x54, 0x54, 0x50, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x31,
      0x22, 0x30, 0x20, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x19, 0x41, 0x64,
      0x64, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x45, 0x78, 0x74, 0x65, 0x72,
      0x6e, 0x61, 0x6c, 0x20, 0x43, 0x41, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x82,
      0x01, 0x01, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d,
      0x01, 0x01, 0x05, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0xb0, 0x9b,
      0xe0, 0x85, 0x25, 0xc2, 0xd6, 0x23, 0xe2, 0x0f, 0x96, 0x06, 0x92, 0x9d,
      0x41, 0x98, 0x9c, 0xd9, 0x84, 0x79, 0x81, 0xd9, 0x1e, 0x5b, 0x14, 0x07,
      0x23, 0x36, 0x65, 0x8f, 0xb0, 0xd8, 0x77, 0xbb, 0xac, 0x41, 0x6c, 0x47,
      0x60, 0x83, 0x51, 0xb0, 0xf9, 0x32, 0x3d, 0xe7, 0xfc, 0xf6, 0x26, 0x13,
      0xc7, 0x80, 0x16, 0xa5, 0xbf, 0x5a, 0xfc, 0x87, 0xcf, 0x78, 0x79, 0x89,
      0x21, 0x9a, 0xe2, 0x4c, 0x07, 0x0a, 0x86, 0x35, 0xbc, 0xf2, 0xde, 0x51,
      0xc4, 0xd2, 0x96, 0xb7, 0xdc, 0x7e, 0x4e, 0xee, 0x70, 0xfd, 0x1c, 0x39,
      0xeb, 0x0c, 0x02, 0x51, 0x14, 0x2d, 0x8e, 0xbd, 0x16, 0xe0, 0xc1, 0xdf,
      0x46, 0x75, 0xe7, 0x24, 0xad, 0xec, 0xf4, 0x42, 0xb4, 0x85, 0x93, 0x70,
      0x10, 0x67, 0xba, 0x9d, 0x06, 0x35, 0x4a, 0x18, 0xd3, 0x2b, 0x7a, 0xcc,
      0x51, 0x42, 0xa1, 0x7a, 0x63, 0xd1, 0xe6, 0xbb, 0xa1, 0xc5, 0x2b, 0xc2,
      0x36, 0xbe, 0x13, 0x0d, 0xe6, 0xbd, 0x63, 0x7e, 0x79, 0x7b, 0xa7, 0x09,
      0x0d, 0x40, 0xab, 0x6a, 0xdd, 0x8f, 0x8a, 0xc3, 0xf6, 0xf6, 0x8c, 0x1a,
      0x42, 0x05, 0x51, 0xd4, 0x45, 0xf5, 0x9f, 0xa7, 0x62, 0x21, 0x68, 0x15,
      0x20, 0x43, 0x3c, 0x99, 0xe7, 0x7c, 0xbd, 0x24, 0xd8, 0xa9, 0x91, 0x17,
      0x73, 0x88, 0x3f, 0x56, 0x1b, 0x31, 0x38, 0x18, 0xb4, 0x71, 0x0f, 0x9a,
      0xcd, 0xc8, 0x0e, 0x9e, 0x8e, 0x2e, 0x1b, 0xe1, 0x8c, 0x98, 0x83, 0xcb,
      0x1f, 0x31, 0xf1, 0x44, 0x4c, 0xc6, 0x04, 0x73, 0x49, 0x76, 0x60, 0x0f,
      0xc7, 0xf8, 0xbd, 0x17, 0x80, 0x6b, 0x2e, 0xe9, 0xcc, 0x4c, 0x0e, 0x5a,
      0x9a, 0x79, 0x0f, 0x20, 0x0a, 0x2e, 0xd5, 0x9e, 0x63, 0x26, 0x1e, 0x55,
      0x92, 0x94, 0xd8, 0x82, 0x17, 0x5a, 0x7b, 0xd0, 0xbc, 0xc7, 0x8f, 0x4e,
      0x86, 0x04
    },
    1082
  },
  {
    "Baltimore_CyberTrust_Root",
    (const uint8_t[]){
      0x30, 0x82, 0x03, 0x77, 0x30, 0x82, 0x02, 0x5f, 0xa0, 0x03, 0x02, 0x01,
      0x02, 0x02, 0x04, 0x02, 0x00, 0x00, 0xb9, 0x30, 0x0d, 0x06, 0x09, 0x2a,
      0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x5a,
      0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x49,
      0x45, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x09,
      0x42, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x6f, 0x72, 0x65, 0x31, 0x13, 0x30,
      0x11, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x0a, 0x43, 0x79, 0x62, 0x65,
      0x72, 0x54, 0x72, 0x75, 0x73, 0x74, 0x31, 0x22, 0x30, 0x20, 0x06, 0x03,
      0x55, 0x04, 0x03, 0x13, 0x19, 0x42, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x6f,
      0x72, 0x65, 0x20, 0x43, 0x79, 0x62, 0x65, 0x72, 0x54, 0x72, 0x75, 0x73,
      0x74, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x30, 0x1e, 0x17, 0x0d, 0x30, 0x30,
      0x30, 0x35, 0x31, 0x32, 0x31, 0x38, 0x34, 0x36, 0x30, 0x30, 0x5a, 0x17,
      0x0d, 0x32, 0x35, 0x30, 0x35, 0x31, 0x32, 0x32, 0x33, 0x35, 0x39, 0x30,
      0x30, 0x5a, 0x30, 0x5a, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04,
      0x06, 0x13, 0x02, 0x49, 0x45, 0x31, 0x12, 0x30, 0x10, 0x06, 0x03, 0x55,
      0x04, 0x0a, 0x13, 0x09, 0x42, 0x61, 0x6c, 0x74, 0x69, 0x6d, 0x6f, 0x72,
      0x65, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x0a,
      0x43, 0x79, 0x62, 0x65, 0x72, 0x54, 0x72, 0x75, 0x73, 0x74, 0x31, 0x22,
      0x30, 0x20, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x19, 0x42, 0x61, 0x6c,
      0x74, 0x69, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x43, 0x79, 0x62, 0x65, 0x72,
      0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x30, 0x82,
      0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d,
      0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0f, 0x00, 0x30, 0x82,
      0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xa3, 0x04, 0xbb, 0x22, 0xab,
      0x98, 0x3d, 0x57, 0xe8, 0x26, 0x72, 0x9a, 0xb5, 0x79, 0xd4, 0x29, 0xe2,
      0xe1, 0xe8, 0x95, 0x80, 0xb1, 0xb0, 0xe3, 0x5b, 0x8e, 0x2b, 0x29, 0x9a,
      0x64, 0xdf, 0xa1, 0x5d, 0xed, 0xb0, 0x09, 0x05, 0x6d, 0xdb, 0x28, 0x2e,
      0xce, 0x62, 0xa2, 0x62, 0xfe, 0xb4, 0x88, 0xda, 0x12, 0xeb, 0x38, 0xeb,
      0x21, 0x9d, 0xc0, 0x41, 0x2b, 0x01, 0x52, 0x7b, 0x88, 0x77, 0xd3, 0x1c,
      0x8f, 0xc7, 0xba, 0xb9, 0x88, 0xb5, 0x6a, 0x09, 0xe7, 0x73, 0xe8, 0x11,
      0x40, 0xa7, 0xd1, 0xcc, 0xca, 0x62, 0x8d, 0x2d, 0xe5, 0x8f, 0x0b, 0xa6,
      0x50, 0xd2, 0xa8, 0x50, 0xc3, 0x28, 0xea, 0xf5, 0xab, 0x25, 0x87, 0x8a,
      0x9a, 0x96, 0x1c, 0xa9, 0x67, 0xb8, 0x3f, 0x0c, 0xd5, 0xf7, 0xf9, 0x52,
      0x13, 0x2f, 0xc2, 0x1b, 0xd5, 0x70, 0x70, 0xf0, 0x8f, 0xc0, 0x12, 0xca,
      0x06, 0xcb, 0x9a, 0xe1, 0xd9, 0xca, 0x33, 0x7a, 0x77, 0xd6, 0xf8, 0xec,
      0xb9, 0xf1, 0x68, 0x44, 0x42, 0x48, 0x13, 0xd2, 0xc0, 0xc2, 0xa4, 0xae,
      0x5e, 0x60, 0xfe, 0xb6, 0xa6, 0x05, 0xfc, 0xb4, 0xdd, 0x07, 0x59, 0x02,
      0xd4, 0x59, 0x18, 0x98, 0x63, 0xf5, 0xa5, 0x63, 0xe0, 0x90, 0x0c, 0x7d,
      0x5d, 0xb2, 0x06, 0x7a, 0xf3, 0x85, 0xea, 0xeb, 0xd4, 0x03, 0xae, 0x5e,
      0x84, 0x3e, 0x5f, 0xff, 0x15, 0xed, 0x69, 0xbc, 0xf9, 0x39, 0x36, 0x72,
      0x75, 0xcf, 0x77, 0x52, 0x4d, 0xf3, 0xc9, 0x90, 0x2c, 0xb9, 0x3d, 0xe5,
      0xc9, 0x23, 0x53, 0x3f, 0x1f, 0x24, 0x98, 0x21, 0x5c, 0x07, 0x99, 0x29,
      0xbd, 0xc6, 0x3a, 0xec, 0xe7, 0x6e, 0x86, 0x3a, 0x6b, 0x97, 0x74, 0x63,
      0x33, 0xbd, 0x68, 0x18, 0x31, 0xf0, 0x78, 0x8d, 0x76, 0xbf, 0xfc, 0x9e,
      0x8e, 0x5d, 0x2a, 0x86, 0xa7, 0x4d, 0x90, 0xdc, 0x27, 0x1a, 0x39, 0x02,
      0x03, 0x01, 0x00, 0x01, 0xa3, 0x45, 0x30, 0x43, 0x30, 0x1d, 0x06, 0x03,
      0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xe5, 0x9d, 0x59, 0x30, 0x82,
      0x47, 0x58, 0xcc, 0xac, 0xfa, 0x08, 0x54, 0x36, 0x86, 0x7b, 0x3a, 0xb5,
      0x04, 0x4d, 0xf0, 0x30, 0x12, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01,
      0xff, 0x04, 0x08, 0x30, 0x06, 0x01, 0x01, 0xff, 0x02, 0x01, 0x03, 0x30,
      0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03,
      0x02, 0x01, 0x06, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7,
      0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x85,
      0x0c, 0x5d, 0x8e, 0xe4, 0x6f, 0x51, 0x68, 0x42, 0x05, 0xa0, 0xdd, 0xbb,
      0x4f, 0x27, 0x25, 0x84, 0x03, 0xbd, 0xf7, 0x64, 0xfd, 0x2d, 0xd7, 0x30,
      0xe3, 0xa4, 0x10, 0x17, 0xeb, 0xda, 0x29, 0x29, 0xb6, 0x79, 0x3f, 0x76,
      0xf6, 0x19, 0x13, 0x23, 0xb8, 0x10, 0x0a, 0xf9, 0x58, 0xa4, 0xd4, 0x61,
      0x70, 0xbd, 0x04, 0x61, 0x6a, 0x12, 0x8a, 0x17, 0xd5, 0x0a, 0xbd, 0xc5,
      0xbc, 0x30, 0x7c, 0xd6, 0xe9, 0x0c, 0x25, 0x8d, 0x86, 0x40, 0x4f, 0xec,
      0xcc, 0xa3, 0x7e, 0x38, 0xc6, 0x37, 0x11, 0x4f, 0xed, 0xdd, 0x68, 0x31,
      0x8e, 0x4c, 0xd2, 0xb3, 0x01, 0x74, 0xee, 0xbe, 0x75, 0x5e, 0x07, 0x48,
      0x1a, 0x7f, 0x70, 0xff, 0x16, 0x5c, 0x84, 0xc0, 0x79, 0x85, 0xb8, 0x05,
      0xfd, 0x7f, 0xbe, 0x65, 0x11, 0xa3, 0x0f, 0xc0, 0x02, 0xb4, 0xf8, 0x52,
      0x37, 0x39, 0x04, 0xd5, 0xa9, 0x31, 0x7a, 0x18, 0xbf, 0xa0, 0x2a, 0xf4,
      0x12, 0x99, 0xf7, 0xa3, 0x45, 0x82, 0xe3, 0x3c, 0x5e, 0xf5, 0x9d, 0x9e,
      0xb5, 0xc8, 0x9e, 0x7c, 0x2e, 0xc8, 0xa4, 0x9e, 0x4e, 0x08, 0x14, 0x4b,
      0x6d, 0xfd, 0x70, 0x6d, 0x6b, 0x1a, 0x63, 0xbd, 0x64, 0xe6, 0x1f, 0xb7,
      0xce, 0xf0, 0xf2, 0x9f, 0x2e, 0xbb, 0x1b, 0xb7, 0xf2, 0x50, 0x88, 0x73,
      0x92, 0xc2, 0xe2, 0xe3, 0x16, 0x8d, 0x9a, 0x32, 0x02, 0xab, 0x8e, 0x18,
      0xdd, 0xe9, 0x10, 0x11, 0xee, 0x7e, 0x35, 0xab, 0x90, 0xaf, 0x3e, 0x30,
      0x94, 0x7a, 0xd0, 0x33, 0x3d, 0xa7, 0x65, 0x0f, 0xf5, 0xfc, 0x8e, 0x9e,
      0x62, 0xcf, 0x47, 0x44, 0x2c, 0x01, 0x5d, 0xbb, 0x1d, 0xb5, 0x32, 0xd2,
      0x47, 0xd2, 0x38, 0x2e, 0xd0, 0xfe, 0x81, 0xdc, 0x32, 0x6a, 0x1e, 0xb5,
      0xee, 0x3c, 0xd5, 0xfc, 0xe7, 0x81, 0x1d, 0x19, 0xc3, 0x24, 0x42, 0xea,
      0x63, 0x39, 0xa9
    },
    891
  },
  {
    "COMODO_RSA_Certification_Authority",
    (const uint8_t[]){
      0x30, 0x82, 0x05, 0xd8, 0x30, 0x82, 0x03, 0xc0, 0xa0, 0x03, 0x02, 0x01,
      0x02, 0x02, 0x10, 0x4c, 0xaa, 0xf9, 0xca, 0xdb, 0x63, 0x6f, 0xe0, 0x1f,
      0xf7, 0x4e, 0xd8, 0x5b, 0x03, 0x86, 0x9d, 0x30, 0x0d, 0x06, 0x09, 0x2a,
      0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0c, 0x05, 0x00, 0x30, 0x81,
      0x85, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02,
      0x47, 0x42, 0x31, 0x1b, 0x30, 0x19, 0x06, 0x03, 0x55, 0x04, 0x08, 0x13,
      0x12, 0x47, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x4d, 0x61, 0x6e,
      0x63, 0x68, 0x65, 0x73, 0x74, 0x65, 0x72, 0x31, 0x10, 0x30, 0x0e, 0x06,
      0x03, 0x55, 0x04, 0x07, 0x13, 0x07, 0x53, 0x61, 0x6c, 0x66, 0x6f, 0x72,
      0x64, 0x31, 0x1a, 0x30, 0x18, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x11,
      0x43, 0x4f, 0x4d, 0x4f, 0x44, 0x4f, 0x20, 0x43, 0x41, 0x20, 0x4c, 0x69,
      0x6d, 0x69, 0x74, 0x65, 0x64, 0x31, 0x2b, 0x30, 0x29, 0x06, 0x03, 0x55,
      0x04, 0x03, 0x13, 0x22, 0x43, 0x4f, 0x4d, 0x4f, 0x44, 0x4f, 0x20, 0x52,
      0x53, 0x41, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
      0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
      0x74, 0x79, 0x30, 0x1e, 0x17, 0x0d, 0x31, 0x30, 0x30, 0x31, 0x31, 0x39,
      0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x17, 0x0d, 0x33, 0x38, 0x30,
      0x31, 0x31, 0x38, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x81,
      0x85, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02,
      0x47, 0x42, 0x31, 0x1b, 0x30, 0x19, 0x06, 0x03, 0x55, 0x04, 0x08, 0x13,
      0x12, 0x47, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x4d, 0x61, 0x6e,
      0x63, 0x68, 0x65, 0x73, 0x74, 0x65, 0x72, 0x31, 0x10, 0x30, 0x0e, 0x06,
      0x03, 0x55, 0x04, 0x07, 0x13, 0x07, 0x53, 0x61, 0x6c, 0x66, 0x6f, 0x72,
      0x64, 0x31, 0x1a, 0x30, 0x18, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x11,
      0x43, 0x4f, 0x4d, 0x4f, 0x44, 0x4f, 0x20, 0x43, 0x41, 0x20, 0x4c, 0x69,
      0x6d, 0x69, 0x74, 0x65, 0x64, 0x31, 0x2b, 0x30, 0x29, 0x06, 0x03, 0x55,
      0x04, 0x03, 0x13, 0x22, 0x43, 0x4f, 0x4d, 0x4f, 0x44, 0x4f, 0x20, 0x52,
      0x53, 0x41, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
      0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
      0x74, 0x79, 0x30, 0x82, 0x02, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86,
      0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x02,
      0x0f, 0x00, 0x30, 0x82, 0x02, 0x0a, 0x02, 0x82, 0x02, 0x01, 0x00, 0x91,
      0xe8, 0x54, 0x92, 0xd2, 0x0a, 0x56, 0xb1, 0xac, 0x0d, 0x24, 0xdd, 0xc5,
      0xcf, 0x44, 0x67, 0x74, 0x99, 0x2b, 0x37, 0xa3, 0x7d, 0x23, 0x70, 0x00,
      0x71, 0xbc, 0x53, 0xdf, 0xc4, 0xfa, 0x2a, 0x12, 0x8f, 0x4b, 0x7f, 0x10,
      0x56, 0xbd, 0x9f, 0x70, 0x72, 0xb7, 0x61, 0x7f, 0xc9, 0x4b, 0x0f, 0x17,
      0xa7, 0x3d, 0xe3, 0xb0, 0x04, 0x61, 0xee, 0xff, 0x11, 0x97, 0xc7, 0xf4,
      0x86, 0x3e, 0x0a, 0xfa, 0x3e, 0x5c, 0xf9, 0x93, 0xe6, 0x34, 0x7a, 0xd9,
      0x14, 0x6b, 0xe7, 0x9c, 0xb3, 0x85, 0xa0, 0x82, 0x7a, 0x76, 0xaf, 0x71,
      0x90, 0xd7, 0xec, 0xfd, 0x0d, 0xfa, 0x9c, 0x6c, 0xfa, 0xdf, 0xb0, 0x82,
      0xf4, 0x14, 0x7e, 0xf9, 0xbe, 0xc4, 0xa6, 0x2f, 0x4f, 0x7f, 0x99, 0x7f,
      0xb5, 0xfc, 0x67, 0x43, 0x72, 0xbd, 0x0c, 0x00, 0xd6, 0x89, 0xeb, 0x6b,
      0x2c, 0xd3, 0xed, 0x8f, 0x98, 0x1c, 0x14, 0xab, 0x7e, 0xe5, 0xe3, 0x6e,
      0xfc, 0xd8, 0xa8, 0xe4, 0x92, 0x24, 0xda, 0x43, 0x6b, 0x62, 0xb8, 0x55,
      0xfd, 0xea, 0xc1, 0xbc, 0x6c, 0xb6, 0x8b, 0xf3, 0x0e, 0x8d, 0x9a, 0xe4,
      0x9b, 0x6c, 0x69, 0x99, 0xf8, 0x78, 0x48, 0x30, 0x45, 0xd5, 0xad, 0xe1,
      0x0d, 0x3c, 0x45, 0x60, 0xfc, 0x32, 0x96, 0x51, 0x27, 0xbc, 0x67, 0xc3,
      0xca, 0x2e, 0xb6, 0x6b, 0xea, 0x46, 0xc7, 0xc7, 0x20, 0xa0, 0xb1, 0x1f,
      0x65, 0xde, 0x48, 0x08, 0xba, 0xa4, 0x4e, 0xa9, 0xf2, 0x83, 0x46, 0x37,
      0x84, 0xeb, 0xe8, 0xcc, 0x81, 0x48, 0x43, 0x67, 0x4e, 0x72, 0x2a, 0x9b,
      0x5c, 0xbd, 0x4c, 0x1b, 0x28, 0x8a, 0x5c, 0x22, 0x7b, 0xb4, 0xab, 0x98,
      0xd9, 0xee, 0xe0, 0x51, 0x83, 0xc3, 0x09, 0x46, 0x4e, 0x6d, 0x3e, 0x99,
      0xfa, 0x95, 0x17, 0xda, 0x7c, 0x33, 0x57, 0x41, 0x3c, 0x8d, 0x51, 0xed,
      0x0b, 0xb6, 0x5c, 0xaf, 0x2c, 0x63, 0x1a, 0xdf, 0x57, 0xc8, 0x3f, 0xbc,
      0xe9, 0x5d, 0xc4, 0x9b, 0xaf, 0x45, 0x99, 0xe2, 0xa3, 0x5a, 0x24, 0xb4,
      0xba, 0xa9, 0x56, 0x3d, 0xcf, 0x6f, 0xaa, 0xff, 0x49, 0x58, 0xbe, 0xf0,
      0xa8, 0xff, 0xf4, 0xb8, 0xad, 0xe9, 0x37, 0xfb, 0xba, 0xb8, 0xf4, 0x0b,
      0x3a, 0xf9, 0xe8, 0x43, 0x42, 0x1e, 0x89, 0xd8, 0x84, 0xcb, 0x13, 0xf1,
      0xd9, 0xbb, 0xe1, 0x89, 0x60, 0xb8, 0x8c, 0x28, 0x56, 0xac, 0x14, 0x1d,
      0x9c, 0x0a, 0xe7, 0x71, 0xeb, 0xcf, 0x0e, 0xdd, 0x3d, 0xa9, 0x96, 0xa1,
      0x48, 0xbd, 0x3c, 0xf7, 0xaf, 0xb5, 0x0d, 0x22, 0x4c, 0xc0, 0x11, 0x81,
      0xec, 0x56, 0x3b, 0xf6, 0xd3, 0xa2, 0xe2, 0x5b, 0xb7, 0xb2, 0x04, 0x22,
      0x52, 0x95, 0x80, 0x93, 0x69, 0xe8, 0x8e, 0x4c, 0x65, 0xf1, 0x91, 0x03,
      0x2d, 0x70, 0x74, 0x02, 0xea, 0x8b, 0x67, 0x15, 0x29, 0x69, 0x52, 0x02,
      0xbb, 0xd7, 0xdf, 0x50, 0x6a, 0x55, 0x46, 0xbf, 0xa0, 0xa3, 0x28, 0x61,
      0x7f, 0x70, 0xd0, 0xc3, 0xa2, 0xaa, 0x2c, 0x21, 0xaa, 0x47, 0xce, 0x28,
      0x9c, 0x06, 0x45, 0x76, 0xbf, 0x82, 0x18, 0x27, 0xb4, 0xd5, 0xae, 0xb4,
      0xcb, 0x50, 0xe6, 0x6b, 0xf4, 0x4c, 0x86, 0x71, 0x30, 0xe9, 0xa6, 0xdf,
      0x16, 0x86, 0xe0, 0xd8, 0xff, 0x40, 0xdd, 0xfb, 0xd0, 0x42, 0x88, 0x7f,
      0xa3, 0x33, 0x3a, 0x2e, 0x5c, 0x1e, 0x41, 0x11, 0x81, 0x63, 0xce, 0x18,
      0x71, 0x6b, 0x2b, 0xec, 0xa6, 0x8a, 0xb7, 0x31, 0x5c, 0x3a, 0x6a, 0x47,
      0xe0, 0xc3, 0x79, 0x59, 0xd6, 0x20, 0x1a, 0xaf, 0xf2, 0x6a, 0x98, 0xaa,
      0x72, 0xbc, 0x57, 0x4a, 0xd2, 0x4b, 0x9d, 0xbb, 0x10, 0xfc, 0xb0, 0x4c,
      0x41, 0xe5, 0xed, 0x1d, 0x3d, 0x5e, 0x28, 0x9d, 0x9c, 0xcc, 0xbf, 0xb3,
      0x51, 0xda, 0xa7, 0x47, 0xe5, 0x84, 0x53, 0x02, 0x03, 0x01, 0x00, 0x01,
      0xa3, 0x42, 0x30, 0x40, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04,
      0x16, 0x04, 0x14, 0xbb, 0xaf, 0x7e, 0x02, 0x3d, 0xfa, 0xa6, 0xf1, 0x3c,
      0x84, 0x8e, 0xad, 0xee, 0x38, 0x98, 0xec, 0xd9, 0x32, 0x32, 0xd4, 0x30,
      0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03,
      0x02, 0x01, 0x06, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01,
      0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x0d, 0x06, 0x09,
      0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0c, 0x05, 0x00, 0x03,
      0x82, 0x02, 0x01, 0x00, 0x0a, 0xf1, 0xd5, 0x46, 0x84, 0xb7, 0xae, 0x51,
      0xbb, 0x6c, 0xb2, 0x4d, 0x41, 0x14, 0x00, 0x93, 0x4c, 0x9c, 0xcb, 0xe5,
      0xc0, 0x54, 0xcf, 0xa0, 0x25, 0x8e, 0x02, 0xf9, 0xfd, 0xb0, 0xa2, 0x0d,
      0xf5, 0x20, 0x98, 0x3c, 0x13, 0x2d, 0xac, 0x56, 0xa2, 0xb0, 0xd6, 0x7e,
      0x11, 0x92, 0xe9, 0x2e, 0xba, 0x9e, 0x2e, 0x9a, 0x72, 0xb1, 0xbd, 0x19,
      0x44, 0x6c, 0x61, 0x35, 0xa2, 0x9a, 0xb4, 0x16, 0x12, 0x69, 0x5a, 0x8c,
      0xe1, 0xd7, 0x3e, 0xa4, 0x1a, 0xe8, 0x2f, 0x03, 0xf4, 0xae, 0x61, 0x1d,
      0x10, 0x1b, 0x2a, 0xa4, 0x8b, 0x7a, 0xc5, 0xfe, 0x05, 0xa6, 0xe1, 0xc0,
      0xd6, 0xc8, 0xfe, 0x9e, 0xae, 0x8f, 0x2b, 0xba, 0x3d, 0x99, 0xf8, 0xd8,
      0x73, 0x09, 0x58, 0x46, 0x6e, 0xa6, 0x9c, 0xf4, 0xd7, 0x27, 0xd3, 0x95,
      0xda, 0x37, 0x83, 0x72, 0x1c, 0xd3, 0x73, 0xe0, 0xa2, 0x47, 0x99, 0x03,
      0x38, 0x5d, 0xd5, 0x49, 0x79, 0x00, 0x29, 0x1c, 0xc7, 0xec, 0x9b, 0x20,
      0x1c, 0x07, 0x24, 0x69, 0x57, 0x78, 0xb2, 0x39, 0xfc, 0x3a, 0x84, 0xa0,
      0xb5, 0x9c, 0x7c, 0x8d, 0xbf, 0x2e, 0x93, 0x62, 0x27, 0xb7, 0x39, 0xda,
      0x17, 0x18, 0xae, 0xbd, 0x3c, 0x09, 0x68, 0xff, 0x84, 0x9b, 0x3c, 0xd5,
      0xd6, 0x0b, 0x03, 0xe3, 0x57, 0x9e, 0x14, 0xf7, 0xd1, 0xeb, 0x4f, 0xc8,
      0xbd, 0x87, 0x23, 0xb7, 0xb6, 0x49, 0x43, 0x79, 0x85, 0x5c, 0xba, 0xeb,
      0x92, 0x0b, 0xa1, 0xc6, 0xe8, 0x68, 0xa8, 0x4c, 0x16, 0xb1, 0x1a, 0x99,
      0x0a, 0xe8, 0x53, 0x2c, 0x92, 0xbb, 0xa1, 0x09, 0x18, 0x75, 0x0c, 0x65,
      0xa8, 0x7b, 0xcb, 0x23, 0xb7, 0x1a, 0xc2, 0x28, 0x85, 0xc3, 0x1b, 0xff,
      0xd0, 0x2b, 0x62, 0xef, 0xa4, 0x7b, 0x09, 0x91, 0x98, 0x67, 0x8c, 0x14,
      0x01, 0xcd, 0x68, 0x06, 0x6a, 0x63, 0x21, 0x75, 0x03, 0x80, 0x88, 0x8a,
      0x6e, 0x81, 0xc6, 0x85, 0xf2, 0xa9, 0xa4, 0x2d, 0xe7, 0xf4, 0xa5, 0x24,
      0x10, 0x47, 0x83, 0xca, 0xcd, 0xf4, 0x8d, 0x79, 0x58, 0xb1, 0x06, 0x9b,
      0xe7, 0x1a, 0x2a, 0xd9, 0x9d, 0x01, 0xd7, 0x94, 0x7d, 0xed, 0x03, 0x4a,
      0xca, 0xf0, 0xdb, 0xe8, 0xa9, 0x01, 0x3e, 0xf5, 0x56, 0x99, 0xc9, 0x1e,
      0x8e, 0x49, 0x3d, 0xbb, 0xe5, 0x09, 0xb9, 0xe0, 0x4f, 0x49, 0x92, 0x3d,
      0x16, 0x82, 0x40, 0xcc, 0xcc, 0x59, 0xc6, 0xe6, 0x3a, 0xed, 0x12, 0x2e,
      0x69, 0x3c, 0x6c, 0x95, 0xb1, 0xfd, 0xaa, 0x1d, 0x7b, 0x7f, 0x86, 0xbe,
      0x1e, 0x0e, 0x32, 0x46, 0xfb, 0xfb, 0x13, 0x8f, 0x75, 0x7f, 0x4c, 0x8b,
      0x4b, 0x46, 0x63, 0xfe, 0x00, 0x34, 0x40, 0x70, 0xc1, 0xc3, 0xb9, 0xa1,
      0xdd, 0xa6, 0x70, 0xe2, 0x04, 0xb3, 0x41, 0xbc, 0xe9, 0x80, 0x91, 0xea,
      0x64, 0x9c, 0x7a, 0xe1, 0x22, 0x03, 0xa9, 0x9c, 0x6e, 0x6f, 0x0e, 0x65,
      0x4f, 0x6c, 0x87, 0x87, 0x5e, 0xf3, 0x6e, 0xa0, 0xf9, 0x75, 0xa5, 0x9b,
      0x40, 0xe8, 0x53, 0xb2, 0x27, 0x9d, 0x4a, 0xb9, 0xc0, 0x77, 0x21, 0x8d,
      0xff, 0x87, 0xf2, 0xde, 0xbc, 0x8c, 0xef, 0x17, 0xdf, 0xb7, 0x49, 0x0b,
      0xd1, 0xf2, 0x6e, 0x30, 0x0b, 0x1a, 0x0e, 0x4e, 0x76, 0xed, 0x11, 0xfc,
      0xf5, 0xe9, 0x56, 0xb2, 0x7d, 0xbf, 0xc7, 0x6d, 0x0a, 0x93, 0x8c, 0xa5,
      0xd0, 0xc0, 0xb6, 0x1d, 0xbe, 0x3a, 0x4e, 0x94, 0xa2, 0xd7, 0x6e, 0x6c,
      0x0b, 0xc2, 0x8a, 0x7c, 0xfa, 0x20, 0xf3, 0xc4, 0xe4, 0xe5, 0xcd, 0x0d,
      0xa8, 0xcb, 0x91, 0x92, 0xb1, 0x7c, 0x85, 0xec, 0xb5, 0x14, 0x69, 0x66,
      0x0e, 0x82, 0xe7, 0xcd, 0xce, 0xc8, 0x2d, 0xa6, 0x51, 0x7f, 0x21, 0xc1,
      0x35, 0x53, 0x85, 0x06, 0x4a, 0x5d, 0x9f, 0xad, 0xbb, 0x1b, 0x5f, 0x74
    },
    1500
  },
  {
    "DST_Root_CA_X3",
    (const uint8_t[]){
      0x30, 0x82, 0x03, 0x4a, 0x30, 0x82, 0x02, 0x32, 0xa0, 0x03, 0x02, 0x01,
      0x02, 0x02, 0x10, 0x44, 0xaf, 0xb0, 0x80, 0xd6, 0xa3, 0x27, 0xba, 0x89,
      0x30, 0x39, 0x86, 0x2e, 0xf8, 0x40, 0x6b, 0x30, 0x0d, 0x06, 0x09, 0x2a,
      0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x3f,
      0x31, 0x24, 0x30, 0x22, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x1b, 0x44,
      0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x20, 0x53, 0x69, 0x67, 0x6e, 0x61,
      0x74, 0x75, 0x72, 0x65, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x43,
      0x6f, 0x2e, 0x31, 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13,
      0x0e, 0x44, 0x53, 0x54, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x20, 0x43, 0x41,
      0x20, 0x58, 0x33, 0x30, 0x1e, 0x17, 0x0d, 0x30, 0x30, 0x30, 0x39, 0x33,
      0x30, 0x32, 0x31, 0x31, 0x32, 0x31, 0x39, 0x5a, 0x17, 0x0d, 0x32, 0x31,
      0x30, 0x39, 0x33, 0x30, 0x31, 0x34, 0x30, 0x31, 0x31, 0x35, 0x5a, 0x30,
      0x3f, 0x31, 0x24, 0x30, 0x22, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x1b,
      0x44, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x20, 0x53, 0x69, 0x67, 0x6e,
      0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20,
      0x43, 0x6f, 0x2e, 0x31, 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x03,
      0x13, 0x0e, 0x44, 0x53, 0x54, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x20, 0x43,
      0x41, 0x20, 0x58, 0x33, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09,
      0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03,
      0x82, 0x01, 0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01,
      0x00, 0xdf, 0xaf, 0xe9, 0x97, 0x50, 0x08, 0x83, 0x57, 0xb4, 0xcc, 0x62,
      0x65, 0xf6, 0x90, 0x82, 0xec, 0xc7, 0xd3, 0x2c, 0x6b, 0x30, 0xca, 0x5b,
      0xec, 0xd9, 0xc3, 0x7d, 0xc7, 0x40, 0xc1, 0x18, 0x14, 0x8b, 0xe0, 0xe8,
      0x33, 0x76, 0x49, 0x2a, 0xe3, 0x3f, 0x21, 0x49, 0x93, 0xac, 0x4e, 0x0e,
      0xaf, 0x3e, 0x48, 0xcb, 0x65, 0xee, 0xfc, 0xd3, 0x21, 0x0f, 0x65, 0xd2,
      0x2a, 0xd9, 0x32, 0x8f, 0x8c, 0xe5, 0xf7, 0x77, 0xb0, 0x12, 0x7b, 0xb5,
      0x95, 0xc0, 0x89, 0xa3, 0xa9, 0xba, 0xed, 0x73, 0x2e, 0x7a, 0x0c, 0x06,
      0x32, 0x83, 0xa2, 0x7e, 0x8a, 0x14, 0x30, 0xcd, 0x11, 0xa0, 0xe1, 0x2a,
      0x38, 0xb9, 0x79, 0x0a, 0x31, 0xfd, 0x50, 0xbd, 0x80, 0x65, 0xdf, 0xb7,
      0x51, 0x63, 0x83, 0xc8, 0xe2, 0x88, 0x61, 0xea, 0x4b, 0x61, 0x81, 0xec,
      0x52, 0x6b, 0xb9, 0xa2, 0xe2, 0x4b, 0x1a, 0x28, 0x9f, 0x48, 0xa3, 0x9e,
      0x0c, 0xda, 0x09, 0x8e, 0x3e, 0x17, 0x2e, 0x1e, 0xdd, 0x20, 0xdf, 0x5b,
      0xc6, 0x2a, 0x8a, 0xab, 0x2e, 0xbd, 0x70, 0xad, 0xc5, 0x0b, 0x1a, 0x25,
      0x90, 0x74, 0x72, 0xc5, 0x7b, 0x6a, 0xab, 0x34, 0xd6, 0x30, 0x89, 0xff,
      0xe5, 0x68, 0x13, 0x7b, 0x54, 0x0b, 0xc8, 0xd6, 0xae, 0xec, 0x5a, 0x9c,
      0x92, 0x1e, 0x3d, 0x64, 0xb3, 0x8c, 0xc6, 0xdf, 0xbf, 0xc9, 0x41, 0x70,
      0xec, 0x16, 0x72, 0xd5, 0x26, 0xec, 0x38, 0x55, 0x39, 0x43, 0xd0, 0xfc,
      0xfd, 0x18, 0x5c, 0x40, 0xf1, 0x97, 0xeb, 0xd5, 0x9a, 0x9b, 0x8d, 0x1d,
      0xba, 0xda, 0x25, 0xb9, 0xc6, 0xd8, 0xdf, 0xc1, 0x15, 0x02, 0x3a, 0xab,
      0xda, 0x6e, 0xf1, 0x3e, 0x2e, 0xf5, 0x5c, 0x08, 0x9c, 0x3c, 0xd6, 0x83,
      0x69, 0xe4, 0x10, 0x9b, 0x19, 0x2a, 0xb6, 0x29, 0x57, 0xe3, 0xe5, 0x3d,
      0x9b, 0x9f, 0xf0, 0x02, 0x5d, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x42,
      0x30, 0x40, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff,
      0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x0e, 0x06, 0x03, 0x55,
      0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x01, 0x06, 0x30,
      0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xc4, 0xa7,
      0xb1, 0xa4, 0x7b, 0x2c, 0x71, 0xfa, 0xdb, 0xe1, 0x4b, 0x90, 0x75, 0xff,
      0xc4, 0x15, 0x60, 0x85, 0x89, 0x10, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86,
      0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x03, 0x82, 0x01,
      0x01, 0x00, 0xa3, 0x1a, 0x2c, 0x9b, 0x17, 0x00, 0x5c, 0xa9, 0x1e, 0xee,
      0x28, 0x66, 0x37, 0x3a, 0xbf, 0x83, 0xc7, 0x3f, 0x4b, 0xc3, 0x09, 0xa0,
      0x95, 0x20, 0x5d, 0xe3, 0xd9, 0x59, 0x44, 0xd2, 0x3e, 0x0d, 0x3e, 0xbd,
      0x8a, 0x4b, 0xa0, 0x74, 0x1f, 0xce, 0x10, 0x82, 0x9c, 0x74, 0x1a, 0x1d,
      0x7e, 0x98, 0x1a, 0xdd, 0xcb, 0x13, 0x4b, 0xb3, 0x20, 0x44, 0xe4, 0x91,
      0xe9, 0xcc, 0xfc, 0x7d, 0xa5, 0xdb, 0x6a, 0xe5, 0xfe, 0xe6, 0xfd, 0xe0,
      0x4e, 0xdd, 0xb7, 0x00, 0x3a, 0xb5, 0x70, 0x49, 0xaf, 0xf2, 0xe5, 0xeb,
      0x02, 0xf1, 0xd1, 0x02, 0x8b, 0x19, 0xcb, 0x94, 0x3a, 0x5e, 0x48, 0xc4,
      0x18, 0x1e, 0x58, 0x19, 0x5f, 0x1e, 0x02, 0x5a, 0xf0, 0x0c, 0xf1, 0xb1,
      0xad, 0xa9, 0xdc, 0x59, 0x86, 0x8b, 0x6e, 0xe9, 0x91, 0xf5, 0x86, 0xca,
      0xfa, 0xb9, 0x66, 0x33, 0xaa, 0x59, 0x5b, 0xce, 0xe2, 0xa7, 0x16, 0x73,
      0x47, 0xcb, 0x2b, 0xcc, 0x99, 0xb0, 0x37, 0x48, 0xcf, 0xe3, 0x56, 0x4b,
      0xf5, 0xcf, 0x0f, 0x0c, 0x72, 0x32, 0x87, 0xc6, 0xf0, 0x44, 0xbb, 0x53,
      0x72, 0x6d, 0x43, 0xf5, 0x26, 0x48, 0x9a, 0x52, 0x67, 0xb7, 0x58, 0xab,
      0xfe, 0x67, 0x76, 0x71, 0x78, 0xdb, 0x0d, 0xa2, 0x56, 0x14, 0x13, 0x39,
      0x24, 0x31, 0x85, 0xa2, 0xa8, 0x02, 0x5a, 0x30, 0x47, 0xe1, 0xdd, 0x50,
      0x07, 0xbc, 0x02, 0x09, 0x90, 0x00, 0xeb, 0x64, 0x63, 0x60, 0x9b, 0x16,
      0xbc, 0x88, 0xc9, 0x12, 0xe6, 0xd2, 0x7d, 0x91, 0x8b, 0xf9, 0x3d, 0x32,
      0x8d, 0x65, 0xb4, 0xe9, 0x7c, 0xb1, 0x57, 0x76, 0xea, 0xc5, 0xb6, 0x28,
      0x39, 0xbf, 0x15, 0x65, 0x1c, 0xc8, 0xf6, 0x77, 0x96, 0x6a, 0x0a, 0x8d,
      0x77, 0x0b, 0xd8, 0x91, 0x0b, 0x04, 0x8e, 0x07, 0xdb, 0x29, 0xb6, 0x0a,
      0xee, 0x9d, 0x82, 0x35, 0x35, 0x10
    },
    846
  },
  {
    "DigiCert_High_Assurance_EV_Root_CA",
    (const uint8_t[]){
      0x30, 0x82, 0x03, 0xc5, 0x30, 0x82, 0x02, 0xad, 0xa0, 0x03, 0x02, 0x01,
      0x02, 0x02, 0x10, 0x02, 0xac, 0x5c, 0x26, 0x6a, 0x0b, 0x40, 0x9b, 0x8f,
      0x0b, 0x79, 0xf2, 0xae, 0x46, 0x25, 0x77, 0x30, 0x0d, 0x06, 0x09, 0x2a,
      0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x6c,
      0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55,
      0x53, 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0c,
      0x44, 0x69, 0x67, 0x69, 0x43, 0x65, 0x72, 0x74, 0x20, 0x49, 0x6e, 0x63,
      0x31, 0x19, 0x30, 0x17, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x10, 0x77,
      0x77, 0x77, 0x2e, 0x64, 0x69, 0x67, 0x69, 0x63, 0x65, 0x72, 0x74, 0x2e,
      0x63, 0x6f, 0x6d, 0x31, 0x2b, 0x30, 0x29, 0x06, 0x03, 0x55, 0x04, 0x03,
      0x13, 0x22, 0x44, 0x69, 0x67, 0x69, 0x43, 0x65, 0x72, 0x74, 0x20, 0x48,
      0x69, 0x67, 0x68, 0x20, 0x41, 0x73, 0x73, 0x75, 0x72, 0x61, 0x6e, 0x63,
      0x65, 0x20, 0x45, 0x56, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x20, 0x43, 0x41,
      0x30, 0x1e, 0x17, 0x0d, 0x30, 0x36, 0x31, 0x31, 0x31, 0x30, 0x30, 0x30,
      0x30, 0x30, 0x30, 0x30, 0x5a, 0x17, 0x0d, 0x33, 0x31, 0x31, 0x31, 0x31,
      0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x30, 0x6c, 0x31, 0x0b,
      0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31,
      0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0c, 0x44, 0x69,
      0x67, 0x69, 0x43, 0x65, 0x72, 0x74, 0x20, 0x49, 0x6e, 0x63, 0x31, 0x19,
      0x30, 0x17, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x10, 0x77, 0x77, 0x77,
      0x2e, 0x64, 0x69, 0x67, 0x69, 0x63, 0x65, 0x72, 0x74, 0x2e, 0x63, 0x6f,
      0x6d, 0x31, 0x2b, 0x30, 0x29, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x22,
      0x44, 0x69, 0x67, 0x69, 0x43, 0x65, 0x72, 0x74, 0x20, 0x48, 0x69, 0x67,
      0x68, 0x20, 0x41, 0x73, 0x73, 0x75, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x20,
      0x45, 0x56, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x20, 0x43, 0x41, 0x30, 0x82,
      0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d,
      0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0f, 0x00, 0x30, 0x82,
      0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xc6, 0xcc, 0xe5, 0x73, 0xe6,
      0xfb, 0xd4, 0xbb, 0xe5, 0x2d, 0x2d, 0x32, 0xa6, 0xdf, 0xe5, 0x81, 0x3f,
      0xc9, 0xcd, 0x25, 0x49, 0xb6, 0x71, 0x2a, 0xc3, 0xd5, 0x94, 0x34, 0x67,
      0xa2, 0x0a, 0x1c, 0xb0, 0x5f, 0x69, 0xa6, 0x40, 0xb1, 0xc4, 0xb7, 0xb2,
      0x8f, 0xd0, 0x98, 0xa4, 0xa9, 0x41, 0x59, 0x3a, 0xd3, 0xdc, 0x94, 0xd6,
      0x3c, 0xdb, 0x74, 0x38, 0xa4, 0x4a, 0xcc, 0x4d, 0x25, 0x82, 0xf7, 0x4a,
      0xa5, 0x53, 0x12, 0x38, 0xee, 0xf3, 0x49, 0x6d, 0x71, 0x91, 0x7e, 0x63,
      0xb6, 0xab, 0xa6, 0x5f, 0xc3, 0xa4, 0x84, 0xf8, 0x4f, 0x62, 0x51, 0xbe,
      0xf8, 0xc5, 0xec, 0xdb, 0x38, 0x92, 0xe3, 0x06, 0xe5, 0x08, 0x91, 0x0c,
      0xc4, 0x28, 0x41, 0x55, 0xfb, 0xcb, 0x5a, 0x89, 0x15, 0x7e, 0x71, 0xe8,
      0x35, 0xbf, 0x4d, 0x72, 0x09, 0x3d, 0xbe, 0x3a, 0x38, 0x50, 0x5b, 0x77,
      0x31, 0x1b, 0x8d, 0xb3, 0xc7, 0x24, 0x45, 0x9a, 0xa7, 0xac, 0x6d, 0x00,
      0x14, 0x5a, 0x04, 0xb7, 0xba, 0x13, 0xeb, 0x51, 0x0a, 0x98, 0x41, 0x41,
      0x22, 0x4e, 0x65, 0x61, 0x87, 0x81, 0x41, 0x50, 0xa6, 0x79, 0x5c, 0x89,
      0xde, 0x19, 0x4a, 0x57, 0xd5, 0x2e, 0xe6, 0x5d, 0x1c, 0x53, 0x2c, 0x7e,
      0x98, 0xcd, 0x1a, 0x06, 0x16, 0xa4, 0x68, 0x73, 0xd0, 0x34, 0x04, 0x13,
      0x5c, 0xa1, 0x71, 0xd3, 0x5a, 0x7c, 0x55, 0xdb, 0x5e, 0x64, 0xe1, 0x37,
      0x87, 0x30, 0x56, 0x04, 0xe5, 0x11, 0xb4, 0x29, 0x80, 0x12, 0xf1, 0x79,
      0x39, 0x88, 0xa2, 0x02, 0x11, 0x7c, 0x27, 0x66, 0xb7, 0x88, 0xb7, 0x78,
      0xf2, 0xca, 0x0a, 0xa8, 0x38, 0xab, 0x0a, 0x64, 0xc2, 0xbf, 0x66, 0x5d,
      0x95, 0x84, 0xc1, 0xa1, 0x25, 0x1e, 0x87, 0x5d, 0x1a, 0x50, 0x0b, 0x20,
      0x12, 0xcc, 0x41, 0xbb, 0x6e, 0x0b, 0x51, 0x38, 0xb8, 0x4b, 0xcb, 0x02,
      0x03, 0x01, 0x00, 0x01, 0xa3, 0x63, 0x30, 0x61, 0x30, 0x0e, 0x06, 0x03,
      0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x01, 0x86,
      0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05,
      0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e,
      0x04, 0x16, 0x04, 0x14, 0xb1, 0x3e, 0xc3, 0x69, 0x03, 0xf8, 0xbf, 0x47,
      0x01, 0xd4, 0x98, 0x26, 0x1a, 0x08, 0x02, 0xef, 0x63, 0x64, 0x2b, 0xc3,
      0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80,
      0x14, 0xb1, 0x3e, 0xc3, 0x69, 0x03, 0xf8, 0xbf, 0x47, 0x01, 0xd4, 0x98,
      0x26, 0x1a, 0x08, 0x02, 0xef, 0x63, 0x64, 0x2b, 0xc3, 0x30, 0x0d, 0x06,
      0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00,
      0x03, 0x82, 0x01, 0x01, 0x00, 0x1c, 0x1a, 0x06, 0x97, 0xdc, 0xd7, 0x9c,
      0x9f, 0x3c, 0x88, 0x66, 0x06, 0x08, 0x57, 0x21, 0xdb, 0x21, 0x47, 0xf8,
      0x2a, 0x67, 0xaa, 0xbf, 0x18, 0x32, 0x76, 0x40, 0x10, 0x57, 0xc1, 0x8a,
      0xf3, 0x7a, 0xd9, 0x11, 0x65, 0x8e, 0x35, 0xfa, 0x9e, 0xfc, 0x45, 0xb5,
      0x9e, 0xd9, 0x4c, 0x31, 0x4b, 0xb8, 0x91, 0xe8, 0x43, 0x2c, 0x8e, 0xb3,
      0x78, 0xce, 0xdb, 0xe3, 0x53, 0x79, 0x71, 0xd6, 0xe5, 0x21, 0x94, 0x01,
      0xda, 0x55, 0x87, 0x9a, 0x24, 0x64, 0xf6, 0x8a, 0x66, 0xcc, 0xde, 0x9c,
      0x37, 0xcd, 0xa8, 0x34, 0xb1, 0x69, 0x9b, 0x23, 0xc8, 0x9e, 0x78, 0x22,
      0x2b, 0x70, 0x43, 0xe3, 0x55, 0x47, 0x31, 0x61, 0x19, 0xef, 0x58, 0xc5,
      0x85, 0x2f, 0x4e, 0x30, 0xf6, 0xa0, 0x31, 0x16, 0x23, 0xc8, 0xe7, 0xe2,
      0x65, 0x16, 0x33, 0xcb, 0xbf, 0x1a, 0x1b, 0xa0, 0x3d, 0xf8, 0xca, 0x5e,
      0x8b, 0x31, 0x8b, 0x60, 0x08, 0x89, 0x2d, 0x0c, 0x06, 0x5c, 0x52, 0xb7,
      0xc4, 0xf9, 0x0a, 0x98, 0xd1, 0x15, 0x5f, 0x9f, 0x12, 0xbe, 0x7c, 0x36,
      0x63, 0x38, 0xbd, 0x44, 0xa4, 0x7f, 0xe4, 0x26, 0x2b, 0x0a, 0xc4, 0x97,
      0x69, 0x0d, 0xe9, 0x8c, 0xe2, 0xc0, 0x10, 0x57, 0xb8, 0xc8, 0x76, 0x12,
      0x91, 0x55, 0xf2, 0x48, 0x69, 0xd8, 0xbc, 0x2a, 0x02, 0x5b, 0x0f, 0x44,
      0xd4, 0x20, 0x31, 0xdb, 0xf4, 0xba, 0x70, 0x26, 0x5d, 0x90, 0x60, 0x9e,
      0xbc, 0x4b, 0x17, 0x09, 0x2f, 0xb4, 0xcb, 0x1e, 0x43, 0x68, 0xc9, 0x07,
      0x27, 0xc1, 0xd2, 0x5c, 0xf7, 0xea, 0x21, 0xb9, 0x68, 0x12, 0x9c, 0x3c,
      0x9c, 0xbf, 0x9e, 0xfc, 0x80, 0x5c, 0x9b, 0x63, 0xcd, 0xec, 0x47, 0xaa,
      0x25, 0x27, 0x67, 0xa0, 0x37, 0xf3, 0x00, 0x82, 0x7d, 0x54, 0xd7, 0xa9,
      0xf8, 0xe9, 0x2e, 0x13, 0xa3, 0x77, 0xe8, 0x1f, 0x4a
    },
    969
  },
  {
    "Entrust_Root_Certification_Authority",
    (const uint8_t[]){
      0x30, 0x82, 0x04, 0x91, 0x30, 0x82, 0x03, 0x79, 0xa0, 0x03, 0x02, 0x01,
      0x02, 0x02, 0x04, 0x45, 0x6b, 0x50, 0x54, 0x30, 0x0d, 0x06, 0x09, 0x2a,
      0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x81,
      0xb0, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02,
      0x55, 0x53, 0x31, 0x16, 0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13,
      0x0d, 0x45, 0x6e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x2c, 0x20, 0x49, 0x6e,
      0x63, 0x2e, 0x31, 0x39, 0x30, 0x37, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13,
      0x30, 0x77, 0x77, 0x77, 0x2e, 0x65, 0x6e, 0x74, 0x72, 0x75, 0x73, 0x74,
      0x2e, 0x6e, 0x65, 0x74, 0x2f, 0x43, 0x50, 0x53, 0x20, 0x69, 0x73, 0x20,
      0x69, 0x6e, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74, 0x65, 0x64,
      0x20, 0x62, 0x79, 0x20, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
      0x65, 0x31, 0x1f, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x16,
      0x28, 0x63, 0x29, 0x20, 0x32, 0x30, 0x30, 0x36, 0x20, 0x45, 0x6e, 0x74,
      0x72, 0x75, 0x73, 0x74, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x2d,
      0x30, 0x2b, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x24, 0x45, 0x6e, 0x74,
      0x72, 0x75, 0x73, 0x74, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x20, 0x43, 0x65,
      0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20,
      0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x30, 0x1e, 0x17,
      0x0d, 0x30, 0x36, 0x31, 0x31, 0x32, 0x37, 0x32, 0x30, 0x32, 0x33, 0x34,
      0x32, 0x5a, 0x17, 0x0d, 0x32, 0x36, 0x31, 0x31, 0x32, 0x37, 0x32, 0x30,
      0x35, 0x33, 0x34, 0x32, 0x5a, 0x30, 0x81, 0xb0, 0x31, 0x0b, 0x30, 0x09,
      0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x16, 0x30,
      0x14, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0d, 0x45, 0x6e, 0x74, 0x72,
      0x75, 0x73, 0x74, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x39, 0x30,
      0x37, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x30, 0x77, 0x77, 0x77, 0x2e,
      0x65, 0x6e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x2e, 0x6e, 0x65, 0x74, 0x2f,
      0x43, 0x50, 0x53, 0x20, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x63, 0x6f, 0x72,
      0x70, 0x6f, 0x72, 0x61, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x72,
      0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x31, 0x1f, 0x30, 0x1d,
      0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x16, 0x28, 0x63, 0x29, 0x20, 0x32,
      0x30, 0x30, 0x36, 0x20, 0x45, 0x6e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x2c,
      0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x2d, 0x30, 0x2b, 0x06, 0x03, 0x55,
      0x04, 0x03, 0x13, 0x24, 0x45, 0x6e, 0x74, 0x72, 0x75, 0x73, 0x74, 0x20,
      0x52, 0x6f, 0x6f, 0x74, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
      0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f,
      0x72, 0x69, 0x74, 0x79, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09,
      0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03,
      0x82, 0x01, 0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01,
      0x00, 0xb6, 0x95, 0xb6, 0x43, 0x42, 0xfa, 0xc6, 0x6d, 0x2a, 0x6f, 0x48,
      0xdf, 0x94, 0x4c, 0x39, 0x57, 0x05, 0xee, 0xc3, 0x79, 0x11, 0x41, 0x68,
      0x36, 0xed, 0xec, 0xfe, 0x9a, 0x01, 0x8f, 0xa1, 0x38, 0x28, 0xfc, 0xf7,
      0x10, 0x46, 0x66, 0x2e, 0x4d, 0x1e, 0x1a, 0xb1, 0x1a, 0x4e, 0xc6, 0xd1,
      0xc0, 0x95, 0x88, 0xb0, 0xc9, 0xff, 0x31, 0x8b, 0x33, 0x03, 0xdb, 0xb7,
      0x83, 0x7b, 0x3e, 0x20, 0x84, 0x5e, 0xed, 0xb2, 0x56, 0x28, 0xa7, 0xf8,
      0xe0, 0xb9, 0x40, 0x71, 0x37, 0xc5, 0xcb, 0x47, 0x0e, 0x97, 0x2a, 0x68,
      0xc0, 0x22, 0x95, 0x62, 0x15, 0xdb, 0x47, 0xd9, 0xf5, 0xd0, 0x2b, 0xff,
      0x82, 0x4b, 0xc9, 0xad, 0x3e, 0xde, 0x4c, 0xdb, 0x90, 0x80, 0x50, 0x3f,
      0x09, 0x8a, 0x84, 0x00, 0xec, 0x30, 0x0a, 0x3d, 0x18, 0xcd, 0xfb, 0xfd,
      0x2a, 0x59, 0x9a, 0x23, 0x95, 0x17, 0x2c, 0x45, 0x9e, 0x1f, 0x6e, 0x43,
      0x79, 0x6d, 0x0c, 0x5c, 0x98, 0xfe, 0x48, 0xa7, 0xc5, 0x23, 0x47, 0x5c,
      0x5e, 0xfd, 0x6e, 0xe7, 0x1e, 0xb4, 0xf6, 0x68, 0x45, 0xd1, 0x86, 0x83,
      0x5b, 0xa2, 0x8a, 0x8d, 0xb1, 0xe3, 0x29, 0x80, 0xfe, 0x25, 0x71, 0x88,
      0xad, 0xbe, 0xbc, 0x8f, 0xac, 0x52, 0x96, 0x4b, 0xaa, 0x51, 0x8d, 0xe4,
      0x13, 0x31, 0x19, 0xe8, 0x4e, 0x4d, 0x9f, 0xdb, 0xac, 0xb3, 0x6a, 0xd5,
      0xbc, 0x39, 0x54, 0x71, 0xca, 0x7a, 0x7a, 0x7f, 0x90, 0xdd, 0x7d, 0x1d,
      0x80, 0xd9, 0x81, 0xbb, 0x59, 0x26, 0xc2, 0x11, 0xfe, 0xe6, 0x93, 0xe2,
      0xf7, 0x80, 0xe4, 0x65, 0xfb, 0x34, 0x37, 0x0e, 0x29, 0x80, 0x70, 0x4d,
      0xaf, 0x38, 0x86, 0x2e, 0x9e, 0x7f, 0x57, 0xaf, 0x9e, 0x17, 0xae, 0xeb,
      0x1c, 0xcb, 0x28, 0x21, 0x5f, 0xb6, 0x1c, 0xd8, 0xe7, 0xa2, 0x04, 0x22,
      0xf9, 0xd3, 0xda, 0xd8, 0xcb, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x81,
      0xb0, 0x30, 0x81, 0xad, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01,
      0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x01, 0x06, 0x30, 0x0f, 0x06, 0x03,
      0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01,
      0xff, 0x30, 0x2b, 0x06, 0x03, 0x55, 0x1d, 0x10, 0x04, 0x24, 0x30, 0x22,
      0x80, 0x0f, 0x32, 0x30, 0x30, 0x36, 0x31, 0x31, 0x32, 0x37, 0x32, 0x30,
      0x32, 0x33, 0x34, 0x32, 0x5a, 0x81, 0x0f, 0x32, 0x30, 0x32, 0x36, 0x31,
      0x31, 0x32, 0x37, 0x32, 0x30, 0x35, 0x33, 0x34, 0x32, 0x5a, 0x30, 0x1f,
      0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x68,
      0x90, 0xe4, 0x67, 0xa4, 0xa6, 0x53, 0x80, 0xc7, 0x86, 0x66, 0xa4, 0xf1,
      0xf7, 0x4b, 0x43, 0xfb, 0x84, 0xbd, 0x6d, 0x30, 0x1d, 0x06, 0x03, 0x55,
      0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x68, 0x90, 0xe4, 0x67, 0xa4, 0xa6,
      0x53, 0x80, 0xc7, 0x86, 0x66, 0xa4, 0xf1, 0xf7, 0x4b, 0x43, 0xfb, 0x84,
      0xbd, 0x6d, 0x30, 0x1d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf6, 0x7d,
      0x07, 0x41, 0x00, 0x04, 0x10, 0x30, 0x0e, 0x1b, 0x08, 0x56, 0x37, 0x2e,
      0x31, 0x3a, 0x34, 0x2e, 0x30, 0x03, 0x02, 0x04, 0x90, 0x30, 0x0d, 0x06,
      0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00,
      0x03, 0x82, 0x01, 0x01, 0x00, 0x93, 0xd4, 0x30, 0xb0, 0xd7, 0x03, 0x20,
      0x2a, 0xd0, 0xf9, 0x63, 0xe8, 0x91, 0x0c, 0x05, 0x20, 0xa9, 0x5f, 0x19,
      0xca, 0x7b, 0x72, 0x4e, 0xd4, 0xb1, 0xdb, 0xd0, 0x96, 0xfb, 0x54, 0x5a,
      0x19, 0x2c, 0x0c, 0x08, 0xf7, 0xb2, 0xbc, 0x85, 0xa8, 0x9d, 0x7f, 0x6d,
      0x3b, 0x52, 0xb3, 0x2a, 0xdb, 0xe7, 0xd4, 0x84, 0x8c, 0x63, 0xf6, 0x0f,
      0xcb, 0x26, 0x01, 0x91, 0x50, 0x6c, 0xf4, 0x5f, 0x14, 0xe2, 0x93, 0x74,
      0xc0, 0x13, 0x9e, 0x30, 0x3a, 0x50, 0xe3, 0xb4, 0x60, 0xc5, 0x1c, 0xf0,
      0x22, 0x44, 0x8d, 0x71, 0x47, 0xac, 0xc8, 0x1a, 0xc9, 0xe9, 0x9b, 0x9a,
      0x00, 0x60, 0x13, 0xff, 0x70, 0x7e, 0x5f, 0x11, 0x4d, 0x49, 0x1b, 0xb3,
      0x15, 0x52, 0x7b, 0xc9, 0x54, 0xda, 0xbf, 0x9d, 0x95, 0xaf, 0x6b, 0x9a,
      0xd8, 0x9e, 0xe9, 0xf1, 0xe4, 0x43, 0x8d, 0xe2, 0x11, 0x44, 0x3a, 0xbf,
      0xaf, 0xbd, 0x83, 0x42, 0x73, 0x52, 0x8b, 0xaa, 0xbb, 0xa7, 0x29, 0xcf,
      0xf5, 0x64, 0x1c, 0x0a, 0x4d, 0xd1, 0xbc, 0xaa, 0xac, 0x9f, 0x2a, 0xd0,
      0xff, 0x7f, 0x7f, 0xda, 0x7d, 0xea, 0xb1, 0xed, 0x30, 0x25, 0xc1, 0x84,
      0xda, 0x34, 0xd2, 0x5b, 0x78, 0x83, 0x56, 0xec, 0x9c, 0x36, 0xc3, 0x26,
      0xe2, 0x11, 0xf6, 0x67, 0x49, 0x1d, 0x92, 0xab, 0x8c, 0xfb, 0xeb, 0xff,
      0x7a, 0xee, 0x85, 0x4a, 0xa7, 0x50, 0x80, 0xf0, 0xa7, 0x5c, 0x4a, 0x94,
      0x2e, 0x5f, 0x05, 0x99, 0x3c, 0x52, 0x41, 0xe0, 0xcd, 0xb4, 0x63, 0xcf,
      0x01, 0x43, 0xba, 0x9c, 0x83, 0xdc, 0x8f, 0x60, 0x3b, 0xf3, 0x5a, 0xb4,
      0xb4, 0x7b, 0xae, 0xda, 0x0b, 0x90, 0x38, 0x75, 0xef, 0x81, 0x1d, 0x66,
      0xd2, 0xf7, 0x57, 0x70, 0x36, 0xb3, 0xbf, 0xfc, 0x28, 0xaf, 0x71, 0x25,
      0x85, 0x5b, 0x13, 0xfe, 0x1e, 0x7f, 0x5a, 0xb4, 0x3c
    },
    1173
  },
  {
    "Equifax_Secure_Certificate_Authority",
    (const uint8_t[]){
      0x30, 0x82, 0x03, 0x20, 0x30, 0x82, 0x02, 0x89, 0xa0, 0x03, 0x02, 0x01,
      0x02, 0x02, 0x04, 0x35, 0xde, 0xf4, 0xcf, 0x30, 0x0d, 0x06, 0x09, 0x2a,
      0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x4e,
      0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55,
      0x53, 0x31, 0x10, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x07,
      0x45, 0x71, 0x75, 0x69, 0x66, 0x61, 0x78, 0x31, 0x2d, 0x30, 0x2b, 0x06,
      0x03, 0x55, 0x04, 0x0b, 0x13, 0x24, 0x45, 0x71, 0x75, 0x69, 0x66, 0x61,
      0x78, 0x20, 0x53, 0x65, 0x63, 0x75, 0x72, 0x65, 0x20, 0x43, 0x65, 0x72,
      0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x20, 0x41, 0x75, 0x74,
      0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x30, 0x1e, 0x17, 0x0d, 0x39, 0x38,
      0x30, 0x38, 0x32, 0x32, 0x31, 0x36, 0x34, 0x31, 0x35, 0x31, 0x5a, 0x17,
      0x0d, 0x31, 0x38, 0x30, 0x38, 0x32, 0x32, 0x31, 0x36, 0x34, 0x31, 0x35,
      0x31, 0x5a, 0x30, 0x4e, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04,
      0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x10, 0x30, 0x0e, 0x06, 0x03, 0x55,
      0x04, 0x0a, 0x13, 0x07, 0x45, 0x71, 0x75, 0x69, 0x66, 0x61, 0x78, 0x31,
      0x2d, 0x30, 0x2b, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x24, 0x45, 0x71,
      0x75, 0x69, 0x66, 0x61, 0x78, 0x20, 0x53, 0x65, 0x63, 0x75, 0x72, 0x65,
      0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
      0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x30, 0x81,
      0x9f, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01,
      0x01, 0x01, 0x05, 0x00, 0x03, 0x81, 0x8d, 0x00, 0x30, 0x81, 0x89, 0x02,
      0x81, 0x81, 0x00, 0xc1, 0x5d, 0xb1, 0x58, 0x67, 0x08, 0x62, 0xee, 0xa0,
      0x9a, 0x2d, 0x1f, 0x08, 0x6d, 0x91, 0x14, 0x68, 0x98, 0x0a, 0x1e, 0xfe,
      0xda, 0x04, 0x6f, 0x13, 0x84, 0x62, 0x21, 0xc3, 0xd1, 0x7c, 0xce, 0x9f,
      0x05, 0xe0, 0xb8, 0x01, 0xf0, 0x4e, 0x34, 0xec, 0xe2, 0x8a, 0x95, 0x04,
      0x64, 0xac, 0xf1, 0x6b, 0x53, 0x5f, 0x05, 0xb3, 0xcb, 0x67, 0x80, 0xbf,
      0x42, 0x02, 0x8e, 0xfe, 0xdd, 0x01, 0x09, 0xec, 0xe1, 0x00, 0x14, 0x4f,
      0xfc, 0xfb, 0xf0, 0x0c, 0xdd, 0x43, 0xba, 0x5b, 0x2b, 0xe1, 0x1f, 0x80,
      0x70, 0x99, 0x15, 0x57, 0x93, 0x16, 0xf1, 0x0f, 0x97, 0x6a, 0xb7, 0xc2,
      0x68, 0x23, 0x1c, 0xcc, 0x4d, 0x59, 0x30, 0xac, 0x51, 0x1e, 0x3b, 0xaf,
      0x2b, 0xd6, 0xee, 0x63, 0x45, 0x7b, 0xc5, 0xd9, 0x5f, 0x50, 0xd2, 0xe3,
      0x50, 0x0f, 0x3a, 0x88, 0xe7, 0xbf, 0x14, 0xfd, 0xe0, 0xc7, 0xb9, 0x02,
      0x03, 0x01, 0x00, 0x01, 0xa3, 0x82, 0x01, 0x09, 0x30, 0x82, 0x01, 0x05,
      0x30, 0x70, 0x06, 0x03, 0x55, 0x1d, 0x1f, 0x04, 0x69, 0x30, 0x67, 0x30,
      0x65, 0xa0, 0x63, 0xa0, 0x61, 0xa4, 0x5f, 0x30, 0x5d, 0x31, 0x0b, 0x30,
      0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x10,
      0x30, 0x0e, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x07, 0x45, 0x71, 0x75,
      0x69, 0x66, 0x61, 0x78, 0x31, 0x2d, 0x30, 0x2b, 0x06, 0x03, 0x55, 0x04,
      0x0b, 0x13, 0x24, 0x45, 0x71, 0x75, 0x69, 0x66, 0x61, 0x78, 0x20, 0x53,
      0x65, 0x63, 0x75, 0x72, 0x65, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
      0x69, 0x63, 0x61, 0x74, 0x65, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
      0x69, 0x74, 0x79, 0x31, 0x0d, 0x30, 0x0b, 0x06, 0x03, 0x55, 0x04, 0x03,
      0x13, 0x04, 0x43, 0x52, 0x4c, 0x31, 0x30, 0x1a, 0x06, 0x03, 0x55, 0x1d,
      0x10, 0x04, 0x13, 0x30, 0x11, 0x81, 0x0f, 0x32, 0x30, 0x31, 0x38, 0x30,
      0x38, 0x32, 0x32, 0x31, 0x36, 0x34, 0x31, 0x35, 0x31, 0x5a, 0x30, 0x0b,
      0x06, 0x03, 0x55, 0x1d, 0x0f, 0x04, 0x04, 0x03, 0x02, 0x01, 0x06, 0x30,
      0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14,
      0x48, 0xe6, 0x68, 0xf9, 0x2b, 0xd2, 0xb2, 0x95, 0xd7, 0x47, 0xd8, 0x23,
      0x20, 0x10, 0x4f, 0x33, 0x98, 0x90, 0x9f, 0xd4, 0x30, 0x1d, 0x06, 0x03,
      0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x48, 0xe6, 0x68, 0xf9, 0x2b,
      0xd2, 0xb2, 0x95, 0xd7, 0x47, 0xd8, 0x23, 0x20, 0x10, 0x4f, 0x33, 0x98,
      0x90, 0x9f, 0xd4, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x04, 0x05,
      0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x1a, 0x06, 0x09, 0x2a, 0x86, 0x48,
      0x86, 0xf6, 0x7d, 0x07, 0x41, 0x00, 0x04, 0x0d, 0x30, 0x0b, 0x1b, 0x05,
      0x56, 0x33, 0x2e, 0x30, 0x63, 0x03, 0x02, 0x06, 0xc0, 0x30, 0x0d, 0x06,
      0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00,
      0x03, 0x81, 0x81, 0x00, 0x58, 0xce, 0x29, 0xea, 0xfc, 0xf7, 0xde, 0xb5,
      0xce, 0x02, 0xb9, 0x17, 0xb5, 0x85, 0xd1, 0xb9, 0xe3, 0xe0, 0x95, 0xcc,
      0x25, 0x31, 0x0d, 0x00, 0xa6, 0x92, 0x6e, 0x7f, 0xb6, 0x92, 0x63, 0x9e,
      0x50, 0x95, 0xd1, 0x9a, 0x6f, 0xe4, 0x11, 0xde, 0x63, 0x85, 0x6e, 0x98,
      0xee, 0xa8, 0xff, 0x5a, 0xc8, 0xd3, 0x55, 0xb2, 0x66, 0x71, 0x57, 0xde,
      0xc0, 0x21, 0xeb, 0x3d, 0x2a, 0xa7, 0x23, 0x49, 0x01, 0x04, 0x86, 0x42,
      0x7b, 0xfc, 0xee, 0x7f, 0xa2, 0x16, 0x52, 0xb5, 0x67, 0x67, 0xd3, 0x40,
      0xdb, 0x3b, 0x26, 0x58, 0xb2, 0x28, 0x77, 0x3d, 0xae, 0x14, 0x77, 0x61,
      0xd6, 0xfa, 0x2a, 0x66, 0x27, 0xa0, 0x0d, 0xfa, 0xa7, 0x73, 0x5c, 0xea,
      0x70, 0xf1, 0x94, 0x21, 0x65, 0x44, 0x5f, 0xfa, 0xfc, 0xef, 0x29, 0x68,
      0xa9, 0xa2, 0x87, 0x79, 0xef, 0x79, 0xef, 0x4f, 0xac, 0x07, 0x77, 0x38
    },
    804
  },
  {
    "GeoTrust_Global_CA",
    (const uint8_t[]){
      0x30, 0x82, 0x03, 0x54, 0x30, 0x82, 0x02, 0x3c, 0xa0, 0x03, 0x02, 0x01,
      0x02, 0x02, 0x03, 0x02, 0x34, 0x56, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86,
      0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x42, 0x31,
      0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53,
      0x31, 0x16, 0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0d, 0x47,
      0x65, 0x6f, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x49, 0x6e, 0x63, 0x2e,
      0x31, 0x1b, 0x30, 0x19, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x12, 0x47,
      0x65, 0x6f, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x47, 0x6c, 0x6f, 0x62,
      0x61, 0x6c, 0x20, 0x43, 0x41, 0x30, 0x1e, 0x17, 0x0d, 0x30, 0x32, 0x30,
      0x35, 0x32, 0x31, 0x30, 0x34, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x17, 0x0d,
      0x32, 0x32, 0x30, 0x35, 0x32, 0x31, 0x30, 0x34, 0x30, 0x30, 0x30, 0x30,
      0x5a, 0x30, 0x42, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06,
      0x13, 0x02, 0x55, 0x53, 0x31, 0x16, 0x30, 0x14, 0x06, 0x03, 0x55, 0x04,
      0x0a, 0x13, 0x0d, 0x47, 0x65, 0x6f, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20,
      0x49, 0x6e, 0x63, 0x2e, 0x31, 0x1b, 0x30, 0x19, 0x06, 0x03, 0x55, 0x04,
      0x03, 0x13, 0x12, 0x47, 0x65, 0x6f, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20,
      0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x20, 0x43, 0x41, 0x30, 0x82, 0x01,
      0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01,
      0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0f, 0x00, 0x30, 0x82, 0x01,
      0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xda, 0xcc, 0x18, 0x63, 0x30, 0xfd,
      0xf4, 0x17, 0x23, 0x1a, 0x56, 0x7e, 0x5b, 0xdf, 0x3c, 0x6c, 0x38, 0xe4,
      0x71, 0xb7, 0x78, 0x91, 0xd4, 0xbc, 0xa1, 0xd8, 0x4c, 0xf8, 0xa8, 0x43,
      0xb6, 0x03, 0xe9, 0x4d, 0x21, 0x07, 0x08, 0x88, 0xda, 0x58, 0x2f, 0x66,
      0x39, 0x29, 0xbd, 0x05, 0x78, 0x8b, 0x9d, 0x38, 0xe8, 0x05, 0xb7, 0x6a,
      0x7e, 0x71, 0xa4, 0xe6, 0xc4, 0x60, 0xa6, 0xb0, 0xef, 0x80, 0xe4, 0x89,
      0x28, 0x0f, 0x9e, 0x25, 0xd6, 0xed, 0x83, 0xf3, 0xad, 0xa6, 0x91, 0xc7,
      0x98, 0xc9, 0x42, 0x18, 0x35, 0x14, 0x9d, 0xad, 0x98, 0x46, 0x92, 0x2e,
      0x4f, 0xca, 0xf1, 0x87, 0x43, 0xc1, 0x16, 0x95, 0x57, 0x2d, 0x50, 0xef,
      0x89, 0x2d, 0x80, 0x7a, 0x57, 0xad, 0xf2, 0xee, 0x5f, 0x6b, 0xd2, 0x00,
      0x8d, 0xb9, 0x14, 0xf8, 0x14, 0x15, 0x35, 0xd9, 0xc0, 0x46, 0xa3, 0x7b,
      0x72, 0xc8, 0x91, 0xbf, 0xc9, 0x55, 0x2b, 0xcd, 0xd0, 0x97, 0x3e, 0x9c,
      0x26, 0x64, 0xcc, 0xdf, 0xce, 0x83, 0x19, 0x71, 0xca, 0x4e, 0xe6, 0xd4,
      0xd5, 0x7b, 0xa9, 0x19, 0xcd, 0x55, 0xde, 0xc8, 0xec, 0xd2, 0x5e, 0x38,
      0x53, 0xe5, 0x5c, 0x4f, 0x8c, 0x2d, 0xfe, 0x50, 0x23, 0x36, 0xfc, 0x66,
      0xe6, 0xcb, 0x8e, 0xa4, 0x39, 0x19, 0x00, 0xb7, 0x95, 0x02, 0x39, 0x91,
      0x0b, 0x0e, 0xfe, 0x38, 0x2e, 0xd1, 0x1d, 0x05, 0x9a, 0xf6, 0x4d, 0x3e,
      0x6f, 0x0f, 0x07, 0x1d, 0xaf, 0x2c, 0x1e, 0x8f, 0x60, 0x39, 0xe2, 0xfa,
      0x36, 0x53, 0x13, 0x39, 0xd4, 0x5e, 0x26, 0x2b, 0xdb, 0x3d, 0xa8, 0x14,
      0xbd, 0x32, 0xeb, 0x18, 0x03, 0x28, 0x52, 0x04, 0x71, 0xe5, 0xab, 0x33,
      0x3d, 0xe1, 0x38, 0xbb, 0x07, 0x36, 0x84, 0x62, 0x9c, 0x79, 0xea, 0x16,
      0x30, 0xf4, 0x5f, 0xc0, 0x2b, 0xe8, 0x71, 0x6b, 0xe4, 0xf9, 0x02, 0x03,
      0x01, 0x00, 0x01, 0xa3, 0x53, 0x30, 0x51, 0x30, 0x0f, 0x06, 0x03, 0x55,
      0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff,
      0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xc0,
      0x7a, 0x98, 0x68, 0x8d, 0x89, 0xfb, 0xab, 0x05, 0x64, 0x0c, 0x11, 0x7d,
      0xaa, 0x7d, 0x65, 0xb8, 0xca, 0xcc, 0x4e, 0x30, 0x1f, 0x06, 0x03, 0x55,
      0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xc0, 0x7a, 0x98, 0x68,
      0x8d, 0x89, 0xfb, 0xab, 0x05, 0x64, 0x0c, 0x11, 0x7d, 0xaa, 0x7d, 0x65,
      0xb8, 0xca, 0xcc, 0x4e, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
      0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00,
      0x35, 0xe3, 0x29, 0x6a, 0xe5, 0x2f, 0x5d, 0x54, 0x8e, 0x29, 0x50, 0x94,
      0x9f, 0x99, 0x1a, 0x14, 0xe4, 0x8f, 0x78, 0x2a, 0x62, 0x94, 0xa2, 0x27,
      0x67, 0x9e, 0xd0, 0xcf, 0x1a, 0x5e, 0x47, 0xe9, 0xc1, 0xb2, 0xa4, 0xcf,
      0xdd, 0x41, 0x1a, 0x05, 0x4e, 0x9b, 0x4b, 0xee, 0x4a, 0x6f, 0x55, 0x52,
      0xb3, 0x24, 0xa1, 0x37, 0x0a, 0xeb, 0x64, 0x76, 0x2a, 0x2e, 0x2c, 0xf3,
      0xfd, 0x3b, 0x75, 0x90, 0xbf, 0xfa, 0x71, 0xd8, 0xc7, 0x3d, 0x37, 0xd2,
      0xb5, 0x05, 0x95, 0x62, 0xb9, 0xa6, 0xde, 0x89, 0x3d, 0x36, 0x7b, 0x38,
      0x77, 0x48, 0x97, 0xac, 0xa6, 0x20, 0x8f, 0x2e, 0xa6, 0xc9, 0x0c, 0xc2,
      0xb2, 0x99, 0x45, 0x00, 0xc7, 0xce, 0x11, 0x51, 0x22, 0x22, 0xe0, 0xa5,
      0xea, 0xb6, 0x15, 0x48, 0x09, 0x64, 0xea, 0x5e, 0x4f, 0x74, 0xf7, 0x05,
      0x3e, 0xc7, 0x8a, 0x52, 0x0c, 0xdb, 0x15, 0xb4, 0xbd, 0x6d, 0x9b, 0xe5,
      0xc6, 0xb1, 0x54, 0x68, 0xa9, 0xe3, 0x69, 0x90, 0xb6, 0x9a, 0xa5, 0x0f,
      0xb8, 0xb9, 0x3f, 0x20, 0x7d, 0xae, 0x4a, 0xb5, 0xb8, 0x9c, 0xe4, 0x1d,
      0xb6, 0xab, 0xe6, 0x94, 0xa5, 0xc1, 0xc7, 0x83, 0xad, 0xdb, 0xf5, 0x27,
      0x87, 0x0e, 0x04, 0x6c, 0xd5, 0xff, 0xdd, 0xa0, 0x5d, 0xed, 0x87, 0x52,
      0xb7, 0x2b, 0x15, 0x02, 0xae, 0x39, 0xa6, 0x6a, 0x74, 0xe9, 0xda, 0xc4,
      0xe7, 0xbc, 0x4d, 0x34, 0x1e, 0xa9, 0x5c, 0x4d, 0x33, 0x5f, 0x92, 0x09,
      0x2f, 0x88, 0x66, 0x5d, 0x77, 0x97, 0xc7, 0x1d, 0x76, 0x13, 0xa9, 0xd5,
      0xe5, 0xf1, 0x16, 0x09, 0x11, 0x35, 0xd5, 0xac, 0xdb, 0x24, 0x71, 0x70,
      0x2c, 0x98, 0x56, 0x0b, 0xd9, 0x17, 0xb4, 0xd1, 0xe3, 0x51, 0x2b, 0x5e,
      0x75, 0xe8, 0xd5, 0xd0, 0xdc, 0x4f, 0x34, 0xed, 0xc2, 0x05, 0x66, 0x80,
      0xa1, 0xcb, 0xe6, 0x33
    },
    856
  },
  {
    "GeoTrust_Primary_Certification_Authority_G3",
    (const uint8_t[]){
      0x30, 0x82, 0x03, 0xfe, 0x30, 0x82, 0x02, 0xe6, 0xa0, 0x03, 0x02, 0x01,
      0x02, 0x02, 0x10, 0x15, 0xac, 0x6e, 0x94, 0x19, 0xb2, 0x79, 0x4b, 0x41,
      0xf6, 0x27, 0xa9, 0xc3, 0x18, 0x0f, 0x1f, 0x30, 0x0d, 0x06, 0x09, 0x2a,
      0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x30, 0x81,
      0x98, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02,
      0x55, 0x53, 0x31, 0x16, 0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13,
      0x0d, 0x47, 0x65, 0x6f, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x49, 0x6e,
      0x63, 0x2e, 0x31, 0x39, 0x30, 0x37, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13,
      0x30, 0x28, 0x63, 0x29, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x47, 0x65,
      0x6f, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x20,
      0x2d, 0x20, 0x46, 0x6f, 0x72, 0x20, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
      0x69, 0x7a, 0x65, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x6e, 0x6c,
      0x79, 0x31, 0x36, 0x30, 0x34, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x2d,
      0x47, 0x65, 0x6f, 0x54, 0x72, 0x75, 0x73, 0x74, 0x20, 0x50, 0x72, 0x69,
      0x6d, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
      0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f,
      0x72, 0x69, 0x74, 0x79, 0x20, 0x2d, 0x20, 0x47, 0x33, 0x30, 0x1e, 0x17,
      0x0d, 0x30, 0x38, 0x30, 0x34, 0x30, 0x32, 0x30, 0x30, 0x30, 0x30, 0x30,
      0x30, 0x5a, 0x17, 0x0d, 0x33, 0x37, 0x31, 0x32, 0x30, 0x31, 0x32, 0x33,
      0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x81, 0x98, 0x31, 0x0b, 0x30, 0x09,
      0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x16, 0x30,
      0x14, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0d, 0x47, 0x65, 0x6f, 0x54,
      0x72, 0x75, 0x73, 0x74, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x39, 0x30,
      0x37, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x30, 0x28, 0x63, 0x29, 0x20,
      0x32, 0x30, 0x30, 0x38, 0x20, 0x47, 0x65, 0x6f, 0x54, 0x72, 0x75, 0x73,
      0x74, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x20, 0x2d, 0x20, 0x46, 0x6f, 0x72,
      0x20, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x20,
      0x75, 0x73, 0x65, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x31, 0x36, 0x30, 0x34,
      0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x2d, 0x47, 0x65, 0x6f, 0x54, 0x72,
      0x75, 0x73, 0x74, 0x20, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x20,
      0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
      0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x20,
      0x2d, 0x20, 0x47, 0x33, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09,
      0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03,
      0x82, 0x01, 0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01,
      0x00, 0xdc, 0xe2, 0x5e, 0x62, 0x58, 0x1d, 0x33, 0x57, 0x39, 0x32, 0x33,
      0xfa, 0xeb, 0xcb, 0x87, 0x8c, 0xa7, 0xd4, 0x4a, 0xdd, 0x06, 0x88, 0xea,
      0x64, 0x8e, 0x31, 0x98, 0xa5, 0x38, 0x90, 0x1e, 0x98, 0xcf, 0x2e, 0x63,
      0x2b, 0xf0, 0x46, 0xbc, 0x44, 0xb2, 0x89, 0xa1, 0xc0, 0x28, 0x0c, 0x49,
      0x70, 0x21, 0x95, 0x9f, 0x64, 0xc0, 0xa6, 0x93, 0x12, 0x02, 0x65, 0x26,
      0x86, 0xc6, 0xa5, 0x89, 0xf0, 0xfa, 0xd7, 0x84, 0xa0, 0x70, 0xaf, 0x4f,
      0x1a, 0x97, 0x3f, 0x06, 0x44, 0xd5, 0xc9, 0xeb, 0x72, 0x10, 0x7d, 0xe4,
      0x31, 0x28, 0xfb, 0x1c, 0x61, 0xe6, 0x28, 0x07, 0x44, 0x73, 0x92, 0x22,
      0x69, 0xa7, 0x03, 0x88, 0x6c, 0x9d, 0x63, 0xc8, 0x52, 0xda, 0x98, 0x27,
      0xe7, 0x08, 0x4c, 0x70, 0x3e, 0xb4, 0xc9, 0x12, 0xc1, 0xc5, 0x67, 0x83,
      0x5d, 0x33, 0xf3, 0x03, 0x11, 0xec, 0x6a, 0xd0, 0x53, 0xe2, 0xd1, 0xba,
      0x36, 0x60, 0x94, 0x80, 0xbb, 0x61, 0x63, 0x6c, 0x5b, 0x17, 0x7e, 0xdf,
      0x40, 0x94, 0x1e, 0xab, 0x0d, 0xc2, 0x21, 0x28, 0x70, 0x88, 0xff, 0xd6,
      0x26, 0x6c, 0x6c, 0x60, 0x04, 0x25, 0x4e, 0x55, 0x7e, 0x7d, 0xef, 0xbf,
      0x94, 0x48, 0xde, 0xb7, 0x1d, 0xdd, 0x70, 0x8d, 0x05, 0x5f, 0x88, 0xa5,
      0x9b, 0xf2, 0xc2, 0xee, 0xea, 0xd1, 0x40, 0x41, 0x6d, 0x62, 0x38, 0x1d,
      0x56, 0x06, 0xc5, 0x03, 0x47, 0x51, 0x20, 0x19, 0xfc, 0x7b, 0x10, 0x0b,
      0x0e, 0x62, 0xae, 0x76, 0x55, 0xbf, 0x5f, 0x77, 0xbe, 0x3e, 0x49, 0x01,
      0x53, 0x3d, 0x98, 0x25, 0x03, 0x76, 0x24, 0x5a, 0x1d, 0xb4, 0xdb, 0x89,
      0xea, 0x79, 0xe5, 0xb6, 0xb3, 0x3b, 0x3f, 0xba, 0x4c, 0x28, 0x41, 0x7f,
      0x06, 0xac, 0x6a, 0x8e, 0xc1, 0xd0, 0xf6, 0x05, 0x1d, 0x7d, 0xe6, 0x42,
      0x86, 0xe3, 0xa5, 0xd5, 0x47, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x42,
      0x30, 0x40, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff,
      0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x0e, 0x06, 0x03, 0x55,
      0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x01, 0x06, 0x30,
      0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xc4, 0x79,
      0xca, 0x8e, 0xa1, 0x4e, 0x03, 0x1d, 0x1c, 0xdc, 0x6b, 0xdb, 0x31, 0x5b,
      0x94, 0x3e, 0x3f, 0x30, 0x7f, 0x2d, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86,
      0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x03, 0x82, 0x01,
      0x01, 0x00, 0x2d, 0xc5, 0x13, 0xcf, 0x56, 0x80, 0x7b, 0x7a, 0x78, 0xbd,
      0x9f, 0xae, 0x2c, 0x99, 0xe7, 0xef, 0xda, 0xdf, 0x94, 0x5e, 0x09, 0x69,
      0xa7, 0xe7, 0x6e, 0x68, 0x8c, 0xbd, 0x72, 0xbe, 0x47, 0xa9, 0x0e, 0x97,
      0x12, 0xb8, 0x4a, 0xf1, 0x64, 0xd3, 0x39, 0xdf, 0x25, 0x34, 0xd4, 0xc1,
      0xcd, 0x4e, 0x81, 0xf0, 0x0f, 0x04, 0xc4, 0x24, 0xb3, 0x34, 0x96, 0xc6,
      0xa6, 0xaa, 0x30, 0xdf, 0x68, 0x61, 0x73, 0xd7, 0xf9, 0x8e, 0x85, 0x89,
      0xef, 0x0e, 0x5e, 0x95, 0x28, 0x4a, 0x2a, 0x27, 0x8f, 0x10, 0x8e, 0x2e,
      0x7c, 0x86, 0xc4, 0x02, 0x9e, 0xda, 0x0c, 0x77, 0x65, 0x0e, 0x44, 0x0d,
      0x92, 0xfd, 0xfd, 0xb3, 0x16, 0x36, 0xfa, 0x11, 0x0d, 0x1d, 0x8c, 0x0e,
      0x07, 0x89, 0x6a, 0x29, 0x56, 0xf7, 0x72, 0xf4, 0xdd, 0x15, 0x9c, 0x77,
      0x35, 0x66, 0x57, 0xab, 0x13, 0x53, 0xd8, 0x8e, 0xc1, 0x40, 0xc5, 0xd7,
      0x13, 0x16, 0x5a, 0x72, 0xc7, 0xb7, 0x69, 0x01, 0xc4, 0x7a, 0xb1, 0x83,
      0x01, 0x68, 0x7d, 0x8d, 0x41, 0xa1, 0x94, 0x18, 0xc1, 0x25, 0x5c, 0xfc,
      0xf0, 0xfe, 0x83, 0x02, 0x87, 0x7c, 0x0d, 0x0d, 0xcf, 0x2e, 0x08, 0x5c,
      0x4a, 0x40, 0x0d, 0x3e, 0xec, 0x81, 0x61, 0xe6, 0x24, 0xdb, 0xca, 0xe0,
      0x0e, 0x2d, 0x07, 0xb2, 0x3e, 0x56, 0xdc, 0x8d, 0xf5, 0x41, 0x85, 0x07,
      0x48, 0x9b, 0x0c, 0x0b, 0xcb, 0x49, 0x3f, 0x7d, 0xec, 0xb7, 0xfd, 0xcb,
      0x8d, 0x67, 0x89, 0x1a, 0xab, 0xed, 0xbb, 0x1e, 0xa3, 0x00, 0x08, 0x08,
      0x17, 0x2a, 0x82, 0x5c, 0x31, 0x5d, 0x46, 0x8a, 0x2d, 0x0f, 0x86, 0x9b,
      0x74, 0xd9, 0x45, 0xfb, 0xd4, 0x40, 0xb1, 0x7a, 0xaa, 0x68, 0x2d, 0x86,
      0xb2, 0x99, 0x22, 0xe1, 0xc1, 0x2b, 0xc7, 0x9c, 0xf8, 0xf3, 0x5f, 0xa8,
      0x82, 0x12, 0xeb, 0x19, 0x11, 0x2d
    },
    1026
  },
  {
    "GlobalSign",
    (const uint8_t[]){
      0x30, 0x82, 0x03, 0xba, 0x30, 0x82, 0x02, 0xa2, 0xa0, 0x03, 0x02, 0x01,
      0x02, 0x02, 0x0b, 0x04, 0x00, 0x00, 0x00, 0x00, 0x01, 0x0f, 0x86, 0x26,
      0xe6, 0x0d, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d,
      0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x4c, 0x31, 0x20, 0x30, 0x1e, 0x06,
      0x03, 0x55, 0x04, 0x0b, 0x13, 0x17, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c,
      0x53, 0x69, 0x67, 0x6e, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x20, 0x43, 0x41,
      0x20, 0x2d, 0x20, 0x52, 0x32, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55,
      0x04, 0x0a, 0x13, 0x0a, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69,
      0x67, 0x6e, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13,
      0x0a, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x67, 0x6e, 0x30,
      0x1e, 0x17, 0x0d, 0x30, 0x36, 0x31, 0x32, 0x31, 0x35, 0x30, 0x38, 0x30,
      0x30, 0x30, 0x30, 0x5a, 0x17, 0x0d, 0x32, 0x31, 0x31, 0x32, 0x31, 0x35,
      0x30, 0x38, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x30, 0x4c, 0x31, 0x20, 0x30,
      0x1e, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x17, 0x47, 0x6c, 0x6f, 0x62,
      0x61, 0x6c, 0x53, 0x69, 0x67, 0x6e, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x20,
      0x43, 0x41, 0x20, 0x2d, 0x20, 0x52, 0x32, 0x31, 0x13, 0x30, 0x11, 0x06,
      0x03, 0x55, 0x04, 0x0a, 0x13, 0x0a, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c,
      0x53, 0x69, 0x67, 0x6e, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04,
      0x03, 0x13, 0x0a, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x69, 0x67,
      0x6e, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48,
      0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0f,
      0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xa6, 0xcf,
      0x24, 0x0e, 0xbe, 0x2e, 0x6f, 0x28, 0x99, 0x45, 0x42, 0xc4, 0xab, 0x3e,
      0x21, 0x54, 0x9b, 0x0b, 0xd3, 0x7f, 0x84, 0x70, 0xfa, 0x12, 0xb3, 0xcb,
      0xbf, 0x87, 0x5f, 0xc6, 0x7f, 0x86, 0xd3, 0xb2, 0x30, 0x5c, 0xd6, 0xfd,
      0xad, 0xf1, 0x7b, 0xdc, 0xe5, 0xf8, 0x60, 0x96, 0x09, 0x92, 0x10, 0xf5,
      0xd0, 0x53, 0xde, 0xfb, 0x7b, 0x7e, 0x73, 0x88, 0xac, 0x52, 0x88, 0x7b,
      0x4a, 0xa6, 0xca, 0x49, 0xa6, 0x5e, 0xa8, 0xa7, 0x8c, 0x5a, 0x11, 0xbc,
      0x7a, 0x82, 0xeb, 0xbe, 0x8c, 0xe9, 0xb3, 0xac, 0x96, 0x25, 0x07, 0x97,
      0x4a, 0x99, 0x2a, 0x07, 0x2f, 0xb4, 0x1e, 0x77, 0xbf, 0x8a, 0x0f, 0xb5,
      0x02, 0x7c, 0x1b, 0x96, 0xb8, 0xc5, 0xb9, 0x3a, 0x2c, 0xbc, 0xd6, 0x12,
      0xb9, 0xeb, 0x59, 0x7d, 0xe2, 0xd0, 0x06, 0x86, 0x5f, 0x5e, 0x49, 0x6a,
      0xb5, 0x39, 0x5e, 0x88, 0x34, 0xec, 0xbc, 0x78, 0x0c, 0x08, 0x98, 0x84,
      0x6c, 0xa8, 0xcd, 0x4b, 0xb4, 0xa0, 0x7d, 0x0c, 0x79, 0x4d, 0xf0, 0xb8,
      0x2d, 0xcb, 0x21, 0xca, 0xd5, 0x6c, 0x5b, 0x7d, 0xe1, 0xa0, 0x29, 0x84,
      0xa1, 0xf9, 0xd3, 0x94, 0x49, 0xcb, 0x24, 0x62, 0x91, 0x20, 0xbc, 0xdd,
      0x0b, 0xd5, 0xd9, 0xcc, 0xf9, 0xea, 0x27, 0x0a, 0x2b, 0x73, 0x91, 0xc6,
      0x9d, 0x1b, 0xac, 0xc8, 0xcb, 0xe8, 0xe0, 0xa0, 0xf4, 0x2f, 0x90, 0x8b,
      0x4d, 0xfb, 0xb0, 0x36, 0x1b, 0xf6, 0x19, 0x7a, 0x85, 0xe0, 0x6d, 0xf2,
      0x61, 0x13, 0x88, 0x5c, 0x9f, 0xe0, 0x93, 0x0a, 0x51, 0x97, 0x8a, 0x5a,
      0xce, 0xaf, 0xab, 0xd5, 0xf7, 0xaa, 0x09, 0xaa, 0x60, 0xbd, 0xdc, 0xd9,
      0x5f, 0xdf, 0x72, 0xa9, 0x60, 0x13, 0x5e, 0x00, 0x01, 0xc9, 0x4a, 0xfa,
      0x3f, 0xa4, 0xea, 0x07, 0x03, 0x21, 0x02, 0x8e, 0x82, 0xca, 0x03, 0xc2,
      0x9b, 0x8f, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x81, 0x9c, 0x30, 0x81,
      0x99, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04,
      0x04, 0x03, 0x02, 0x01, 0x06, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13,
      0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x1d,
      0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x9b, 0xe2, 0x07,
      0x57, 0x67, 0x1c, 0x1e, 0xc0, 0x6a, 0x06, 0xde, 0x59, 0xb4, 0x9a, 0x2d,
      0xdf, 0xdc, 0x19, 0x86, 0x2e, 0x30, 0x36, 0x06, 0x03, 0x55, 0x1d, 0x1f,
      0x04, 0x2f, 0x30, 0x2d, 0x30, 0x2b, 0xa0, 0x29, 0xa0, 0x27, 0x86, 0x25,
      0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x63, 0x72, 0x6c, 0x2e, 0x67,
      0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x73, 0x69, 0x67, 0x6e, 0x2e, 0x6e, 0x65,
      0x74, 0x2f, 0x72, 0x6f, 0x6f, 0x74, 0x2d, 0x72, 0x32, 0x2e, 0x63, 0x72,
      0x6c, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16,
      0x80, 0x14, 0x9b, 0xe2, 0x07, 0x57, 0x67, 0x1c, 0x1e, 0xc0, 0x6a, 0x06,
      0xde, 0x59, 0xb4, 0x9a, 0x2d, 0xdf, 0xdc, 0x19, 0x86, 0x2e, 0x30, 0x0d,
      0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05,
      0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x99, 0x81, 0x53, 0x87, 0x1c, 0x68,
      0x97, 0x86, 0x91, 0xec, 0xe0, 0x4a, 0xb8, 0x44, 0x0b, 0xab, 0x81, 0xac,
      0x27, 0x4f, 0xd6, 0xc1, 0xb8, 0x1c, 0x43, 0x78, 0xb3, 0x0c, 0x9a, 0xfc,
      0xea, 0x2c, 0x3c, 0x6e, 0x61, 0x1b, 0x4d, 0x4b, 0x29, 0xf5, 0x9f, 0x05,
      0x1d, 0x26, 0xc1, 0xb8, 0xe9, 0x83, 0x00, 0x62, 0x45, 0xb6, 0xa9, 0x08,
      0x93, 0xb9, 0xa9, 0x33, 0x4b, 0x18, 0x9a, 0xc2, 0xf8, 0x87, 0x88, 0x4e,
      0xdb, 0xdd, 0x71, 0x34, 0x1a, 0xc1, 0x54, 0xda, 0x46, 0x3f, 0xe0, 0xd3,
      0x2a, 0xab, 0x6d, 0x54, 0x22, 0xf5, 0x3a, 0x62, 0xcd, 0x20, 0x6f, 0xba,
      0x29, 0x89, 0xd7, 0xdd, 0x91, 0xee, 0xd3, 0x5c, 0xa2, 0x3e, 0xa1, 0x5b,
      0x41, 0xf5, 0xdf, 0xe5, 0x64, 0x43, 0x2d, 0xe9, 0xd5, 0x39, 0xab, 0xd2,
      0xa2, 0xdf, 0xb7, 0x8b, 0xd0, 0xc0, 0x80, 0x19, 0x1c, 0x45, 0xc0, 0x2d,
      0x8c, 0xe8, 0xf8, 0x2d, 0xa4, 0x74, 0x56, 0x49, 0xc5, 0x05, 0xb5, 0x4f,
      0x15, 0xde, 0x6e, 0x44, 0x78, 0x39, 0x87, 0xa8, 0x7e, 0xbb, 0xf3, 0x79,
      0x18, 0x91, 0xbb, 0xf4, 0x6f, 0x9d, 0xc1, 0xf0, 0x8c, 0x35, 0x8c, 0x5d,
      0x01, 0xfb, 0xc3, 0x6d, 0xb9, 0xef, 0x44, 0x6d, 0x79, 0x46, 0x31, 0x7e,
      0x0a, 0xfe, 0xa9, 0x82, 0xc1, 0xff, 0xef, 0xab, 0x6e, 0x20, 0xc4, 0x50,
      0xc9, 0x5f, 0x9d, 0x4d, 0x9b, 0x17, 0x8c, 0x0c, 0xe5, 0x01, 0xc9, 0xa0,
      0x41, 0x6a, 0x73, 0x53, 0xfa, 0xa5, 0x50, 0xb4, 0x6e, 0x25, 0x0f, 0xfb,
      0x4c, 0x18, 0xf4, 0xfd, 0x52, 0xd9, 0x8e, 0x69, 0xb1, 0xe8, 0x11, 0x0f,
      0xde, 0x88, 0xd8, 0xfb, 0x1d, 0x49, 0xf7, 0xaa, 0xde, 0x95, 0xcf, 0x20,
      0x78, 0xc2, 0x60, 0x12, 0xdb, 0x25, 0x40, 0x8c, 0x6a, 0xfc, 0x7e, 0x42,
      0x38, 0x40, 0x64, 0x12, 0xf7, 0x9e, 0x81, 0xe1, 0x93, 0x2e
    },
    958
  },
  {
    "Go_Daddy_Root_Certificate_Authority_G2",
    (const uint8_t[]){
      0x30, 0x82, 0x03, 0xc5, 0x30, 0x82, 0x02, 0xad, 0xa0, 0x03, 0x02, 0x01,
      0x02, 0x02, 0x01, 0x00, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
      0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x30, 0x81, 0x83, 0x31, 0x0b,
      0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31,
      0x10, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x04, 0x08, 0x13, 0x07, 0x41, 0x72,
      0x69, 0x7a, 0x6f, 0x6e, 0x61, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55,
      0x04, 0x07, 0x13, 0x0a, 0x53, 0x63, 0x6f, 0x74, 0x74, 0x73, 0x64, 0x61,
      0x6c, 0x65, 0x31, 0x1a, 0x30, 0x18, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13,
      0x11, 0x47, 0x6f, 0x44, 0x61, 0x64, 0x64, 0x79, 0x2e, 0x63, 0x6f, 0x6d,
      0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x31, 0x30, 0x2f, 0x06, 0x03,
      0x55, 0x04, 0x03, 0x13, 0x28, 0x47, 0x6f, 0x20, 0x44, 0x61, 0x64, 0x64,
      0x79, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69,
      0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f,
      0x72, 0x69, 0x74, 0x79, 0x20, 0x2d, 0x20, 0x47, 0x32, 0x30, 0x1e, 0x17,
      0x0d, 0x30, 0x39, 0x30, 0x39, 0x30, 0x31, 0x30, 0x30, 0x30, 0x30, 0x30,
      0x30, 0x5a, 0x17, 0x0d, 0x33, 0x37, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33,
      0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x81, 0x83, 0x31, 0x0b, 0x30, 0x09,
      0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x10, 0x30,
      0x0e, 0x06, 0x03, 0x55, 0x04, 0x08, 0x13, 0x07, 0x41, 0x72, 0x69, 0x7a,
      0x6f, 0x6e, 0x61, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x07,
      0x13, 0x0a, 0x53, 0x63, 0x6f, 0x74, 0x74, 0x73, 0x64, 0x61, 0x6c, 0x65,
      0x31, 0x1a, 0x30, 0x18, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x11, 0x47,
      0x6f, 0x44, 0x61, 0x64, 0x64, 0x79, 0x2e, 0x63, 0x6f, 0x6d, 0x2c, 0x20,
      0x49, 0x6e, 0x63, 0x2e, 0x31, 0x31, 0x30, 0x2f, 0x06, 0x03, 0x55, 0x04,
      0x03, 0x13, 0x28, 0x47, 0x6f, 0x20, 0x44, 0x61, 0x64, 0x64, 0x79, 0x20,
      0x52, 0x6f, 0x6f, 0x74, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
      0x63, 0x61, 0x74, 0x65, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
      0x74, 0x79, 0x20, 0x2d, 0x20, 0x47, 0x32, 0x30, 0x82, 0x01, 0x22, 0x30,
      0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01,
      0x05, 0x00, 0x03, 0x82, 0x01, 0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02,
      0x82, 0x01, 0x01, 0x00, 0xbf, 0x71, 0x62, 0x08, 0xf1, 0xfa, 0x59, 0x34,
      0xf7, 0x1b, 0xc9, 0x18, 0xa3, 0xf7, 0x80, 0x49, 0x58, 0xe9, 0x22, 0x83,
      0x13, 0xa6, 0xc5, 0x20, 0x43, 0x01, 0x3b, 0x84, 0xf1, 0xe6, 0x85, 0x49,
      0x9f, 0x27, 0xea, 0xf6, 0x84, 0x1b, 0x4e, 0xa0, 0xb4, 0xdb, 0x70, 0x98,
      0xc7, 0x32, 0x01, 0xb1, 0x05, 0x3e, 0x07, 0x4e, 0xee, 0xf4, 0xfa, 0x4f,
      0x2f, 0x59, 0x30, 0x22, 0xe7, 0xab, 0x19, 0x56, 0x6b, 0xe2, 0x80, 0x07,
      0xfc, 0xf3, 0x16, 0x75, 0x80, 0x39, 0x51, 0x7b, 0xe5, 0xf9, 0x35, 0xb6,
      0x74, 0x4e, 0xa9, 0x8d, 0x82, 0x13, 0xe4, 0xb6, 0x3f, 0xa9, 0x03, 0x83,
      0xfa, 0xa2, 0xbe, 0x8a, 0x15, 0x6a, 0x7f, 0xde, 0x0b, 0xc3, 0xb6, 0x19,
      0x14, 0x05, 0xca, 0xea, 0xc3, 0xa8, 0x04, 0x94, 0x3b, 0x46, 0x7c, 0x32,
      0x0d, 0xf3, 0x00, 0x66, 0x22, 0xc8, 0x8d, 0x69, 0x6d, 0x36, 0x8c, 0x11,
      0x18, 0xb7, 0xd3, 0xb2, 0x1c, 0x60, 0xb4, 0x38, 0xfa, 0x02, 0x8c, 0xce,
      0xd3, 0xdd, 0x46, 0x07, 0xde, 0x0a, 0x3e, 0xeb, 0x5d, 0x7c, 0xc8, 0x7c,
      0xfb, 0xb0, 0x2b, 0x53, 0xa4, 0x92, 0x62, 0x69, 0x51, 0x25, 0x05, 0x61,
      0x1a, 0x44, 0x81, 0x8c, 0x2c, 0xa9, 0x43, 0x96, 0x23, 0xdf, 0xac, 0x3a,
      0x81, 0x9a, 0x0e, 0x29, 0xc5, 0x1c, 0xa9, 0xe9, 0x5d, 0x1e, 0xb6, 0x9e,
      0x9e, 0x30, 0x0a, 0x39, 0xce, 0xf1, 0x88, 0x80, 0xfb, 0x4b, 0x5d, 0xcc,
      0x32, 0xec, 0x85, 0x62, 0x43, 0x25, 0x34, 0x02, 0x56, 0x27, 0x01, 0x91,
      0xb4, 0x3b, 0x70, 0x2a, 0x3f, 0x6e, 0xb1, 0xe8, 0x9c, 0x88, 0x01, 0x7d,
      0x9f, 0xd4, 0xf9, 0xdb, 0x53, 0x6d, 0x60, 0x9d, 0xbf, 0x2c, 0xe7, 0x58,
      0xab, 0xb8, 0x5f, 0x46, 0xfc, 0xce, 0xc4, 0x1b, 0x03, 0x3c, 0x09, 0xeb,
      0x49, 0x31, 0x5c, 0x69, 0x46, 0xb3, 0xe0, 0x47, 0x02, 0x03, 0x01, 0x00,
      0x01, 0xa3, 0x42, 0x30, 0x40, 0x30, 0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13,
      0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xff, 0x30, 0x0e,
      0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02,
      0x01, 0x06, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04,
      0x14, 0x3a, 0x9a, 0x85, 0x07, 0x10, 0x67, 0x28, 0xb6, 0xef, 0xf6, 0xbd,
      0x05, 0x41, 0x6e, 0x20, 0xc1, 0x94, 0xda, 0x0f, 0xde, 0x30, 0x0d, 0x06,
      0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00,
      0x03, 0x82, 0x01, 0x01, 0x00, 0x99, 0xdb, 0x5d, 0x79, 0xd5, 0xf9, 0x97,
      0x59, 0x67, 0x03, 0x61, 0xf1, 0x7e, 0x3b, 0x06, 0x31, 0x75, 0x2d, 0xa1,
      0x20, 0x8e, 0x4f, 0x65, 0x87, 0xb4, 0xf7, 0xa6, 0x9c, 0xbc, 0xd8, 0xe9,
      0x2f, 0xd0, 0xdb, 0x5a, 0xee, 0xcf, 0x74, 0x8c, 0x73, 0xb4, 0x38, 0x42,
      0xda, 0x05, 0x7b, 0xf8, 0x02, 0x75, 0xb8, 0xfd, 0xa5, 0xb1, 0xd7, 0xae,
      0xf6, 0xd7, 0xde, 0x13, 0xcb, 0x53, 0x10, 0x7e, 0x8a, 0x46, 0xd1, 0x97,
      0xfa, 0xb7, 0x2e, 0x2b, 0x11, 0xab, 0x90, 0xb0, 0x27, 0x80, 0xf9, 0xe8,
      0x9f, 0x5a, 0xe9, 0x37, 0x9f, 0xab, 0xe4, 0xdf, 0x6c, 0xb3, 0x85, 0x17,
      0x9d, 0x3d, 0xd9, 0x24, 0x4f, 0x79, 0x91, 0x35, 0xd6, 0x5f, 0x04, 0xeb,
      0x80, 0x83, 0xab, 0x9a, 0x02, 0x2d, 0xb5, 0x10, 0xf4, 0xd8, 0x90, 0xc7,
      0x04, 0x73, 0x40, 0xed, 0x72, 0x25, 0xa0, 0xa9, 0x9f, 0xec, 0x9e, 0xab,
      0x68, 0x12, 0x99, 0x57, 0xc6, 0x8f, 0x12, 0x3a, 0x09, 0xa4, 0xbd, 0x44,
      0xfd, 0x06, 0x15, 0x37, 0xc1, 0x9b, 0xe4, 0x32, 0xa3, 0xed, 0x38, 0xe8,
      0xd8, 0x64, 0xf3, 0x2c, 0x7e, 0x14, 0xfc, 0x02, 0xea, 0x9f, 0xcd, 0xff,
      0x07, 0x68, 0x17, 0xdb, 0x22, 0x90, 0x38, 0x2d, 0x7a, 0x8d, 0xd1, 0x54,
      0xf1, 0x69, 0xe3, 0x5f, 0x33, 0xca, 0x7a, 0x3d, 0x7b, 0x0a, 0xe3, 0xca,
      0x7f, 0x5f, 0x39, 0xe5, 0xe2, 0x75, 0xba, 0xc5, 0x76, 0x18, 0x33, 0xce,
      0x2c, 0xf0, 0x2f, 0x4c, 0xad, 0xf7, 0xb1, 0xe7, 0xce, 0x4f, 0xa8, 0xc4,
      0x9b, 0x4a, 0x54, 0x06, 0xc5, 0x7f, 0x7d, 0xd5, 0x08, 0x0f, 0xe2, 0x1c,
      0xfe, 0x7e, 0x17, 0xb8, 0xac, 0x5e, 0xf6, 0xd4, 0x16, 0xb2, 0x43, 0x09,
      0x0c, 0x4d, 0xf6, 0xa7, 0x6b, 0xb4, 0x99, 0x84, 0x65, 0xca, 0x7a, 0x88,
      0xe2, 0xe2, 0x44, 0xbe, 0x5c, 0xf7, 0xea, 0x1c, 0xf5
    },
    969
  },
  {
    "VeriSign_Class_3_Public_Primary_Certification_Authority_G5",
    (const uint8_t[]){
      0x30, 0x82, 0x04, 0xd3, 0x30, 0x82, 0x03, 0xbb, 0xa0, 0x03, 0x02, 0x01,
      0x02, 0x02, 0x10, 0x18, 0xda, 0xd1, 0x9e, 0x26, 0x7d, 0xe8, 0xbb, 0x4a,
      0x21, 0x58, 0xcd, 0xcc, 0x6b, 0x3b, 0x4a, 0x30, 0x0d, 0x06, 0x09, 0x2a,
      0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x81,
      0xca, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02,
      0x55, 0x53, 0x31, 0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13,
      0x0e, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6e, 0x2c, 0x20, 0x49,
      0x6e, 0x63, 0x2e, 0x31, 0x1f, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x04, 0x0b,
      0x13, 0x16, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6e, 0x20, 0x54,
      0x72, 0x75, 0x73, 0x74, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
      0x31, 0x3a, 0x30, 0x38, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x31, 0x28,
      0x63, 0x29, 0x20, 0x32, 0x30, 0x30, 0x36, 0x20, 0x56, 0x65, 0x72, 0x69,
      0x53, 0x69, 0x67, 0x6e, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x20, 0x2d,
      0x20, 0x46, 0x6f, 0x72, 0x20, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
      0x7a, 0x65, 0x64, 0x20, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x6e, 0x6c, 0x79,
      0x31, 0x45, 0x30, 0x43, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x3c, 0x56,
      0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6e, 0x20, 0x43, 0x6c, 0x61, 0x73,
      0x73, 0x20, 0x33, 0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x50,
      0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69,
      0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74,
      0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x20, 0x2d, 0x20, 0x47, 0x35, 0x30,
      0x1e, 0x17, 0x0d, 0x30, 0x36, 0x31, 0x31, 0x30, 0x38, 0x30, 0x30, 0x30,
      0x30, 0x30, 0x30, 0x5a, 0x17, 0x0d, 0x33, 0x36, 0x30, 0x37, 0x31, 0x36,
      0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x81, 0xca, 0x31, 0x0b,
      0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31,
      0x17, 0x30, 0x15, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0e, 0x56, 0x65,
      0x72, 0x69, 0x53, 0x69, 0x67, 0x6e, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e,
      0x31, 0x1f, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x16, 0x56,
      0x65, 0x72, 0x69, 0x53, 0x69, 0x67, 0x6e, 0x20, 0x54, 0x72, 0x75, 0x73,
      0x74, 0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x31, 0x3a, 0x30,
      0x38, 0x06, 0x03, 0x55, 0x04, 0x0b, 0x13, 0x31, 0x28, 0x63, 0x29, 0x20,
      0x32, 0x30, 0x30, 0x36, 0x20, 0x56, 0x65, 0x72, 0x69, 0x53, 0x69, 0x67,
      0x6e, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x20, 0x2d, 0x20, 0x46, 0x6f,
      0x72, 0x20, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64,
      0x20, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x31, 0x45, 0x30,
      0x43, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x3c, 0x56, 0x65, 0x72, 0x69,
      0x53, 0x69, 0x67, 0x6e, 0x20, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x20, 0x33,
      0x20, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x50, 0x72, 0x69, 0x6d,
      0x61, 0x72, 0x79, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
      0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
      0x69, 0x74, 0x79, 0x20, 0x2d, 0x20, 0x47, 0x35, 0x30, 0x82, 0x01, 0x22,
      0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01,
      0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a,
      0x02, 0x82, 0x01, 0x01, 0x00, 0xaf, 0x24, 0x08, 0x08, 0x29, 0x7a, 0x35,
      0x9e, 0x60, 0x0c, 0xaa, 0xe7, 0x4b, 0x3b, 0x4e, 0xdc, 0x7c, 0xbc, 0x3c,
      0x45, 0x1c, 0xbb, 0x2b, 0xe0, 0xfe, 0x29, 0x02, 0xf9, 0x57, 0x08, 0xa3,
      0x64, 0x85, 0x15, 0x27, 0xf5, 0xf1, 0xad, 0xc8, 0x31, 0x89, 0x5d, 0x22,
      0xe8, 0x2a, 0xaa, 0xa6, 0x42, 0xb3, 0x8f, 0xf8, 0xb9, 0x55, 0xb7, 0xb1,
      0xb7, 0x4b, 0xb3, 0xfe, 0x8f, 0x7e, 0x07, 0x57, 0xec, 0xef, 0x43, 0xdb,
      0x66, 0x62, 0x15, 0x61, 0xcf, 0x60, 0x0d, 0xa4, 0xd8, 0xde, 0xf8, 0xe0,
      0xc3, 0x62, 0x08, 0x3d, 0x54, 0x13, 0xeb, 0x49, 0xca, 0x59, 0x54, 0x85,
      0x26, 0xe5, 0x2b, 0x8f, 0x1b, 0x9f, 0xeb, 0xf5, 0xa1, 0x91, 0xc2, 0x33,
      0x49, 0xd8, 0x43, 0x63, 0x6a, 0x52, 0x4b, 0xd2, 0x8f, 0xe8, 0x70, 0x51,
      0x4d, 0xd1, 0x89, 0x69, 0x7b, 0xc7, 0x70, 0xf6, 0xb3, 0xdc, 0x12, 0x74,
      0xdb, 0x7b, 0x5d, 0x4b, 0x56, 0xd3, 0x96, 0xbf, 0x15, 0x77, 0xa1, 0xb0,
      0xf4, 0xa2, 0x25, 0xf2, 0xaf, 0x1c, 0x92, 0x67, 0x18, 0xe5, 0xf4, 0x06,
      0x04, 0xef, 0x90, 0xb9, 0xe4, 0x00, 0xe4, 0xdd, 0x3a, 0xb5, 0x19, 0xff,
      0x02, 0xba, 0xf4, 0x3c, 0xee, 0xe0, 0x8b, 0xeb, 0x37, 0x8b, 0xec, 0xf4,
      0xd7, 0xac, 0xf2, 0xf6, 0xf0, 0x3d, 0xaf, 0xdd, 0x75, 0x91, 0x33, 0x19,
      0x1d, 0x1c, 0x40, 0xcb, 0x74, 0x24, 0x19, 0x21, 0x93, 0xd9, 0x14, 0xfe,
      0xac, 0x2a, 0x52, 0xc7, 0x8f, 0xd5, 0x04, 0x49, 0xe4, 0x8d, 0x63, 0x47,
      0x88, 0x3c, 0x69, 0x83, 0xcb, 0xfe, 0x47, 0xbd, 0x2b, 0x7e, 0x4f, 0xc5,
      0x95, 0xae, 0x0e, 0x9d, 0xd4, 0xd1, 0x43, 0xc0, 0x67, 0x73, 0xe3, 0x14,
      0x08, 0x7e, 0xe5, 0x3f, 0x9f, 0x73, 0xb8, 0x33, 0x0a, 0xcf, 0x5d, 0x3f,
      0x34, 0x87, 0x96, 0x8a, 0xee, 0x53, 0xe8, 0x25, 0x15, 0x02, 0x03, 0x01,
      0x00, 0x01, 0xa3, 0x81, 0xb2, 0x30, 0x81, 0xaf, 0x30, 0x0f, 0x06, 0x03,
      0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01,
      0xff, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04,
      0x04, 0x03, 0x02, 0x01, 0x06, 0x30, 0x6d, 0x06, 0x08, 0x2b, 0x06, 0x01,
      0x05, 0x05, 0x07, 0x01, 0x0c, 0x04, 0x61, 0x30, 0x5f, 0xa1, 0x5d, 0xa0,
      0x5b, 0x30, 0x59, 0x30, 0x57, 0x30, 0x55, 0x16, 0x09, 0x69, 0x6d, 0x61,
      0x67, 0x65, 0x2f, 0x67, 0x69, 0x66, 0x30, 0x21, 0x30, 0x1f, 0x30, 0x07,
      0x06, 0x05, 0x2b, 0x0e, 0x03, 0x02, 0x1a, 0x04, 0x14, 0x8f, 0xe5, 0xd3,
      0x1a, 0x86, 0xac, 0x8d, 0x8e, 0x6b, 0xc3, 0xcf, 0x80, 0x6a, 0xd4, 0x48,
      0x18, 0x2c, 0x7b, 0x19, 0x2e, 0x30, 0x25, 0x16, 0x23, 0x68, 0x74, 0x74,
      0x70, 0x3a, 0x2f, 0x2f, 0x6c, 0x6f, 0x67, 0x6f, 0x2e, 0x76, 0x65, 0x72,
      0x69, 0x73, 0x69, 0x67, 0x6e, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x76, 0x73,
      0x6c, 0x6f, 0x67, 0x6f, 0x2e, 0x67, 0x69, 0x66, 0x30, 0x1d, 0x06, 0x03,
      0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x7f, 0xd3, 0x65, 0xa7, 0xc2,
      0xdd, 0xec, 0xbb, 0xf0, 0x30, 0x09, 0xf3, 0x43, 0x39, 0xfa, 0x02, 0xaf,
      0x33, 0x31, 0x33, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7,
      0x0d, 0x01, 0x01, 0x05, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x93,
      0x24, 0x4a, 0x30, 0x5f, 0x62, 0xcf, 0xd8, 0x1a, 0x98, 0x2f, 0x3d, 0xea,
      0xdc, 0x99, 0x2d, 0xbd, 0x77, 0xf6, 0xa5, 0x79, 0x22, 0x38, 0xec, 0xc4,
      0xa7, 0xa0, 0x78, 0x12, 0xad, 0x62, 0x0e, 0x45, 0x70, 0x64, 0xc5, 0xe7,
      0x97, 0x66, 0x2d, 0x98, 0x09, 0x7e, 0x5f, 0xaf, 0xd6, 0xcc, 0x28, 0x65,
      0xf2, 0x01, 0xaa, 0x08, 0x1a, 0x47, 0xde, 0xf9, 0xf9, 0x7c, 0x92, 0x5a,
      0x08, 0x69, 0x20, 0x0d, 0xd9, 0x3e, 0x6d, 0x6e, 0x3c, 0x0d, 0x6e, 0xd8,
      0xe6, 0x06, 0x91, 0x40, 0x18, 0xb9, 0xf8, 0xc1, 0xed, 0xdf, 0xdb, 0x41,
      0xaa, 0xe0, 0x96, 0x20, 0xc9, 0xcd, 0x64, 0x15, 0x38, 0x81, 0xc9, 0x94,
      0xee, 0xa2, 0x84, 0x29, 0x0b, 0x13, 0x6f, 0x8e, 0xdb, 0x0c, 0xdd, 0x25,
      0x02, 0xdb, 0xa4, 0x8b, 0x19, 0x44, 0xd2, 0x41, 0x7a, 0x05, 0x69, 0x4a,
      0x58, 0x4f, 0x60, 0xca, 0x7e, 0x82, 0x6a, 0x0b, 0x02, 0xaa, 0x25, 0x17,
      0x39, 0xb5, 0xdb, 0x7f, 0xe7, 0x84, 0x65, 0x2a, 0x95, 0x8a, 0xbd, 0x86,
      0xde, 0x5e, 0x81, 0x16, 0x83, 0x2d, 0x10, 0xcc, 0xde, 0xfd, 0xa8, 0x82,
      0x2a, 0x6d, 0x28, 0x1f, 0x0d, 0x0b, 0xc4, 0xe5, 0xe7, 0x1a, 0x26, 0x19,
      0xe1, 0xf4, 0x11, 0x6f, 0x10, 0xb5, 0x95, 0xfc, 0xe7, 0x42, 0x05, 0x32,
      0xdb, 0xce, 0x9d, 0x51, 0x5e, 0x28, 0xb6, 0x9e, 0x85, 0xd3, 0x5b, 0xef,
      0xa5, 0x7d, 0x45, 0x40, 0x72, 0x8e, 0xb7, 0x0e, 0x6b, 0x0e, 0x06, 0xfb,
      0x33, 0x35, 0x48, 0x71, 0xb8, 0x9d, 0x27, 0x8b, 0xc4, 0x65, 0x5f, 0x0d,
      0x86, 0x76, 0x9c, 0x44, 0x7a, 0xf6, 0x95, 0x5c, 0xf6, 0x5d, 0x32, 0x08,
      0x33, 0xa4, 0x54, 0xb6, 0x18, 0x3f, 0x68, 0x5c, 0xf2, 0x42, 0x4a, 0x85,
      0x38, 0x54, 0x83, 0x5f, 0xd1, 0xe8, 0x2c, 0xf2, 0xac, 0x11, 0xd6, 0xa8,
      0xed, 0x63, 0x6a
    },
    1239
  },
  {
    "AmazonRootCA1",
    NULL, // remove
    0
  },
  {
    "Starfield_Services_Root_Certificate_Authority_G2",
    (const uint8_t[]){
      0x30, 0x82, 0x03, 0xef, 0x30, 0x82, 0x02, 0xd7, 0xa0, 0x03, 0x02, 0x01,
      0x02, 0x02, 0x01, 0x00, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
      0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x30, 0x81, 0x98, 0x31, 0x0b,
      0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31,
      0x10, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x04, 0x08, 0x13, 0x07, 0x41, 0x72,
      0x69, 0x7a, 0x6f, 0x6e, 0x61, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55,
      0x04, 0x07, 0x13, 0x0a, 0x53, 0x63, 0x6f, 0x74, 0x74, 0x73, 0x64, 0x61,
      0x6c, 0x65, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13,
      0x1c, 0x53, 0x74, 0x61, 0x72, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x20, 0x54,
      0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x69, 0x65, 0x73, 0x2c,
      0x20, 0x49, 0x6e, 0x63, 0x2e, 0x31, 0x3b, 0x30, 0x39, 0x06, 0x03, 0x55,
      0x04, 0x03, 0x13, 0x32, 0x53, 0x74, 0x61, 0x72, 0x66, 0x69, 0x65, 0x6c,
      0x64, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x20, 0x52,
      0x6f, 0x6f, 0x74, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
      0x61, 0x74, 0x65, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
      0x79, 0x20, 0x2d, 0x20, 0x47, 0x32, 0x30, 0x1e, 0x17, 0x0d, 0x30, 0x39,
      0x30, 0x39, 0x30, 0x31, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x17,
      0x0d, 0x33, 0x37, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35,
      0x39, 0x5a, 0x30, 0x81, 0x98, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55,
      0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x10, 0x30, 0x0e, 0x06, 0x03,
      0x55, 0x04, 0x08, 0x13, 0x07, 0x41, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x61,
      0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x07, 0x13, 0x0a, 0x53,
      0x63, 0x6f, 0x74, 0x74, 0x73, 0x64, 0x61, 0x6c, 0x65, 0x31, 0x25, 0x30,
      0x23, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x1c, 0x53, 0x74, 0x61, 0x72,
      0x66, 0x69, 0x65, 0x6c, 0x64, 0x20, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x6f,
      0x6c, 0x6f, 0x67, 0x69, 0x65, 0x73, 0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e,
      0x31, 0x3b, 0x30, 0x39, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x32, 0x53,
      0x74, 0x61, 0x72, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x20, 0x53, 0x65, 0x72,
      0x76, 0x69, 0x63, 0x65, 0x73, 0x20, 0x52, 0x6f, 0x6f, 0x74, 0x20, 0x43,
      0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x20, 0x41,
      0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x20, 0x2d, 0x20, 0x47,
      0x32, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48,
      0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82, 0x01, 0x0f,
      0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00, 0xd5, 0x0c,
      0x3a, 0xc4, 0x2a, 0xf9, 0x4e, 0xe2, 0xf5, 0xbe, 0x19, 0x97, 0x5f, 0x8e,
      0x88, 0x53, 0xb1, 0x1f, 0x3f, 0xcb, 0xcf, 0x9f, 0x20, 0x13, 0x6d, 0x29,
      0x3a, 0xc8, 0x0f, 0x7d, 0x3c, 0xf7, 0x6b, 0x76, 0x38, 0x63, 0xd9, 0x36,
      0x60, 0xa8, 0x9b, 0x5e, 0x5c, 0x00, 0x80, 0xb2, 0x2f, 0x59, 0x7f, 0xf6,
      0x87, 0xf9, 0x25, 0x43, 0x86, 0xe7, 0x69, 0x1b, 0x52, 0x9a, 0x90, 0xe1,
      0x71, 0xe3, 0xd8, 0x2d, 0x0d, 0x4e, 0x6f, 0xf6, 0xc8, 0x49, 0xd9, 0xb6,
      0xf3, 0x1a, 0x56, 0xae, 0x2b, 0xb6, 0x74, 0x14, 0xeb, 0xcf, 0xfb, 0x26,
      0xe3, 0x1a, 0xba, 0x1d, 0x96, 0x2e, 0x6a, 0x3b, 0x58, 0x94, 0x89, 0x47,
      0x56, 0xff, 0x25, 0xa0, 0x93, 0x70, 0x53, 0x83, 0xda, 0x84, 0x74, 0x14,
      0xc3, 0x67, 0x9e, 0x04, 0x68, 0x3a, 0xdf, 0x8e, 0x40, 0x5a, 0x1d, 0x4a,
      0x4e, 0xcf, 0x43, 0x91, 0x3b, 0xe7, 0x56, 0xd6, 0x00, 0x70, 0xcb, 0x52,
      0xee, 0x7b, 0x7d, 0xae, 0x3a, 0xe7, 0xbc, 0x31, 0xf9, 0x45, 0xf6, 0xc2,
      0x60, 0xcf, 0x13, 0x59, 0x02, 0x2b, 0x80, 0xcc, 0x34, 0x47, 0xdf, 0xb9,
      0xde, 0x90, 0x65, 0x6d, 0x02, 0xcf, 0x2c, 0x91, 0xa6, 0xa6, 0xe7, 0xde,
      0x85, 0x18, 0x49, 0x7c, 0x66, 0x4e, 0xa3, 0x3a, 0x6d, 0xa9, 0xb5, 0xee,
      0x34, 0x2e, 0xba, 0x0d, 0x03, 0xb8, 0x33, 0xdf, 0x47, 0xeb, 0xb1, 0x6b,
      0x8d, 0x25, 0xd9, 0x9b, 0xce, 0x81, 0xd1, 0x45, 0x46, 0x32, 0x96, 0x70,
      0x87, 0xde, 0x02, 0x0e, 0x49, 0x43, 0x85, 0xb6, 0x6c, 0x73, 0xbb, 0x64,
      0xea, 0x61, 0x41, 0xac, 0xc9, 0xd4, 0x54, 0xdf, 0x87, 0x2f, 0xc7, 0x22,
      0xb2, 0x26, 0xcc, 0x9f, 0x59, 0x54, 0x68, 0x9f, 0xfc, 0xbe, 0x2a, 0x2f,
      0xc4, 0x55, 0x1c, 0x75, 0x40, 0x60, 0x17, 0x85, 0x02, 0x55, 0x39, 0x8b,
      0x7f, 0x05, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x42, 0x30, 0x40, 0x30,
      0x0f, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x05, 0x30,
      0x03, 0x01, 0x01, 0xff, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01,
      0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x01, 0x06, 0x30, 0x1d, 0x06, 0x03,
      0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x9c, 0x5f, 0x00, 0xdf, 0xaa,
      0x01, 0xd7, 0x30, 0x2b, 0x38, 0x88, 0xa2, 0xb8, 0x6d, 0x4a, 0x9c, 0xf2,
      0x11, 0x91, 0x83, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7,
      0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x4b,
      0x36, 0xa6, 0x84, 0x77, 0x69, 0xdd, 0x3b, 0x19, 0x9f, 0x67, 0x23, 0x08,
      0x6f, 0x0e, 0x61, 0xc9, 0xfd, 0x84, 0xdc, 0x5f, 0xd8, 0x36, 0x81, 0xcd,
      0xd8, 0x1b, 0x41, 0x2d, 0x9f, 0x60, 0xdd, 0xc7, 0x1a, 0x68, 0xd9, 0xd1,
      0x6e, 0x86, 0xe1, 0x88, 0x23, 0xcf, 0x13, 0xde, 0x43, 0xcf, 0xe2, 0x34,
      0xb3, 0x04, 0x9d, 0x1f, 0x29, 0xd5, 0xbf, 0xf8, 0x5e, 0xc8, 0xd5, 0xc1,
      0xbd, 0xee, 0x92, 0x6f, 0x32, 0x74, 0xf2, 0x91, 0x82, 0x2f, 0xbd, 0x82,
      0x42, 0x7a, 0xad, 0x2a, 0xb7, 0x20, 0x7d, 0x4d, 0xbc, 0x7a, 0x55, 0x12,
      0xc2, 0x15, 0xea, 0xbd, 0xf7, 0x6a, 0x95, 0x2e, 0x6c, 0x74, 0x9f, 0xcf,
      0x1c, 0xb4, 0xf2, 0xc5, 0x01, 0xa3, 0x85, 0xd0, 0x72, 0x3e, 0xad, 0x73,
      0xab, 0x0b, 0x9b, 0x75, 0x0c, 0x6d, 0x45, 0xb7, 0x8e, 0x94, 0xac, 0x96,
      0x37, 0xb5, 0xa0, 0xd0, 0x8f, 0x15, 0x47, 0x0e, 0xe3, 0xe8, 0x83, 0xdd,
      0x8f, 0xfd, 0xef, 0x41, 0x01, 0x77, 0xcc, 0x27, 0xa9, 0x62, 0x85, 0x33,
      0xf2, 0x37, 0x08, 0xef, 0x71, 0xcf, 0x77, 0x06, 0xde, 0xc8, 0x19, 0x1d,
      0x88, 0x40, 0xcf, 0x7d, 0x46, 0x1d, 0xff, 0x1e, 0xc7, 0xe1, 0xce, 0xff,
      0x23, 0xdb, 0xc6, 0xfa, 0x8d, 0x55, 0x4e, 0xa9, 0x02, 0xe7, 0x47, 0x11,
      0x46, 0x3e, 0xf4, 0xfd, 0xbd, 0x7b, 0x29, 0x26, 0xbb, 0xa9, 0x61, 0x62,
      0x37, 0x28, 0xb6, 0x2d, 0x2a, 0xf6, 0x10, 0x86, 0x64, 0xc9, 0x70, 0xa7,
      0xd2, 0xad, 0xb7, 0x29, 0x70, 0x79, 0xea, 0x3c, 0xda, 0x63, 0x25, 0x9f,
      0xfd, 0x68, 0xb7, 0x30, 0xec, 0x70, 0xfb, 0x75, 0x8a, 0xb7, 0x6d, 0x60,
      0x67, 0xb2, 0x1e, 0xc8, 0xb9, 0xe9, 0xd8, 0xa8, 0x6f, 0x02, 0x8b, 0x67,
      0x0d, 0x4d, 0x26, 0x57, 0x71, 0xda, 0x20, 0xfc, 0xc1, 0x4a, 0x50, 0x8d,
      0xb1, 0x28, 0xba
    },
    1011
  }
};

#define NB_NUM_ROOT_CERTS (sizeof(NB_ROOT_CERTS) / sizeof(NB_ROOT_CERTS[0]))

#endif
