# Contribution Guidelines

This library is the culmination of the expertise of many members of the open source community who have dedicated their time and hard work.
The best way to ask for help or propose a new idea is to create a new discussion and / or a new Pull Request
with your code changes to allow you to share your own innovations with the rest of the community.

The following are some guidelines to observe when creating discussions / PRs:
- Be friendly; it is important that we can all enjoy a safe space as we are all working on the same project and **it is okay for people to have different ideas**.
- Use reasonable titles; refrain from using overly long or capitalized titles as they are usually annoying and do little to encourage others to help :smile:.
- Use the style; we use the original [C Style by Kerninghan / Ritchie](https://en.wikipedia.org/wiki/Indentation_style#K&R_style) in [variant: 1TBS (OTBS)](https://en.wikipedia.org/wiki/Indentation_style#Variant:_1TBS_(OTBS)).
 In short: 4 spaces indentation, no tabs, opening braces on the same line, braces are mandatory on all if/while/do, no hard line length limit.
 To beautify your code, you may use the online formatter [here](https://www.freecodeformat.com/c-format.php).
- Cover **all** occurences of the problem / addition you address with your PR. Do not forget the documentation like it is done for existing code. Code changes without proper documentation will be rejected!
