/******************************************************************************************************************************************
  FlashStorage_CRC.ino
  For Realtek RTL8720DN, etc. using Flash

  The FlashStorage_RTL8720DN library aims to provide a convenient way to store and retrieve user's data using the non-volatile flash memory
  of RTL8720DN, etc.. It's using the buffered read and write to minimize the access to Flash.
  It now supports writing and reading the whole object, not just byte-and-byte.

  Inspired by Cristian Maglie's FlashStorage (https://github.com/cmaglie/FlashStorage)

  Built by Khoi Hoang https://github.com/khoih-prog/FlashStorage_RTL8720DN
  Licensed under MIT license
  Version: 1.0.0

  Version Modified By   Date        Comments
  ------- -----------  ----------   -----------
  1.0.0   K Hoang      06/08/2021  Initial coding to support RTL8720DN using emulated-FlashStorage
 ******************************************************************************************************************************************/

/***
  Written by Christopher Andrews.
  CRC algorithm generated by pycrc, MIT licence ( https://github.com/tpircher/pycrc )

  A CRC is a simple way of checking whether data has changed or become corrupted.
  This example calculates a CRC value directly on the FlashStorage values.
  The purpose of this example is to highlight how the FlashStorage object can be used just like an array.
***/

#define FLASH_DEBUG               1

#include <FlashStorage_RTL8720.h>

unsigned long FlashStorage_crc() 
{
  const unsigned long crc_table[16] =
  {
    0x00000000, 0x1db71064, 0x3b6e20c8, 0x26d930ac,
    0x76dc4190, 0x6b6b51f4, 0x4db26158, 0x5005713c,
    0xedb88320, 0xf00f9344, 0xd6d6a3e8, 0xcb61b38c,
    0x9b64c2b0, 0x86d3d2d4, 0xa00ae278, 0xbdbdf21c
  };

  unsigned long crc = ~0L;

  for (int index = 0 ; index < FlashStorage.length(); ++index)
  {
    crc = crc_table[(crc ^ FlashStorage.readByte(index)) & 0x0f] ^ (crc >> 4);
    crc = crc_table[(crc ^ (FlashStorage.readByte(index) >> 4)) & 0x0f] ^ (crc >> 4);
    crc = ~crc;
  }

  return crc;
}

void setup()
{
  Serial.begin(115200);
  while (!Serial);

  delay(200);

  Serial.print(F("\nStart FlashStorage_CRC on ")); Serial.println(BOARD_NAME);
  Serial.println(FLASH_STORAGE_RTL8720_VERSION);

  //Print length of data to run CRC on.
  Serial.print("FlashStorage length: ");
  Serial.println(FlashStorage.length());

  //Print the result of calling FlashStorage_crc()
  Serial.print("CRC32 of FlashStorage data: 0x");
  Serial.println(FlashStorage_crc(), HEX);
  Serial.print("Done!");
}

void loop() 
{
  /* Empty loop */
}
