## Contributing to FlashStorage_RTL8720

### Reporting Bugs

Please report bugs in FlashStorage_RTL8720 if you find them.

However, before reporting a bug please check through the following:

* [Existing Open Issues](https://github.com/khoih-prog/FlashStorage_RTL8720/issues) - someone might have already encountered this.

If you don't find anything, please [open a new issue](https://github.com/khoih-prog/FlashStorage_RTL8720/issues/new).

### How to submit a bug report

Please ensure to specify the following:

* Arduino IDE version (e.g. 1.8.13) or Platform.io version
* Board Core Version (e.g. Arduino STM32 core v2.0.0, etc.)
* Contextual information (e.g. what you were trying to achieve)
* Simplest possible steps to reproduce
* Anything that might be relevant in your opinion, such as:
  * Operating system (Windows, Ubuntu, etc.) and the output of `uname -a`
  * Network configuration


### Example

```
Arduino IDE version: 1.8.13
Arduino STM32 core v2.0.0
OS: Ubuntu 20.04 LTS
Linux Inspiron-3593 5.4.0-72-generic #80-Ubuntu SMP Mon Apr 12 17:35:00 UTC 2021 x86_64 x86_64 x86_64 GNU/Linux

Context:
The board couldn't autoreconnect to Local Blynk Server after router power recycling.

Steps to reproduce:
1. ...
2. ...
3. ...
4. ...

### Sending Feature Requests

Feel free to post feature requests. It's helpful if you can explain exactly why the feature would be useful.

There are usually some outstanding feature requests in the [existing issues list](https://github.com/khoih-prog/FlashStorage_RTL8720/issues?q=is%3Aopen+is%3Aissue+label%3Aenhancement), feel free to add comments to them.

### Sending Pull Requests

Pull Requests with changes and fixes are also welcome!
