/*
  WiFiClient.cpp - Library for Arduino Wifi shield.
  Copyright (c) 2018 Arduino SA. All rights reserved.
  Copyright (c) 2011-2014 Arduino LLC.  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#if defined(ARDUINO_ARCH_SAMD) || defined(__AVR_ATmega4809__)

#ifndef wificlient_h
#define wificlient_h
#include "Arduino.h"	
#include "Print.h"
#include "Client.h"
#include "IPAddress.h"

class WiFiClient : public Client {

public:
  WiFiClient();
  WiFiClient(uint8_t sock);

  uint8_t status();
  virtual int connect(IPAddress ip, uint16_t port);
  virtual int connect(const char *host, uint16_t port);
  virtual int connectSSL(IPAddress ip, uint16_t port);
  virtual int connectSSL(const char *host, uint16_t port);
  /* Secure Connection Upgradable Supports */
  virtual int ns_connect(const char *host, uint16_t port);
  /* Secure Connection Upgradable Supports */
  virtual int ns_connectSSL(const char *host, uint16_t port, bool verify);
  virtual int connectBearSSL(IPAddress ip, uint16_t port);
  virtual int connectBearSSL(const char *host, uint16_t port);
  virtual size_t write(uint8_t);
  virtual size_t write(const uint8_t *buf, size_t size);
  virtual size_t retry(const uint8_t *buf, size_t size, bool write);
  virtual int available();
  virtual int read();
  virtual int read(uint8_t *buf, size_t size);
  virtual int peek();
  virtual void setRetry(bool retry);
  virtual void flush();
  virtual void stop();
  virtual uint8_t connected();
  virtual operator bool();

  virtual IPAddress remoteIP();
  virtual uint16_t remotePort();

  friend class WiFiServer;
  friend class WiFiDrv;

  using Print::write;

private:
  static uint16_t _srcport;
  uint8_t _sock;   //not used
  uint16_t  _socket;
  bool _retrySend;
};

#endif

#endif