## Contributing to ESP8266_AT_WebServer

### Reporting Bugs

Please report bugs in ESP8266_AT_WebServer if you find them.

However, before reporting a bug please check through the following:

* [Existing Open Issues](https://github.com/khoih-prog/ESP8266_AT_WebServer/issues) - someone might have already encountered this.

If you don't find anything, please [open a new issue](https://github.com/khoih-prog/ESP8266_AT_WebServer/issues/new).

### How to submit a bug report

Please ensure to specify the following:

* Arduino IDE version (e.g. 1.8.15) or Platform.io version
* `ESP8266`,`ESP32` or `STM32` Core Version (e.g. ESP8266 core v3.0.2, ESP32 v1.0.6 or STM32 v2.0.0)
* Contextual information (e.g. what you were trying to achieve)
* Simplest possible steps to reproduce
* Anything that might be relevant in your opinion, such as:
  * Operating system (Windows, Ubuntu, etc.) and the output of `uname -a`
  * Network configuration


### Example

```
Arduino IDE version: 1.8.15
Arduino-mbed RP2040 v2.4.1
NANO_RP2040_CONNECT Module
OS: Ubuntu 20.04 LTS
Linux xy-Inspiron-3593 5.4.0-81-generic #91-Ubuntu SMP Thu Jul 15 19:09:17 UTC 2021 x86_64 x86_64 x86_64 GNU/Linux

Context:
I encountered an endless loop while trying to connect to Local WiFi.

Steps to reproduce:
1. ...
2. ...
3. ...
4. ...
```

### Sending Feature Requests

Feel free to post feature requests. It's helpful if you can explain exactly why the feature would be useful.

There are usually some outstanding feature requests in the [existing issues list](https://github.com/khoih-prog/ESP8266_AT_WebServer/issues?q=is%3Aopen+is%3Aissue+label%3Aenhancement), feel free to add comments to them.

### Sending Pull Requests

Pull Requests with changes and fixes are also welcome!
