/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.scale.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.base.values.HSV;
import jetbrains.datalore.plot.base.ContinuousTransform;
import jetbrains.datalore.plot.base.DiscreteTransform;
import jetbrains.datalore.plot.base.ScaleMapper;
import jetbrains.datalore.plot.base.scale.MapperUtil;
import jetbrains.datalore.plot.builder.scale.GuideMapper;
import jetbrains.datalore.plot.builder.scale.provider.HSVColorMapperProvider;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bBE\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000f0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/builder/scale/provider/ColorHueMapperProvider;", "Ljetbrains/datalore/plot/builder/scale/provider/HSVColorMapperProvider;", "hueRange", "", "", "chroma", "luminance", "startHue", "direction", "naValue", "Ljetbrains/datalore/base/values/Color;", "(Ljava/util/List;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljetbrains/datalore/base/values/Color;)V", "myFromHSV", "Ljetbrains/datalore/base/values/HSV;", "myHSVIntervals", "Lkotlin/Pair;", "myToHSV", "createContinuousMapper", "Ljetbrains/datalore/plot/builder/scale/GuideMapper;", "domain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "trans", "Ljetbrains/datalore/plot/base/ContinuousTransform;", "createDiscreteMapper", "Ljetbrains/datalore/plot/base/ScaleMapper;", "discreteTransform", "Ljetbrains/datalore/plot/base/DiscreteTransform;", "Companion", "plot-builder-portable"})
public final class ColorHueMapperProvider
extends HSVColorMapperProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HSV myFromHSV;
    @NotNull
    private final HSV myToHSV;
    @NotNull
    private final List<Pair<HSV, HSV>> myHSVIntervals;
    private static final double DEF_SATURATION = 50.0;
    private static final double DEF_VALUE = 90.0;
    private static final double DEF_START_HUE = 0.0;
    @NotNull
    private static final DoubleSpan DEF_HUE_RANGE = new DoubleSpan(15.0, 375.0);
    @NotNull
    private static final ColorHueMapperProvider DEFAULT = new ColorHueMapperProvider(null, null, null, null, null, Color.Companion.getGRAY());

    /*
     * WARNING - void declaration
     */
    public ColorHueMapperProvider(@Nullable List<Double> hueRange, @Nullable Double chroma, @Nullable Double luminance, @Nullable Double startHue, @Nullable Double direction, @NotNull Color naValue) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list;
        double startHue2;
        Intrinsics.checkNotNullParameter((Object)naValue, (String)"naValue");
        super(naValue);
        DoubleSpan hueRange2 = ColorHueMapperProvider.Companion.normalizeHueRange(hueRange);
        boolean clockwise = direction == null || !Intrinsics.areEqual((Double)direction, (double)-1.0);
        double fromHue = clockwise ? hueRange2.getLowerEnd().doubleValue() : hueRange2.getUpperEnd().doubleValue();
        double toHue = clockwise ? hueRange2.getUpperEnd().doubleValue() : hueRange2.getLowerEnd().doubleValue();
        Double d = startHue;
        double d2 = startHue2 = d != null ? d : 0.0;
        if (hueRange2.contains(startHue2) && startHue2 - hueRange2.getLowerEnd() > 1.0 && hueRange2.getUpperEnd() - startHue2 > 1.0) {
            Object[] objectArray = new Pair[]{TuplesKt.to((Object)startHue2, (Object)toHue), TuplesKt.to((Object)fromHue, (Object)startHue2)};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.listOf((Object)TuplesKt.to((Object)fromHue, (Object)toHue));
        }
        List hueIntervals = list;
        Double d3 = chroma;
        double saturation = (d3 != null ? d3 % (double)100 : 50.0) / (double)100;
        Double d4 = luminance;
        double value = (d4 != null ? d4 % (double)100 : 90.0) / (double)100;
        Iterable iterable = hueIntervals;
        ColorHueMapperProvider colorHueMapperProvider = this;
        boolean $i$f$map = false;
        void var22_19 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)new HSV(((Number)it.getFirst()).doubleValue(), saturation, value), (Object)new HSV(((Number)it.getSecond()).doubleValue(), saturation, value)));
        }
        colorHueMapperProvider.myHSVIntervals = (List)destination$iv$iv;
        this.myFromHSV = new HSV(fromHue, saturation, value);
        this.myToHSV = new HSV(toHue, saturation, value);
    }

    @Override
    @NotNull
    public ScaleMapper<Color> createDiscreteMapper(@NotNull DiscreteTransform discreteTransform) {
        Intrinsics.checkNotNullParameter((Object)discreteTransform, (String)"discreteTransform");
        return this.createDiscreteMapper(discreteTransform.getEffectiveDomainTransformed(), this.myFromHSV, this.myToHSV);
    }

    @Override
    @NotNull
    public GuideMapper<Color> createContinuousMapper(@NotNull DoubleSpan domain, @NotNull ContinuousTransform trans) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        DoubleSpan domain2 = MapperUtil.INSTANCE.rangeWithLimitsAfterTransform(domain, trans);
        return this.createContinuousMapper(domain2, this.myHSVIntervals);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\b2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u000fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/scale/provider/ColorHueMapperProvider$Companion;", "", "()V", "DEFAULT", "Ljetbrains/datalore/plot/builder/scale/provider/ColorHueMapperProvider;", "getDEFAULT", "()Ljetbrains/datalore/plot/builder/scale/provider/ColorHueMapperProvider;", "DEF_HUE_RANGE", "Ljetbrains/datalore/base/interval/DoubleSpan;", "DEF_SATURATION", "", "DEF_START_HUE", "DEF_VALUE", "normalizeHueRange", "hueRange", "", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorHueMapperProvider getDEFAULT() {
            return DEFAULT;
        }

        private final DoubleSpan normalizeHueRange(List<Double> hueRange) {
            return hueRange == null || hueRange.size() != 2 ? DEF_HUE_RANGE : new DoubleSpan(Math.min(((Number)hueRange.get(0)).doubleValue(), ((Number)hueRange.get(1)).doubleValue()), Math.max(((Number)hueRange.get(0)).doubleValue(), ((Number)hueRange.get(1)).doubleValue()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

