/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.guide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.ScaleMapper;
import jetbrains.datalore.plot.base.render.svg.Text;
import jetbrains.datalore.plot.base.scale.Mappers;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.builder.guide.LegendBoxLayout;
import jetbrains.datalore.plot.builder.guide.LegendDirection;
import jetbrains.datalore.plot.builder.layout.PlotLabelSpecFactory;
import jetbrains.datalore.plot.builder.layout.PlotLayoutUtil;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\b&\u0018\u0000 '2\u00020\u0001:\u0004&'()B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0017H \u00a2\u0006\u0002\b%R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0012\u0010\u001f\u001a\u00020\u0017X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0019R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006*"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout;", "Ljetbrains/datalore/plot/builder/guide/LegendBoxLayout;", "title", "", "domain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "guideBarSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "legendDirection", "Ljetbrains/datalore/plot/builder/guide/LegendDirection;", "reverse", "", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "(Ljava/lang/String;Ljetbrains/datalore/base/interval/DoubleSpan;Ljetbrains/datalore/plot/base/scale/ScaleBreaks;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/builder/guide/LegendDirection;ZLjetbrains/datalore/plot/builder/theme/LegendTheme;)V", "<set-?>", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "barBounds", "getBarBounds", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "barLengthExpand", "", "getBarLengthExpand", "()D", "breakInfos", "", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "getBreakInfos$plot_builder_portable", "()Ljava/util/List;", "guideBarLength", "getGuideBarLength", "getGuideBarSize", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "createBreakInfo", "tickLocation", "createBreakInfo$plot_builder_portable", "BreakInfo", "Companion", "HorizontalLayout", "VerticalLayout", "plot-builder-portable"})
public abstract class ColorBarComponentLayout
extends LegendBoxLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DoubleVector guideBarSize;
    @NotNull
    private DoubleRectangle barBounds;
    private final double barLengthExpand;
    @NotNull
    private final List<BreakInfo> breakInfos;

    /*
     * WARNING - void declaration
     */
    public ColorBarComponentLayout(@NotNull String title, @NotNull DoubleSpan domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector guideBarSize, @NotNull LegendDirection legendDirection, boolean reverse, @NotNull LegendTheme theme) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)guideBarSize, (String)"guideBarSize");
        Intrinsics.checkNotNullParameter((Object)((Object)legendDirection), (String)"legendDirection");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(title, legendDirection, theme);
        this.guideBarSize = guideBarSize;
        this.barLengthExpand = 2.0;
        double guideBarLength = this.getGuideBarLength();
        DoubleSpan targetRange = new DoubleSpan(0.0 + this.barLengthExpand, guideBarLength - this.barLengthExpand);
        ScaleMapper mapper = Mappers.INSTANCE.linear(domain, targetRange, reverse);
        Iterable iterable = breaks.getTransformedValues();
        ColorBarComponentLayout colorBarComponentLayout = this;
        boolean $i$f$map = false;
        void var14_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = mapper.invoke(Double.valueOf((double)it));
            Intrinsics.checkNotNull((Object)object);
            double tickLocation = ((Number)object).doubleValue();
            collection.add(this.createBreakInfo$plot_builder_portable(tickLocation));
        }
        colorBarComponentLayout.breakInfos = (List)destination$iv$iv;
        this.barBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), this.guideBarSize);
    }

    @NotNull
    protected final DoubleVector getGuideBarSize() {
        return this.guideBarSize;
    }

    @NotNull
    public final DoubleRectangle getBarBounds() {
        return this.barBounds;
    }

    public final double getBarLengthExpand() {
        return this.barLengthExpand;
    }

    protected abstract double getGuideBarLength();

    @NotNull
    public final List<BreakInfo> getBreakInfos$plot_builder_portable() {
        return this.breakInfos;
    }

    @NotNull
    public abstract BreakInfo createBreakInfo$plot_builder_portable(double var1);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "", "tickLocation", "", "labelLocation", "Ljetbrains/datalore/base/geometry/DoubleVector;", "labelHorizontalAnchor", "Ljetbrains/datalore/plot/base/render/svg/Text$HorizontalAnchor;", "labelVerticalAnchor", "Ljetbrains/datalore/plot/base/render/svg/Text$VerticalAnchor;", "(DLjetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/base/render/svg/Text$HorizontalAnchor;Ljetbrains/datalore/plot/base/render/svg/Text$VerticalAnchor;)V", "getLabelHorizontalAnchor", "()Ljetbrains/datalore/plot/base/render/svg/Text$HorizontalAnchor;", "getLabelLocation", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "getLabelVerticalAnchor", "()Ljetbrains/datalore/plot/base/render/svg/Text$VerticalAnchor;", "getTickLocation", "()D", "plot-builder-portable"})
    public static final class BreakInfo {
        private final double tickLocation;
        @NotNull
        private final DoubleVector labelLocation;
        @NotNull
        private final Text.HorizontalAnchor labelHorizontalAnchor;
        @NotNull
        private final Text.VerticalAnchor labelVerticalAnchor;

        public BreakInfo(double tickLocation, @NotNull DoubleVector labelLocation, @NotNull Text.HorizontalAnchor labelHorizontalAnchor, @NotNull Text.VerticalAnchor labelVerticalAnchor) {
            Intrinsics.checkNotNullParameter((Object)labelLocation, (String)"labelLocation");
            Intrinsics.checkNotNullParameter((Object)labelHorizontalAnchor, (String)"labelHorizontalAnchor");
            Intrinsics.checkNotNullParameter((Object)labelVerticalAnchor, (String)"labelVerticalAnchor");
            this.tickLocation = tickLocation;
            this.labelLocation = labelLocation;
            this.labelHorizontalAnchor = labelHorizontalAnchor;
            this.labelVerticalAnchor = labelVerticalAnchor;
        }

        public final double getTickLocation() {
            return this.tickLocation;
        }

        @NotNull
        public final DoubleVector getLabelLocation() {
            return this.labelLocation;
        }

        @NotNull
        public final Text.HorizontalAnchor getLabelHorizontalAnchor() {
            return this.labelHorizontalAnchor;
        }

        @NotNull
        public final Text.VerticalAnchor getLabelVerticalAnchor() {
            return this.labelVerticalAnchor;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u001bR\u0014\u0010\u000f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$HorizontalLayout;", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout;", "title", "", "domain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "barSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "reverse", "", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "(Ljava/lang/String;Ljetbrains/datalore/base/interval/DoubleSpan;Ljetbrains/datalore/plot/base/scale/ScaleBreaks;Ljetbrains/datalore/base/geometry/DoubleVector;ZLjetbrains/datalore/plot/builder/theme/LegendTheme;)V", "graphSize", "getGraphSize", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "guideBarLength", "", "getGuideBarLength", "()D", "labelDistance", "getLabelDistance", "createBreakInfo", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "tickLocation", "createBreakInfo$plot_builder_portable", "plot-builder-portable"})
    private static final class HorizontalLayout
    extends ColorBarComponentLayout {
        @NotNull
        private final DoubleVector graphSize;

        public HorizontalLayout(@NotNull String title, @NotNull DoubleSpan domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector barSize, boolean reverse, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            super(title, domain, breaks, barSize, LegendDirection.HORIZONTAL, reverse, theme);
            Iterator iterator = ((Iterable)breaks.getLabels()).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            String label = (String)iterator.next();
            boolean bl = false;
            double d = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder_portable(label, PlotLabelSpecFactory.INSTANCE.legendItem(theme)).getY();
            while (iterator.hasNext()) {
                String label2 = (String)iterator.next();
                $i$a$-maxOf-ColorBarComponentLayout$HorizontalLayout$maxLabelHeight$1 = false;
                double d2 = PlotLayoutUtil.INSTANCE.textDimensions$plot_builder_portable(label2, PlotLabelSpecFactory.INSTANCE.legendItem(theme)).getY();
                d = Math.max(d, d2);
            }
            double maxLabelHeight = d;
            this.graphSize = new DoubleVector(this.getGuideBarSize().getX(), this.getGuideBarSize().getY() + this.getLabelDistance() + maxLabelHeight);
        }

        @Override
        @NotNull
        public DoubleVector getGraphSize() {
            return this.graphSize;
        }

        private final double getLabelDistance() {
            return PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme()).height() / (double)3;
        }

        @Override
        protected double getGuideBarLength() {
            return this.getGuideBarSize().getX();
        }

        @Override
        @NotNull
        public BreakInfo createBreakInfo$plot_builder_portable(double tickLocation) {
            DoubleVector labelLocation = new DoubleVector(tickLocation, this.getGuideBarSize().getY() + this.getLabelDistance());
            return new BreakInfo(tickLocation, labelLocation, Text.HorizontalAnchor.MIDDLE, Text.VerticalAnchor.TOP);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u001bR\u0014\u0010\u000f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$VerticalLayout;", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout;", "title", "", "domain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "barSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "reverse", "", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "(Ljava/lang/String;Ljetbrains/datalore/base/interval/DoubleSpan;Ljetbrains/datalore/plot/base/scale/ScaleBreaks;Ljetbrains/datalore/base/geometry/DoubleVector;ZLjetbrains/datalore/plot/builder/theme/LegendTheme;)V", "graphSize", "getGraphSize", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "guideBarLength", "", "getGuideBarLength", "()D", "labelDistance", "getLabelDistance", "createBreakInfo", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$BreakInfo;", "tickLocation", "createBreakInfo$plot_builder_portable", "plot-builder-portable"})
    private static final class VerticalLayout
    extends ColorBarComponentLayout {
        @NotNull
        private final DoubleVector graphSize;

        public VerticalLayout(@NotNull String title, @NotNull DoubleSpan domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector barSize, boolean reverse, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            super(title, domain, breaks, barSize, LegendDirection.VERTICAL, reverse, theme);
            if (!(!breaks.isEmpty())) {
                boolean bl = false;
                String string = "Colorbar VerticalLayout received empty breaks list.";
                throw new IllegalStateException(string.toString());
            }
            Iterator iterator = ((Iterable)breaks.getLabels()).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            String it = (String)iterator.next();
            boolean bl = false;
            double d = PlotLabelSpecFactory.INSTANCE.legendItem(theme).width(it);
            while (iterator.hasNext()) {
                String it2 = (String)iterator.next();
                $i$a$-maxOf-ColorBarComponentLayout$VerticalLayout$maxLabelWidth$1 = false;
                double d2 = PlotLabelSpecFactory.INSTANCE.legendItem(theme).width(it2);
                d = Math.max(d, d2);
            }
            double maxLabelWidth = d;
            this.graphSize = new DoubleVector(this.getGuideBarSize().getX() + this.getLabelDistance() + maxLabelWidth, this.getGuideBarSize().getY());
        }

        @Override
        @NotNull
        public DoubleVector getGraphSize() {
            return this.graphSize;
        }

        private final double getLabelDistance() {
            return PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme()).width("_") / (double)2;
        }

        @Override
        protected double getGuideBarLength() {
            return this.getGuideBarSize().getY();
        }

        @Override
        @NotNull
        public BreakInfo createBreakInfo$plot_builder_portable(double tickLocation) {
            DoubleVector labelLocation = new DoubleVector(this.getGuideBarSize().getX() + this.getLabelDistance(), tickLocation);
            return new BreakInfo(tickLocation, labelLocation, Text.HorizontalAnchor.LEFT, Text.VerticalAnchor.CENTER);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J6\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout$Companion;", "", "()V", "horizontal", "Ljetbrains/datalore/plot/builder/guide/ColorBarComponentLayout;", "title", "", "domain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "breaks", "Ljetbrains/datalore/plot/base/scale/ScaleBreaks;", "barSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "reverse", "", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "vertical", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColorBarComponentLayout horizontal(@NotNull String title, @NotNull DoubleSpan domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector barSize, boolean reverse, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            return new HorizontalLayout(title, domain, breaks, barSize, reverse, theme);
        }

        @NotNull
        public final ColorBarComponentLayout vertical(@NotNull String title, @NotNull DoubleSpan domain, @NotNull ScaleBreaks breaks, @NotNull DoubleVector barSize, boolean reverse, @NotNull LegendTheme theme) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)barSize, (String)"barSize");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            return new VerticalLayout(title, domain, breaks, barSize, reverse, theme);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

