/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\b&\u0018\u0000 \u00142\u00020\u0001:\u0003\u0014\u0015\u0016B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0004J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0003H\u0004R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00038F@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004\u00a8\u0006\u0017"}, d2={"Ljetbrains/datalore/plot/common/data/RegularMeshDetector;", "", "maxError", "", "(D)V", "<set-?>", "", "isMesh", "()Z", "setMesh", "(Z)V", "resolution", "getResolution", "()D", "setResolution", "equalsEnough", "d1", "d2", "nearZero", "d", "Companion", "MyColumnDetector", "MyRowDetector", "plot-common-portable"})
public abstract class RegularMeshDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double maxError;
    private boolean isMesh;
    private double resolution;
    public static final int ROW_THRESHOLD = 50;
    public static final int COLUMN_THRESHOLD = 10;
    @NotNull
    private static final RegularMeshDetector NO_MESH = new RegularMeshDetector(){

        public boolean isMesh() {
            return false;
        }

        protected void setMesh(boolean value) {
            super.setMesh(value);
        }
    };

    protected RegularMeshDetector(double maxError) {
        this.maxError = maxError;
    }

    public boolean isMesh() {
        return this.isMesh;
    }

    protected void setMesh(boolean bl) {
        this.isMesh = bl;
    }

    public final double getResolution() {
        if (!this.isMesh()) {
            boolean bl = false;
            String string = "Not a mesh";
            throw new IllegalStateException(string.toString());
        }
        return this.resolution;
    }

    protected final void setResolution(double d) {
        this.resolution = d;
    }

    protected final boolean equalsEnough(double d1, double d2) {
        return d1 == d2 || Math.abs(d1 - d2) <= this.maxError;
    }

    protected final boolean nearZero(double d) {
        return Math.abs(d) <= this.maxError;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\t\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007H\u0002\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/common/data/RegularMeshDetector$MyRowDetector;", "Ljetbrains/datalore/plot/common/data/RegularMeshDetector;", "minRowSize", "", "error", "", "values", "", "(IDLjava/lang/Iterable;)V", "resOrNull", "(Ljava/lang/Iterable;)Ljava/lang/Double;", "plot-common-portable"})
    private static final class MyRowDetector
    extends RegularMeshDetector {
        private final int minRowSize;

        public MyRowDetector(int minRowSize, double error, @NotNull Iterable<Double> values) {
            block0: {
                Intrinsics.checkNotNullParameter(values, (String)"values");
                super(error);
                this.minRowSize = minRowSize;
                Double d = this.resOrNull(values);
                if (d == null) break block0;
                double it = ((Number)d).doubleValue();
                boolean bl = false;
                this.setMesh(true);
                this.setResolution(it);
            }
        }

        private final Double resOrNull(Iterable<Double> values) {
            List values2 = CollectionsKt.take(values, (int)this.minRowSize);
            if (values2.size() < this.minRowSize) {
                return null;
            }
            double firstDistance = Double.NaN;
            double prevValue = Double.NaN;
            for (Double value : values2) {
                double d;
                if (value == null || !(!Double.isInfinite(d = value.doubleValue()) && !Double.isNaN(d))) {
                    return null;
                }
                d = prevValue;
                if (!Double.isInfinite(d) && !Double.isNaN(d)) {
                    double dist = value - prevValue;
                    if (this.nearZero(dist)) {
                        return null;
                    }
                    if (Double.isNaN(firstDistance)) {
                        firstDistance = dist;
                    } else if (!this.equalsEnough(dist, firstDistance)) {
                        return null;
                    }
                }
                prevValue = value;
            }
            double d = firstDistance;
            if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            return Math.abs(firstDistance);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\t\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0007H\u0002\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/common/data/RegularMeshDetector$MyColumnDetector;", "Ljetbrains/datalore/plot/common/data/RegularMeshDetector;", "minColSize", "", "error", "", "values", "", "(IDLjava/lang/Iterable;)V", "resOrNull", "(Ljava/lang/Iterable;)Ljava/lang/Double;", "plot-common-portable"})
    private static final class MyColumnDetector
    extends RegularMeshDetector {
        private final int minColSize;

        public MyColumnDetector(int minColSize, double error, @NotNull Iterable<Double> values) {
            block0: {
                Intrinsics.checkNotNullParameter(values, (String)"values");
                super(error);
                this.minColSize = minColSize;
                Double d = this.resOrNull(values);
                if (d == null) break block0;
                double it = ((Number)d).doubleValue();
                boolean bl = false;
                this.setMesh(true);
                this.setResolution(it);
            }
        }

        private final Double resOrNull(Iterable<Double> values) {
            ArrayList<Double> rowValues = new ArrayList<Double>();
            int firstColSize = 0;
            int currColSize = 0;
            int colIndex = 0;
            double lastValue = Double.NaN;
            for (Double value : values) {
                double d;
                if (value == null || !(!Double.isInfinite(d = value.doubleValue()) && !Double.isNaN(d))) {
                    return null;
                }
                if (Double.isNaN(lastValue)) {
                    currColSize = 1;
                    rowValues.add(value);
                } else if (this.equalsEnough(lastValue, value)) {
                    ++currColSize;
                } else {
                    if (firstColSize == 0) {
                        if (currColSize < this.minColSize) {
                            return null;
                        }
                        firstColSize = currColSize;
                    }
                    if (currColSize != firstColSize) {
                        return null;
                    }
                    ++colIndex;
                    currColSize = 1;
                    rowValues.add(value);
                }
                lastValue = value;
            }
            if (rowValues.size() < 2) {
                return null;
            }
            if (currColSize != firstColSize) {
                return null;
            }
            CollectionsKt.sort((List)rowValues);
            double d = ((Number)rowValues.get(1)).doubleValue();
            Object e = rowValues.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"rowValues[0]");
            double minDelta = d - ((Number)e).doubleValue();
            int n = rowValues.size();
            for (int i = 1; i < n; ++i) {
                double d2 = ((Number)rowValues.get(i)).doubleValue();
                Object e2 = rowValues.get(i - 1);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"rowValues[i - 1]");
                double d3 = d2 - ((Number)e2).doubleValue();
                minDelta = Math.min(minDelta, d3);
            }
            return this.nearZero(minDelta) ? null : Double.valueOf(minDelta);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\rJ\u0016\u0010\b\u001a\u00020\u00062\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\rJ&\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\rJ\u0016\u0010\u000e\u001a\u00020\u00062\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/datalore/plot/common/data/RegularMeshDetector$Companion;", "", "()V", "COLUMN_THRESHOLD", "", "NO_MESH", "Ljetbrains/datalore/plot/common/data/RegularMeshDetector;", "ROW_THRESHOLD", "tryColumn", "minRowSize", "error", "", "values", "", "tryRow", "plot-common-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RegularMeshDetector tryRow(@NotNull Iterable<Double> values) {
            Double v1;
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Iterator<Double> valuesIterator = values.iterator();
            Double v0 = valuesIterator.hasNext() ? valuesIterator.next() : null;
            Double d = v1 = valuesIterator.hasNext() ? valuesIterator.next() : null;
            if (v0 == null || v1 == null) {
                return NO_MESH;
            }
            double delta = Math.abs(v1 - v0);
            double d2 = delta;
            if (!(!Double.isInfinite(d2) && !Double.isNaN(d2))) {
                return NO_MESH;
            }
            double error = delta / 10000.0;
            return this.tryRow(50, error, values);
        }

        @NotNull
        public final RegularMeshDetector tryRow(int minRowSize, double error, @NotNull Iterable<Double> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new MyRowDetector(minRowSize, error, values);
        }

        @NotNull
        public final RegularMeshDetector tryColumn(@NotNull Iterable<Double> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return this.tryColumn(10, 1.0E-50, values);
        }

        @NotNull
        public final RegularMeshDetector tryColumn(int minRowSize, double error, @NotNull Iterable<Double> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new MyColumnDetector(minRowSize, error, values);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

