/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSingle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020$H\u0016J\u0016\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0006R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006,"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkPHYS;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSingle;", "info", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "dpi", "", "asDpi", "getAsDpi", "()D", "setAsDpi", "(D)V", "asDpi2", "", "getAsDpi2", "()[D", "orderingConstraint", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "getOrderingConstraint", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "pixelsxUnitX", "", "getPixelsxUnitX", "()J", "setPixelsxUnitX", "(J)V", "pixelsxUnitY", "getPixelsxUnitY", "setPixelsxUnitY", "units", "", "getUnits", "()I", "setUnits", "(I)V", "createRawChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "parseFromRaw", "", "chunk", "setAsDpi2", "dpix", "dpiy", "Companion", "plot-api"})
public final class PngChunkPHYS
extends PngChunkSingle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long pixelsxUnitX;
    private long pixelsxUnitY;
    private int units;
    @NotNull
    public static final String ID = "pHYs";

    public PngChunkPHYS(@Nullable ImageInfo info) {
        super(ID, info);
    }

    public final long getPixelsxUnitX() {
        return this.pixelsxUnitX;
    }

    public final void setPixelsxUnitX(long l) {
        this.pixelsxUnitX = l;
    }

    public final long getPixelsxUnitY() {
        return this.pixelsxUnitY;
    }

    public final void setPixelsxUnitY(long l) {
        this.pixelsxUnitY = l;
    }

    public final int getUnits() {
        return this.units;
    }

    public final void setUnits(int n) {
        this.units = n;
    }

    @Override
    @NotNull
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_IDAT;
    }

    @Override
    @NotNull
    public ChunkRaw createRawChunk() {
        ChunkRaw c = this.createEmptyChunk(9, true);
        PngHelperInternal.INSTANCE.writeInt4tobytes((int)this.pixelsxUnitX, c.getData(), 0);
        PngHelperInternal.INSTANCE.writeInt4tobytes((int)this.pixelsxUnitY, c.getData(), 4);
        byte[] byArray = c.getData();
        Intrinsics.checkNotNull((Object)byArray);
        byArray[8] = (byte)this.units;
        return c;
    }

    @Override
    public void parseFromRaw(@NotNull ChunkRaw chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (chunk.getLen() != 9) {
            throw new PngjException("bad chunk length " + chunk);
        }
        this.pixelsxUnitX = PngHelperInternal.INSTANCE.readInt4fromBytes(chunk.getData(), 0);
        if (this.pixelsxUnitX < 0L) {
            this.pixelsxUnitX += 0x100000000L;
        }
        this.pixelsxUnitY = PngHelperInternal.INSTANCE.readInt4fromBytes(chunk.getData(), 4);
        if (this.pixelsxUnitY < 0L) {
            this.pixelsxUnitY += 0x100000000L;
        }
        this.units = PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), 8);
    }

    public final double getAsDpi() {
        return this.units != 1 || this.pixelsxUnitX != this.pixelsxUnitY ? -1.0 : (double)this.pixelsxUnitX * 0.0254;
    }

    public final void setAsDpi(double dpi) {
        this.units = 1;
        this.pixelsxUnitY = this.pixelsxUnitX = (long)(dpi / 0.0254 + 0.5);
    }

    @NotNull
    public final double[] getAsDpi2() {
        double[] dArray;
        if (this.units != 1) {
            double[] dArray2 = new double[]{-1.0, -1.0};
            dArray = dArray2;
        } else {
            double[] dArray3 = new double[]{(double)this.pixelsxUnitX * 0.0254, (double)this.pixelsxUnitY * 0.0254};
            dArray = dArray3;
        }
        return dArray;
    }

    public final void setAsDpi2(double dpix, double dpiy) {
        this.units = 1;
        this.pixelsxUnitX = (long)(dpix / 0.0254 + 0.5);
        this.pixelsxUnitY = (long)(dpiy / 0.0254 + 0.5);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkPHYS$Companion;", "", "()V", "ID", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

