/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSingle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkOFFS;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSingle;", "info", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "orderingConstraint", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "getOrderingConstraint", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "posX", "", "getPosX", "()J", "setPosX", "(J)V", "posY", "getPosY", "setPosY", "units", "", "getUnits", "()I", "setUnits", "(I)V", "createRawChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "parseFromRaw", "", "chunk", "Companion", "plot-api"})
public final class PngChunkOFFS
extends PngChunkSingle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long posX;
    private long posY;
    private int units;
    @NotNull
    public static final String ID = "oFFs";

    public PngChunkOFFS(@Nullable ImageInfo info) {
        super(ID, info);
    }

    public final long getPosX() {
        return this.posX;
    }

    public final void setPosX(long l) {
        this.posX = l;
    }

    public final long getPosY() {
        return this.posY;
    }

    public final void setPosY(long l) {
        this.posY = l;
    }

    public final int getUnits() {
        return this.units;
    }

    public final void setUnits(int n) {
        this.units = n;
    }

    @Override
    @NotNull
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_IDAT;
    }

    @Override
    @NotNull
    public ChunkRaw createRawChunk() {
        ChunkRaw c = this.createEmptyChunk(9, true);
        PngHelperInternal.INSTANCE.writeInt4tobytes((int)this.posX, c.getData(), 0);
        PngHelperInternal.INSTANCE.writeInt4tobytes((int)this.posY, c.getData(), 4);
        byte[] byArray = c.getData();
        Intrinsics.checkNotNull((Object)byArray);
        byArray[8] = (byte)this.units;
        return c;
    }

    @Override
    public void parseFromRaw(@NotNull ChunkRaw chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (chunk.getLen() != 9) {
            throw new PngjException("bad chunk length " + chunk);
        }
        this.posX = PngHelperInternal.INSTANCE.readInt4fromBytes(chunk.getData(), 0);
        if (this.posX < 0L) {
            this.posX += 0x100000000L;
        }
        this.posY = PngHelperInternal.INSTANCE.readInt4fromBytes(chunk.getData(), 4);
        if (this.posY < 0L) {
            this.posY += 0x100000000L;
        }
        this.units = PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), 8);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkOFFS$Companion;", "", "()V", "ID", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

