/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkHelper;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkPredicate;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSPLT;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkTextVar;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0010\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u000eJ\"\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001e\u001a\u00020\u000eJ\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00192\b\u0010 \u001a\u0004\u0018\u00010\u0007J\b\u0010!\u001a\u00020\u001bH\u0016J\b\u0010\"\u001a\u00020\u001bH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunksList;", "", "imfinfo", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "chunks", "", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk;", "getChunks", "()Ljava/util/List;", "imageInfo", "getImageInfo", "()Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "withPlte", "", "getWithPlte", "()Z", "setWithPlte", "(Z)V", "appendReadChunk", "", "chunk", "chunkGroup", "", "getById", "", "id", "", "innerid", "getById1", "failIfMultiple", "getEquivalent", "c2", "toString", "toStringFull", "Companion", "plot-api"})
public class ChunksList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PngChunk> chunks;
    @NotNull
    private final ImageInfo imageInfo;
    private boolean withPlte;
    public static final int CHUNK_GROUP_0_IDHR = 0;
    public static final int CHUNK_GROUP_1_AFTERIDHR = 1;
    public static final int CHUNK_GROUP_2_PLTE = 2;
    public static final int CHUNK_GROUP_3_AFTERPLTE = 3;
    public static final int CHUNK_GROUP_4_IDAT = 4;
    public static final int CHUNK_GROUP_5_AFTERIDAT = 5;
    public static final int CHUNK_GROUP_6_END = 6;

    public ChunksList(@NotNull ImageInfo imfinfo) {
        Intrinsics.checkNotNullParameter((Object)imfinfo, (String)"imfinfo");
        this.chunks = new ArrayList();
        this.imageInfo = imfinfo;
    }

    @NotNull
    public final List<PngChunk> getChunks() {
        return this.chunks;
    }

    @NotNull
    public final ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public final boolean getWithPlte() {
        return this.withPlte;
    }

    public final void setWithPlte(boolean bl) {
        this.withPlte = bl;
    }

    public final void appendReadChunk(@NotNull PngChunk chunk, int chunkGroup) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        chunk.setChunkGroup(chunkGroup);
        this.chunks.add(chunk);
        if (Intrinsics.areEqual((Object)chunk.getId(), (Object)"PLTE")) {
            this.withPlte = true;
        }
    }

    @NotNull
    public final List<PngChunk> getById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getById(id, null);
    }

    @NotNull
    public final List<PngChunk> getById(@NotNull String id, @Nullable String innerid) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return ChunksList.getXById(this.chunks, id, innerid);
    }

    @Nullable
    public final PngChunk getById1(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getById1(id, false);
    }

    @Nullable
    public final PngChunk getById1(@NotNull String id, boolean failIfMultiple) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getById1(id, null, failIfMultiple);
    }

    @Nullable
    public final PngChunk getById1(@NotNull String id, @Nullable String innerid, boolean failIfMultiple) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        List<PngChunk> list = this.getById(id, innerid);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1 && (failIfMultiple || !list.get(0).allowsMultiple())) {
            throw new PngjException("unexpected multiple chunks id=" + id);
        }
        return list.get(list.size() - 1);
    }

    @NotNull
    public final List<PngChunk> getEquivalent(@Nullable PngChunk c2) {
        return ChunkHelper.INSTANCE.filterList(this.chunks, new ChunkPredicate(c2){
            final /* synthetic */ PngChunk $c2;
            {
                this.$c2 = $c2;
            }

            public boolean match(@NotNull PngChunk chunk) {
                Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
                return ChunkHelper.INSTANCE.equivalent(chunk, this.$c2);
            }
        });
    }

    @NotNull
    public String toString() {
        return "ChunkList: read: " + this.chunks.size();
    }

    @NotNull
    public String toStringFull() {
        StringBuilder sb = new StringBuilder(this.toString());
        sb.append("\n Read:\n");
        for (PngChunk chunk : this.chunks) {
            sb.append(chunk).append(" G=" + chunk.getChunkGroup() + '\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    protected static final List<PngChunk> getXById(@NotNull List<? extends PngChunk> list, @NotNull String id, @Nullable String innerid) {
        return Companion.getXById(list, id, innerid);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0005R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunksList$Companion;", "", "()V", "CHUNK_GROUP_0_IDHR", "", "CHUNK_GROUP_1_AFTERIDHR", "CHUNK_GROUP_2_PLTE", "CHUNK_GROUP_3_AFTERPLTE", "CHUNK_GROUP_4_IDAT", "CHUNK_GROUP_5_AFTERIDAT", "CHUNK_GROUP_6_END", "getXById", "", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk;", "list", "id", "", "innerid", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        protected final List<PngChunk> getXById(@NotNull List<? extends PngChunk> list, @NotNull String id, @Nullable String innerid) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return innerid == null ? ChunkHelper.INSTANCE.filterList(list, new ChunkPredicate(id){
                final /* synthetic */ String $id;
                {
                    this.$id = $id;
                }

                public boolean match(@NotNull PngChunk chunk) {
                    Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
                    return Intrinsics.areEqual((Object)chunk.getId(), (Object)this.$id);
                }
            }) : ChunkHelper.INSTANCE.filterList(list, new ChunkPredicate(id, innerid){
                final /* synthetic */ String $id;
                final /* synthetic */ String $innerid;
                {
                    this.$id = $id;
                    this.$innerid = $innerid;
                }

                public boolean match(@NotNull PngChunk chunk) {
                    Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
                    if (!Intrinsics.areEqual((Object)chunk.getId(), (Object)this.$id)) {
                        return false;
                    }
                    if (chunk instanceof PngChunkTextVar && !StringsKt.equals$default((String)((PngChunkTextVar)chunk).getKey(), (String)this.$innerid, (boolean)false, (int)2, null)) {
                        return false;
                    }
                    return !(chunk instanceof PngChunkSPLT) || StringsKt.equals$default((String)((PngChunkSPLT)chunk).getPalName(), (String)this.$innerid, (boolean)false, (int)2, null);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

