/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.util.pngj.ArrayUtilsKt;
import org.jetbrains.letsPlot.util.pngj.ChunkReader;
import org.jetbrains.letsPlot.util.pngj.DeflatedChunksSet;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjInputException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b \u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J(\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0014J\u0006\u0010\u001c\u001a\u00020\u0016J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0003R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/DeflatedChunkReader;", "Lorg/jetbrains/letsPlot/util/pngj/ChunkReader;", "clen", "", "chunkid", "", "checkCrc", "", "offsetInPng", "", "iDatSet", "Lorg/jetbrains/letsPlot/util/pngj/DeflatedChunksSet;", "(ILjava/lang/String;ZJLorg/jetbrains/letsPlot/util/pngj/DeflatedChunksSet;)V", "alsoBuffer", "deflatedChunksSet", "isFromDeflatedSet", "()Z", "seqNumExpected", "skipBytes", "skippedBytes", "", "chunkDone", "", "processData", "offsetInchunk", "buf", "off", "len", "setAlsoBuffer", "setSeqNumExpected", "plot-api"})
public abstract class DeflatedChunkReader
extends ChunkReader {
    @NotNull
    private final DeflatedChunksSet deflatedChunksSet;
    private boolean alsoBuffer;
    private boolean skipBytes;
    private byte[] skippedBytes;
    private int seqNumExpected;

    public DeflatedChunkReader(int clen, @NotNull String chunkid, boolean checkCrc, long offsetInPng, @NotNull DeflatedChunksSet iDatSet) {
        Intrinsics.checkNotNullParameter((Object)chunkid, (String)"chunkid");
        Intrinsics.checkNotNullParameter((Object)iDatSet, (String)"iDatSet");
        super(clen, chunkid, offsetInPng, ChunkReader.ChunkReaderMode.PROCESS);
        this.seqNumExpected = -1;
        this.deflatedChunksSet = iDatSet;
        if (Intrinsics.areEqual((Object)chunkid, (Object)"fdAT")) {
            this.skipBytes = true;
            this.skippedBytes = new byte[4];
        }
        iDatSet.appendNewChunk(this);
    }

    @Override
    protected void processData(int offsetInchunk, @NotNull byte[] buf, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int off2 = off;
        int len2 = len;
        if (this.skipBytes && offsetInchunk < 4) {
            int oc = offsetInchunk;
            while (oc < 4 && len2 > 0) {
                byte[] byArray = this.skippedBytes;
                if (this.skippedBytes == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"skippedBytes");
                    byArray = null;
                }
                byArray[oc] = buf[off2];
                ++oc;
                ++off2;
                --len2;
            }
        }
        if (len2 > 0) {
            this.deflatedChunksSet.processBytes(buf, off2, len2);
            if (this.alsoBuffer) {
                byte[] byArray = this.getChunkRaw().getData();
                Intrinsics.checkNotNull((Object)byArray);
                ArrayUtilsKt.arraycopy(buf, off2, byArray, this.getRead(), len2);
            }
        }
    }

    @Override
    protected void chunkDone() {
        if (this.skipBytes && Intrinsics.areEqual((Object)this.getChunkRaw().getId(), (Object)"fdAT") && this.seqNumExpected >= 0) {
            int seqNum;
            byte[] byArray = this.skippedBytes;
            if (this.skippedBytes == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"skippedBytes");
                byArray = null;
            }
            if ((seqNum = PngHelperInternal.INSTANCE.readInt4fromBytes(byArray, 0)) != this.seqNumExpected) {
                throw new PngjInputException("bad chunk sequence for fDAT chunk " + seqNum + " expected " + this.seqNumExpected);
            }
        }
    }

    @Override
    public boolean isFromDeflatedSet() {
        return true;
    }

    public final void setAlsoBuffer() {
        if (!(this.getRead() > 0)) {
            boolean bl = false;
            String string = "too late";
            throw new IllegalArgumentException(string.toString());
        }
        this.alsoBuffer = true;
        this.getChunkRaw().allocData();
    }

    public final void setSeqNumExpected(int seqNumExpected) {
        this.seqNumExpected = seqNumExpected;
    }
}

