/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.export;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import jetbrains.datalore.plot.PlotHtmlExport;
import jetbrains.datalore.plot.PlotHtmlHelper;
import jetbrains.datalore.plot.PlotImageExport;
import jetbrains.datalore.plot.PlotSvgExport;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.Figure;
import org.jetbrains.letsPlot.export.VersionChecker;
import org.jetbrains.letsPlot.intern.ToSpecConvertersKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\u001a4\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u001a8\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DEF_EXPORT_DIR", "", "exportRasterImage", "", "spec", "", "", "file", "Ljava/nio/file/Path;", "scalingFactor", "", "targetDPI", "ggsave", "plot", "Lorg/jetbrains/letsPlot/Figure;", "filename", "scale", "", "dpi", "path", "plot-api"})
public final class GgsaveKt {
    @NotNull
    private static final String DEF_EXPORT_DIR = "lets-plot-images";

    @NotNull
    public static final String ggsave(@NotNull Figure plot, @NotNull String filename, @NotNull Number scale, @Nullable Number dpi, @Nullable String path2) {
        Object object;
        String ext;
        String filename2;
        block33: {
            block32: {
                Intrinsics.checkNotNullParameter((Object)plot, (String)"plot");
                Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
                Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
                filename2 = ((Object)StringsKt.trim((CharSequence)filename)).toString();
                if (!(StringsKt.indexOf$default((CharSequence)filename2, (char)'.', (int)0, (boolean)false, (int)6, null) >= 0)) {
                    boolean $i$a$-require-GgsaveKt$ggsave$42 = false;
                    String $i$a$-require-GgsaveKt$ggsave$42 = "File extension is missing: \"" + filename2 + "\".";
                    throw new IllegalArgumentException($i$a$-require-GgsaveKt$ggsave$42.toString());
                }
                if (!(((CharSequence)StringsKt.substringBeforeLast((String)filename2, (char)'.', (String)"")).length() > 0)) {
                    boolean $i$a$-require-GgsaveKt$ggsave$52 = false;
                    String $i$a$-require-GgsaveKt$ggsave$52 = "Malformed filename: \"" + filename2 + "\".";
                    throw new IllegalArgumentException($i$a$-require-GgsaveKt$ggsave$52.toString());
                }
                String $i$a$-require-GgsaveKt$ggsave$52 = StringsKt.substringAfterLast((String)filename2, (char)'.', (String)"");
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string = $i$a$-require-GgsaveKt$ggsave$52.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
                ext = string;
                if (!(((CharSequence)ext).length() > 0)) {
                    boolean $i$a$-require-GgsaveKt$ggsave$62 = false;
                    String $i$a$-require-GgsaveKt$ggsave$62 = "Missing file extension: \"" + filename2 + "\".";
                    throw new IllegalArgumentException($i$a$-require-GgsaveKt$ggsave$62.toString());
                }
                object = path2;
                if (object == null) break block32;
                String it = object;
                boolean bl = false;
                Path path3 = Paths.get(path2, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(path)");
                object = path3;
                if (path3 != null) break block33;
            }
            String string = System.getProperty("user.dir");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"user.dir\")");
            String string2 = string;
            Object object2 = new String[]{DEF_EXPORT_DIR};
            Path path4 = Paths.get(string2, Arrays.copyOf(object2, ((String[])object2).length));
            object = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(base, *subpaths)");
        }
        Object dir = object;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)dir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(this, *attributes)");
        Path file = dir.resolve(filename2);
        Map<String, Object> spec = ToSpecConvertersKt.toSpec(plot);
        switch (ext) {
            case "svg": {
                String svg = PlotSvgExport.buildSvgImageFromRawSpecs$default((PlotSvgExport)PlotSvgExport.INSTANCE, spec, null, (int)2, null);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(file, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"createFile(this, *attributes)");
                }
                PathsKt.writeText$default((Path)file, (CharSequence)svg, null, (OpenOption[])new OpenOption[0], (int)2, null);
                break;
            }
            case "htm": 
            case "html": {
                PlotHtmlExport plotHtmlExport = PlotHtmlExport.INSTANCE;
                String string = PlotHtmlHelper.INSTANCE.scriptUrl(VersionChecker.INSTANCE.getLetsPlotJsVersion());
                String html = PlotHtmlExport.buildHtmlFromRawSpecs$default((PlotHtmlExport)plotHtmlExport, spec, (String)string, (boolean)true, null, (int)8, null);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    FileAttribute[] fileAttributeArray3 = new FileAttribute[]{};
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(file, Arrays.copyOf(fileAttributeArray3, fileAttributeArray3.length)), (String)"createFile(this, *attributes)");
                }
                PathsKt.writeText$default((Path)file, (CharSequence)html, null, (OpenOption[])new OpenOption[0], (int)2, null);
                break;
            }
            case "jpg": 
            case "tif": 
            case "tiff": 
            case "png": 
            case "jpeg": {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                Number number = dpi;
                GgsaveKt.exportRasterImage(spec, file, scale.doubleValue(), number != null ? number.doubleValue() : Double.NaN);
                break;
            }
            default: {
                throw new IllegalArgumentException(StringsKt.trimIndent((String)("\n            Unsupported file extension: \"" + ext + "\".\n            Please use one of: \"svg\", \"html\", \"htm\", \"png\", \"jpeg\", \"jpg\", \"tiff\", \"tif\". \n        ")));
            }
        }
        return ((Object)file.toRealPath(new LinkOption[0])).toString();
    }

    public static /* synthetic */ String ggsave$default(Figure figure, String string, Number number, Number number2, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            number = 2;
        }
        if ((n & 8) != 0) {
            number2 = null;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        return GgsaveKt.ggsave(figure, string, number, number2, string2);
    }

    private static final void exportRasterImage(Map<String, Object> spec, Path file, double scalingFactor, double targetDPI) {
        byte[] byArray;
        try {
            PlotImageExport.Format format;
            String string = PathsKt.getExtension((Path)file);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            switch (string2) {
                case "png": {
                    format = (PlotImageExport.Format)PlotImageExport.Format.PNG.INSTANCE;
                    break;
                }
                case "jpg": 
                case "jpeg": {
                    format = (PlotImageExport.Format)new PlotImageExport.Format.JPEG(0.0, 1, null);
                    break;
                }
                case "tif": 
                case "tiff": {
                    format = (PlotImageExport.Format)PlotImageExport.Format.TIFF.INSTANCE;
                    break;
                }
                default: {
                    String ext;
                    throw new IllegalArgumentException("Unsupported format: " + ext);
                }
            }
            PlotImageExport.Format format2 = format;
            PlotImageExport.ImageData image = PlotImageExport.INSTANCE.buildImageFromRawSpecs(spec, format2, scalingFactor, targetDPI);
            byArray = image.getBytes();
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (throwable instanceof ClassNotFoundException ? true : throwable instanceof NoClassDefFoundError) {
                throw new IllegalStateException(StringsKt.trimIndent((String)("\n                    \n                    Can't export plot to raster formats: " + Reflection.getOrCreateKotlinClass(e.getClass()).getSimpleName() + " \"" + e.getMessage() + "\".\n                    Please add \"lets-plot-image-export-<version>.jar\" to your classpath. \n                ")));
            }
            throw e;
        }
        byte[] imageBytes = byArray;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(file, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(this, *attributes)");
        }
        OpenOption[] openOptionArray = new OpenOption[]{};
        Files.write(file, imageBytes, Arrays.copyOf(openOptionArray, openOptionArray.length));
    }
}

