/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.canvas.awt;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jetbrains.datalore.base.event.MouseEventSpec;
import jetbrains.datalore.base.event.awt.AwtEventUtil;
import jetbrains.datalore.base.geometry.Rectangle;
import jetbrains.datalore.base.geometry.Vector;
import jetbrains.datalore.vis.canvas.EventPeer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u00042\u00020\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0002H\u0014J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0002H\u0014J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/vis/canvas/awt/AwtEventPeer;", "Ljetbrains/datalore/vis/canvas/EventPeer;", "Ljetbrains/datalore/base/event/MouseEventSpec;", "Ljetbrains/datalore/base/event/MouseEvent;", "Ljava/awt/event/MouseListener;", "Ljava/awt/event/MouseMotionListener;", "component", "Ljava/awt/Component;", "myTargetBounds", "Ljetbrains/datalore/base/geometry/Rectangle;", "(Ljava/awt/Component;Ljetbrains/datalore/base/geometry/Rectangle;)V", "isHitOnTarget", "", "event", "Ljava/awt/event/MouseEvent;", "mouseClicked", "", "e", "mouseDragged", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "onSpecAdded", "spec", "onSpecRemoved", "translate", "vis-canvas"})
public final class AwtEventPeer
extends EventPeer<MouseEventSpec, jetbrains.datalore.base.event.MouseEvent>
implements MouseListener,
MouseMotionListener {
    @NotNull
    private final Rectangle myTargetBounds;

    public AwtEventPeer(@NotNull Component component, @NotNull Rectangle myTargetBounds) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)myTargetBounds, (String)"myTargetBounds");
        super(Reflection.getOrCreateKotlinClass(MouseEventSpec.class));
        this.myTargetBounds = myTargetBounds;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
    }

    @Override
    protected void onSpecAdded(@NotNull MouseEventSpec spec) {
        Intrinsics.checkNotNullParameter((Object)((Object)spec), (String)"spec");
    }

    @Override
    protected void onSpecRemoved(@NotNull MouseEventSpec spec) {
        Intrinsics.checkNotNullParameter((Object)((Object)spec), (String)"spec");
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isHitOnTarget(e)) {
            return;
        }
        if (e.getClickCount() % 2 == 1) {
            this.dispatch((Enum)MouseEventSpec.MOUSE_CLICKED, this.translate(e));
        } else {
            this.dispatch((Enum)MouseEventSpec.MOUSE_DOUBLE_CLICKED, this.translate(e));
        }
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isHitOnTarget(e)) {
            return;
        }
        this.dispatch((Enum)MouseEventSpec.MOUSE_PRESSED, this.translate(e));
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.dispatch((Enum)MouseEventSpec.MOUSE_RELEASED, this.translate(e));
    }

    @Override
    public void mouseEntered(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isHitOnTarget(e)) {
            return;
        }
        this.dispatch((Enum)MouseEventSpec.MOUSE_ENTERED, this.translate(e));
    }

    @Override
    public void mouseExited(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isHitOnTarget(e)) {
            return;
        }
        this.dispatch((Enum)MouseEventSpec.MOUSE_LEFT, this.translate(e));
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.dispatch((Enum)MouseEventSpec.MOUSE_DRAGGED, this.translate(e));
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isHitOnTarget(e)) {
            return;
        }
        this.dispatch((Enum)MouseEventSpec.MOUSE_MOVED, this.translate(e));
    }

    private final boolean isHitOnTarget(MouseEvent event) {
        return this.myTargetBounds.contains(new Vector(event.getX(), event.getY()));
    }

    private final jetbrains.datalore.base.event.MouseEvent translate(MouseEvent event) {
        return AwtEventUtil.INSTANCE.translate(event, this.myTargetBounds.getOrigin());
    }
}

