/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.colormap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.common.colormap.C;
import jetbrains.datalore.plot.common.colormap.CmCividis;
import jetbrains.datalore.plot.common.colormap.CmInferno;
import jetbrains.datalore.plot.common.colormap.CmMagma;
import jetbrains.datalore.plot.common.colormap.CmPlasma;
import jetbrains.datalore.plot.common.colormap.CmTurbo;
import jetbrains.datalore.plot.common.colormap.CmTwilight;
import jetbrains.datalore.plot.common.colormap.CmViridis;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0002J5\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J5\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/common/colormap/ColorMaps;", "", "()V", "VIRIDIS", "", "colorData", "", "Ljetbrains/datalore/plot/common/colormap/C;", "cmName", "getColors", "Ljetbrains/datalore/base/values/Color;", "alpha", "", "hueRange", "Ljetbrains/datalore/base/interval/DoubleSpan;", "n", "", "(Ljava/lang/String;DLjetbrains/datalore/base/interval/DoubleSpan;Ljava/lang/Integer;)Ljava/util/List;", "resample", "colors", "(Ljava/util/List;Ljetbrains/datalore/base/interval/DoubleSpan;Ljava/lang/Integer;)Ljava/util/List;", "plot-common-portable"})
public final class ColorMaps {
    @NotNull
    public static final ColorMaps INSTANCE = new ColorMaps();
    @NotNull
    public static final String VIRIDIS = "viridis";

    private ColorMaps() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Color> getColors(@NotNull String cmName, double alpha, @NotNull DoubleSpan hueRange, @Nullable Integer n) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)cmName, (String)"cmName");
        Intrinsics.checkNotNullParameter((Object)hueRange, (String)"hueRange");
        List<C> colors = this.colorData(cmName);
        List<C> colorsN = this.resample(colors, hueRange, n);
        Iterable $this$map$iv = colorsN;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            C c = (C)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Color(MathKt.roundToInt((double)(it.getR() * (double)255)), MathKt.roundToInt((double)(it.getG() * (double)255)), MathKt.roundToInt((double)(it.getB() * (double)255)), MathKt.roundToInt((double)(alpha * (double)255))));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getColors$default(ColorMaps colorMaps, String string, double d, DoubleSpan doubleSpan, Integer n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        return colorMaps.getColors(string, d, doubleSpan, n);
    }

    private final List<C> colorData(String cmName) {
        List<C> list2;
        String string = cmName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        switch (((Object)StringsKt.trim((CharSequence)string)).toString()) {
            case "a": 
            case "magma": {
                list2 = CmMagma.INSTANCE.getColors$plot_common_portable();
                break;
            }
            case "b": 
            case "inferno": {
                list2 = CmInferno.INSTANCE.getColors$plot_common_portable();
                break;
            }
            case "c": 
            case "plasma": {
                list2 = CmPlasma.INSTANCE.getColors$plot_common_portable();
                break;
            }
            case "d": 
            case "viridis": {
                list2 = CmViridis.INSTANCE.getColors$plot_common_portable();
                break;
            }
            case "cividis": 
            case "e": {
                list2 = CmCividis.INSTANCE.getColors$plot_common_portable();
                break;
            }
            case "turbo": {
                list2 = CmTurbo.INSTANCE.getColors$plot_common_portable();
                break;
            }
            case "twilight": {
                list2 = CmTwilight.INSTANCE.getColors$plot_common_portable();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown colormap \"" + cmName + "\". Use: \"magma\" (or \"A\"), \"inferno\" (or \"B\"), \"plasma\" (or \"C\"), \"viridis\" (or \"D\"), \"cividis\" (or \"E\"), \"turbo\" or \"twilight\".");
            }
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<C> resample(List<C> colors, DoubleSpan hueRange, Integer n) {
        List list2;
        int maxIndex = colors.size() - 1;
        int fromIndex = Math.max(0, Math.min(maxIndex, MathKt.roundToInt((double)Math.floor(hueRange.getLowerEnd() * (double)maxIndex))));
        int toIndex = Math.max(0, Math.min(maxIndex, MathKt.roundToInt((double)Math.ceil(hueRange.getUpperEnd() * (double)maxIndex))));
        if (n == null || n <= 0) {
            list2 = colors.subList(fromIndex, toIndex + 1);
        } else {
            int n2 = 1;
            if (n == n2) {
                int mid = MathKt.roundToInt((double)((double)(toIndex - fromIndex) / 2.0 + (double)fromIndex));
                list2 = CollectionsKt.listOf((Object)colors.get(mid));
            } else {
                int numColors = toIndex - fromIndex + 1;
                double inc = ((double)numColors - 1.0) / (double)(n - 1);
                int n3 = n;
                ArrayList<C> arrayList = new ArrayList<C>(n3);
                int n4 = 0;
                while (n4 < n3) {
                    void i;
                    int n5;
                    int n6 = n5 = n4++;
                    ArrayList<C> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(colors.get(MathKt.roundToInt((double)((double)i * inc)) + fromIndex));
                }
                list2 = arrayList;
            }
        }
        return list2;
    }

    static /* synthetic */ List resample$default(ColorMaps colorMaps, List list2, DoubleSpan doubleSpan, Integer n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = null;
        }
        return colorMaps.resample(list2, doubleSpan, n);
    }
}

