/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.interact;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.registration.CompositeRegistration;
import jetbrains.datalore.base.registration.Disposable;
import jetbrains.datalore.base.registration.Registration;
import jetbrains.datalore.plot.base.PlotContext;
import jetbrains.datalore.plot.base.interact.GeomTargetLocator;
import jetbrains.datalore.plot.builder.event.MouseEventPeer;
import jetbrains.datalore.plot.builder.interact.PlotInteractor;
import jetbrains.datalore.plot.builder.interact.TooltipRenderer;
import jetbrains.datalore.plot.builder.interact.tool.DragFeedback;
import jetbrains.datalore.plot.builder.interact.tool.InteractionContext;
import jetbrains.datalore.plot.builder.interact.tool.InteractionTarget;
import jetbrains.datalore.plot.builder.interact.tool.ToolFeedback;
import jetbrains.datalore.plot.builder.interact.ui.EventsManager;
import jetbrains.datalore.plot.builder.theme.Theme;
import jetbrains.datalore.plot.builder.tooltip.HorizontalAxisTooltipPosition;
import jetbrains.datalore.plot.builder.tooltip.VerticalAxisTooltipPosition;
import jetbrains.datalore.vis.svg.SvgNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u00010B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001f\u001a\u00020 H\u0016JD\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u00172\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0$2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Ljetbrains/datalore/plot/builder/interact/Interactor;", "Ljetbrains/datalore/plot/builder/interact/PlotInteractor;", "decorationLayer", "Ljetbrains/datalore/vis/svg/SvgNode;", "mouseEventPeer", "Ljetbrains/datalore/plot/builder/event/MouseEventPeer;", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "flippedAxis", "", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "plotContext", "Ljetbrains/datalore/plot/base/PlotContext;", "(Ljetbrains/datalore/vis/svg/SvgNode;Ljetbrains/datalore/plot/builder/event/MouseEventPeer;Ljetbrains/datalore/base/geometry/DoubleVector;ZLjetbrains/datalore/plot/builder/theme/Theme;Ljetbrains/datalore/plot/base/PlotContext;)V", "getDecorationLayer", "()Ljetbrains/datalore/vis/svg/SvgNode;", "eventsManager", "Ljetbrains/datalore/plot/builder/interact/ui/EventsManager;", "getEventsManager", "()Ljetbrains/datalore/plot/builder/interact/ui/EventsManager;", "geomBoundsList", "Ljava/util/ArrayList;", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "Lkotlin/collections/ArrayList;", "getPlotSize", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "reg", "Ljetbrains/datalore/base/registration/CompositeRegistration;", "tooltipRenderer", "Ljetbrains/datalore/plot/builder/interact/TooltipRenderer;", "dispose", "", "onTileAdded", "geomBounds", "targetLocators", "", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;", "layerYOrientations", "axisOrigin", "hAxisTooltipPosition", "Ljetbrains/datalore/plot/builder/tooltip/HorizontalAxisTooltipPosition;", "vAxisTooltipPosition", "Ljetbrains/datalore/plot/builder/tooltip/VerticalAxisTooltipPosition;", "startToolFeedback", "Ljetbrains/datalore/base/registration/Registration;", "toolFeedback", "Ljetbrains/datalore/plot/builder/interact/tool/ToolFeedback;", "DragInteractionContext", "plot-builder"})
public final class Interactor
implements PlotInteractor {
    @NotNull
    private final SvgNode decorationLayer;
    @NotNull
    private final DoubleVector plotSize;
    @NotNull
    private final EventsManager eventsManager;
    @NotNull
    private final CompositeRegistration reg;
    @NotNull
    private final TooltipRenderer tooltipRenderer;
    @NotNull
    private final ArrayList<DoubleRectangle> geomBoundsList;

    public Interactor(@NotNull SvgNode decorationLayer, @NotNull MouseEventPeer mouseEventPeer, @NotNull DoubleVector plotSize2, boolean flippedAxis, @NotNull Theme theme, @NotNull PlotContext plotContext) {
        Intrinsics.checkNotNullParameter((Object)decorationLayer, (String)"decorationLayer");
        Intrinsics.checkNotNullParameter((Object)mouseEventPeer, (String)"mouseEventPeer");
        Intrinsics.checkNotNullParameter((Object)plotSize2, (String)"plotSize");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
        this.decorationLayer = decorationLayer;
        this.plotSize = plotSize2;
        this.eventsManager = new EventsManager();
        this.reg = new CompositeRegistration(new Registration[0]);
        this.geomBoundsList = new ArrayList();
        this.reg.add(Registration.Companion.from((Disposable)this.eventsManager));
        this.eventsManager.setEventSource(mouseEventPeer);
        this.tooltipRenderer = new TooltipRenderer(this.decorationLayer, flippedAxis, this.plotSize, theme.horizontalAxis(flippedAxis), theme.verticalAxis(flippedAxis), theme.tooltips(), theme.plot().backgroundFill(), plotContext, mouseEventPeer);
        this.reg.add(Registration.Companion.from((Disposable)this.tooltipRenderer));
    }

    @NotNull
    public final SvgNode getDecorationLayer() {
        return this.decorationLayer;
    }

    @NotNull
    public final DoubleVector getPlotSize() {
        return this.plotSize;
    }

    @NotNull
    public final EventsManager getEventsManager() {
        return this.eventsManager;
    }

    @Override
    public void onTileAdded(@NotNull DoubleRectangle geomBounds, @NotNull List<? extends GeomTargetLocator> targetLocators, @NotNull List<Boolean> layerYOrientations, @NotNull DoubleVector axisOrigin, @NotNull HorizontalAxisTooltipPosition hAxisTooltipPosition, @NotNull VerticalAxisTooltipPosition vAxisTooltipPosition) {
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        Intrinsics.checkNotNullParameter(targetLocators, (String)"targetLocators");
        Intrinsics.checkNotNullParameter(layerYOrientations, (String)"layerYOrientations");
        Intrinsics.checkNotNullParameter((Object)axisOrigin, (String)"axisOrigin");
        Intrinsics.checkNotNullParameter((Object)((Object)hAxisTooltipPosition), (String)"hAxisTooltipPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)vAxisTooltipPosition), (String)"vAxisTooltipPosition");
        this.tooltipRenderer.addTileInfo(geomBounds, targetLocators, layerYOrientations, axisOrigin, hAxisTooltipPosition, vAxisTooltipPosition);
        this.geomBoundsList.add(geomBounds);
    }

    @Override
    @NotNull
    public Registration startToolFeedback(@NotNull ToolFeedback toolFeedback) {
        Intrinsics.checkNotNullParameter((Object)toolFeedback, (String)"toolFeedback");
        if (!(toolFeedback instanceof DragFeedback)) {
            throw new IllegalArgumentException("Unknown tool feedback type: " + Reflection.getOrCreateKotlinClass(toolFeedback.getClass()).getSimpleName());
        }
        Disposable disposable = ((DragFeedback)toolFeedback).start(new DragInteractionContext(this.decorationLayer, this.eventsManager, (List<DoubleRectangle>)this.geomBoundsList));
        return Registration.Companion.from(disposable);
    }

    @Override
    public void dispose() {
        this.reg.dispose();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/interact/Interactor$DragInteractionContext;", "Ljetbrains/datalore/plot/builder/interact/tool/InteractionContext;", "decorationsLayer", "Ljetbrains/datalore/vis/svg/SvgNode;", "eventsManager", "Ljetbrains/datalore/plot/builder/interact/ui/EventsManager;", "geomBoundsList", "", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "(Ljetbrains/datalore/vis/svg/SvgNode;Ljetbrains/datalore/plot/builder/interact/ui/EventsManager;Ljava/util/List;)V", "getDecorationsLayer", "()Ljetbrains/datalore/vis/svg/SvgNode;", "getEventsManager", "()Ljetbrains/datalore/plot/builder/interact/ui/EventsManager;", "getGeomBoundsList", "()Ljava/util/List;", "findTarget", "Ljetbrains/datalore/plot/builder/interact/tool/InteractionTarget;", "plotCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "plot-builder"})
    private static final class DragInteractionContext
    implements InteractionContext {
        @NotNull
        private final SvgNode decorationsLayer;
        @NotNull
        private final EventsManager eventsManager;
        @NotNull
        private final List<DoubleRectangle> geomBoundsList;

        public DragInteractionContext(@NotNull SvgNode decorationsLayer, @NotNull EventsManager eventsManager, @NotNull List<DoubleRectangle> geomBoundsList) {
            Intrinsics.checkNotNullParameter((Object)decorationsLayer, (String)"decorationsLayer");
            Intrinsics.checkNotNullParameter((Object)eventsManager, (String)"eventsManager");
            Intrinsics.checkNotNullParameter(geomBoundsList, (String)"geomBoundsList");
            this.decorationsLayer = decorationsLayer;
            this.eventsManager = eventsManager;
            this.geomBoundsList = geomBoundsList;
        }

        @Override
        @NotNull
        public SvgNode getDecorationsLayer() {
            return this.decorationsLayer;
        }

        @Override
        @NotNull
        public EventsManager getEventsManager() {
            return this.eventsManager;
        }

        @NotNull
        public final List<DoubleRectangle> getGeomBoundsList() {
            return this.geomBoundsList;
        }

        @Override
        @Nullable
        public InteractionTarget findTarget(@NotNull DoubleVector plotCoord) {
            InteractionTarget interactionTarget;
            DoubleRectangle geomBounds;
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)plotCoord, (String)"plotCoord");
                Iterable iterable = this.geomBoundsList;
                for (Object t : iterable) {
                    DoubleRectangle it = (DoubleRectangle)t;
                    boolean bl = false;
                    if (!it.contains(plotCoord)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            DoubleRectangle doubleRectangle = geomBounds = (DoubleRectangle)v0;
            if (doubleRectangle != null) {
                DoubleRectangle it = doubleRectangle;
                boolean bl = false;
                interactionTarget = new InteractionTarget(geomBounds){
                    final /* synthetic */ DoubleRectangle $geomBounds;
                    {
                        this.$geomBounds = $geomBounds;
                    }

                    @NotNull
                    public DoubleRectangle getGeomBounds() {
                        return this.$geomBounds;
                    }

                    public void zoom(@NotNull DoubleRectangle geomBounds) {
                        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
                        System.out.println((Object)("Target zoom: " + geomBounds));
                    }
                };
            } else {
                interactionTarget = null;
            }
            return interactionTarget;
        }
    }
}

