/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.SomeFig;
import jetbrains.datalore.plot.base.Geom;
import jetbrains.datalore.plot.base.geom.LiveMapGeom;
import jetbrains.datalore.plot.base.geom.LiveMapProvider;
import jetbrains.datalore.plot.base.interact.GeomTargetLocator;
import jetbrains.datalore.plot.base.interact.NullGeomTargetCollector;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.base.render.svg.Text;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.builder.FrameOfReference;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.MarginSide;
import jetbrains.datalore.plot.builder.MarginalLayerUtil;
import jetbrains.datalore.plot.builder.interact.loc.LayerTargetCollectorWithLocator;
import jetbrains.datalore.plot.builder.layout.FacetedPlotLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.theme.FacetsTheme;
import jetbrains.datalore.plot.builder.theme.Theme;
import jetbrains.datalore.vis.svg.SvgRectElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*BU\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020$2\u0006\u0010\n\u001a\u00020&H\u0002J\b\u0010)\u001a\u00020\"H\u0014R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00140\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0019R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ljetbrains/datalore/plot/builder/PlotTile;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "coreLayers", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "marginalLayers", "tilesOrigin", "Ljetbrains/datalore/base/geometry/DoubleVector;", "tileLayoutInfo", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "frameOfReference", "Ljetbrains/datalore/plot/builder/FrameOfReference;", "marginalFrameByMargin", "", "Ljetbrains/datalore/plot/builder/MarginSide;", "(Ljava/util/List;Ljava/util/List;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;Ljetbrains/datalore/plot/builder/theme/Theme;Ljetbrains/datalore/plot/builder/FrameOfReference;Ljava/util/Map;)V", "_targetLocators", "Ljava/util/ArrayList;", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator;", "Lkotlin/collections/ArrayList;", "layerYOrientations", "", "getLayerYOrientations", "()Ljava/util/List;", "<set-?>", "Ljetbrains/datalore/base/values/SomeFig;", "liveMapFigure", "getLiveMapFigure", "()Ljetbrains/datalore/base/values/SomeFig;", "targetLocators", "getTargetLocators", "addFacetLabBackground", "", "labelBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "facetTheme", "Ljetbrains/datalore/plot/builder/theme/FacetsTheme;", "addFacetLabels", "geomBounds", "buildComponent", "Companion", "plot-builder-portable"})
public final class PlotTile
extends SvgComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<GeomLayer> coreLayers;
    @NotNull
    private final List<GeomLayer> marginalLayers;
    @NotNull
    private final DoubleVector tilesOrigin;
    @NotNull
    private final TileLayoutInfo tileLayoutInfo;
    @NotNull
    private final Theme theme;
    @NotNull
    private final FrameOfReference frameOfReference;
    @NotNull
    private final Map<MarginSide, FrameOfReference> marginalFrameByMargin;
    @NotNull
    private final ArrayList<GeomTargetLocator> _targetLocators;
    @Nullable
    private SomeFig liveMapFigure;
    @NotNull
    private final List<Boolean> layerYOrientations;

    /*
     * WARNING - void declaration
     */
    public PlotTile(@NotNull List<? extends GeomLayer> coreLayers, @NotNull List<? extends GeomLayer> marginalLayers, @NotNull DoubleVector tilesOrigin, @NotNull TileLayoutInfo tileLayoutInfo, @NotNull Theme theme, @NotNull FrameOfReference frameOfReference, @NotNull Map<MarginSide, ? extends FrameOfReference> marginalFrameByMargin) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(coreLayers, (String)"coreLayers");
        Intrinsics.checkNotNullParameter(marginalLayers, (String)"marginalLayers");
        Intrinsics.checkNotNullParameter((Object)tilesOrigin, (String)"tilesOrigin");
        Intrinsics.checkNotNullParameter((Object)tileLayoutInfo, (String)"tileLayoutInfo");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)frameOfReference, (String)"frameOfReference");
        Intrinsics.checkNotNullParameter(marginalFrameByMargin, (String)"marginalFrameByMargin");
        this.coreLayers = coreLayers;
        this.marginalLayers = marginalLayers;
        this.tilesOrigin = tilesOrigin;
        this.tileLayoutInfo = tileLayoutInfo;
        this.theme = theme;
        this.frameOfReference = frameOfReference;
        this.marginalFrameByMargin = marginalFrameByMargin;
        this._targetLocators = new ArrayList();
        Iterable iterable = this.coreLayers;
        PlotTile plotTile = this;
        boolean $i$f$map = false;
        void var10_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            GeomLayer geomLayer = (GeomLayer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.isYOrientation());
        }
        plotTile.layerYOrientations = (List)destination$iv$iv;
        this.moveTo(this.tileLayoutInfo.getAbsoluteBounds(this.tilesOrigin).getOrigin());
    }

    @Nullable
    public final SomeFig getLiveMapFigure() {
        return this.liveMapFigure;
    }

    @NotNull
    public final List<GeomTargetLocator> getTargetLocators() {
        return this._targetLocators;
    }

    @NotNull
    public final List<Boolean> getLayerYOrientations() {
        return this.layerYOrientations;
    }

    @Override
    protected void buildComponent() {
        Object v0;
        block6: {
            DoubleRectangle geomOuterBounds = this.tileLayoutInfo.getGeomOuterBounds();
            this.addFacetLabels(geomOuterBounds, this.theme.facets());
            Iterable $this$firstOrNull$iv = this.coreLayers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                GeomLayer p0 = (GeomLayer)element$iv;
                boolean bl = false;
                if (!p0.isLiveMap()) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        GeomLayer liveMapGeomLayer = v0;
        if (liveMapGeomLayer != null) {
            DoubleRectangle realBounds = this.tileLayoutInfo.getAbsoluteOuterGeomBounds(this.tilesOrigin);
            LiveMapProvider.LiveMapData liveMapData = PlotTile.Companion.createCanvasFigure(liveMapGeomLayer, realBounds);
            this.liveMapFigure = liveMapData.getCanvasFigure();
            this._targetLocators.addAll((Collection<GeomTargetLocator>)liveMapData.getTargetLocators());
        } else {
            this.frameOfReference.drawBeforeGeomLayer(this);
            for (GeomLayer layer : this.coreLayers) {
                LayerTargetCollectorWithLocator layerTargetCollectorWithLocator = new LayerTargetCollectorWithLocator(layer.getGeomKind(), layer.getLocatorLookupSpec(), layer.createContextualMapping());
                this._targetLocators.add(layerTargetCollectorWithLocator);
                SvgComponent layerComponent = this.frameOfReference.buildGeomComponent(layer, layerTargetCollectorWithLocator);
                this.add(layerComponent);
            }
            Map<MarginSide, List<GeomLayer>> marginalLayersByMargin = MarginalLayerUtil.INSTANCE.marginalLayersByMargin(this.marginalLayers);
            for (Map.Entry<MarginSide, List<GeomLayer>> entry : marginalLayersByMargin.entrySet()) {
                MarginSide margin = entry.getKey();
                List<GeomLayer> layers = entry.getValue();
                FrameOfReference marginFrame = (FrameOfReference)MapsKt.getValue(this.marginalFrameByMargin, (Object)((Object)margin));
                for (GeomLayer layer : layers) {
                    SvgComponent marginComponent = marginFrame.buildGeomComponent(layer, new NullGeomTargetCollector());
                    this.add(marginComponent);
                }
            }
            this.frameOfReference.drawAfterGeomLayer(this);
        }
    }

    private final void addFacetLabels(DoubleRectangle geomBounds, FacetsTheme theme) {
        DoubleRectangle labelBounds;
        List<String> xLabels = this.tileLayoutInfo.getFacetXLabels();
        if (!((Collection)xLabels).isEmpty()) {
            DoubleVector labelSize = FacetedPlotLayout.Companion.facetColLabelSize(geomBounds.getWidth());
            DoubleVector labelOrig = new DoubleVector(geomBounds.getLeft() + 0.0, geomBounds.getTop() - FacetedPlotLayout.Companion.facetColHeadHeight(xLabels.size()) + (double)6);
            labelBounds = new DoubleRectangle(labelOrig, labelSize);
            for (String xLabel : xLabels) {
                this.addFacetLabBackground(labelBounds, theme);
                double x2 = labelBounds.getCenter().getX();
                double y2 = labelBounds.getCenter().getY();
                TextLabel lab = new TextLabel(xLabel);
                lab.addClassName("facet-strip-text-x");
                lab.moveTo(x2, y2);
                lab.setHorizontalAnchor(Text.HorizontalAnchor.MIDDLE);
                lab.setVerticalAnchor(Text.VerticalAnchor.CENTER);
                this.add(lab);
                labelBounds = labelBounds.add(new DoubleVector(0.0, labelSize.getY()));
            }
        }
        if (this.tileLayoutInfo.getFacetYLabel() != null) {
            int hPad = 6;
            int vPad = 0;
            labelBounds = new DoubleRectangle(geomBounds.getRight() + (double)hPad, geomBounds.getTop() - (double)vPad, 30.0 - (double)(hPad * 2), geomBounds.getHeight() - (double)(vPad * 2));
            this.addFacetLabBackground(labelBounds, theme);
            double x3 = labelBounds.getCenter().getX();
            double y3 = labelBounds.getCenter().getY();
            TextLabel lab = new TextLabel(this.tileLayoutInfo.getFacetYLabel());
            lab.addClassName("facet-strip-text-y");
            lab.moveTo(x3, y3);
            lab.setHorizontalAnchor(Text.HorizontalAnchor.MIDDLE);
            lab.setVerticalAnchor(Text.VerticalAnchor.CENTER);
            lab.rotate(90.0);
            this.add(lab);
        }
    }

    private final void addFacetLabBackground(DoubleRectangle labelBounds, FacetsTheme facetTheme) {
        if (facetTheme.showStripBackground()) {
            SvgRectElement svgRectElement;
            SvgRectElement $this$addFacetLabBackground_u24lambda_u241 = svgRectElement = new SvgRectElement(labelBounds);
            boolean bl = false;
            $this$addFacetLabBackground_u24lambda_u241.strokeWidth().set(facetTheme.stripStrokeWidth());
            $this$addFacetLabBackground_u24lambda_u241.fillColor().set(facetTheme.stripFill());
            $this$addFacetLabBackground_u24lambda_u241.strokeColor().set(facetTheme.stripColor());
            SvgRectElement rect2 = svgRectElement;
            this.add(rect2);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/builder/PlotTile$Companion;", "", "()V", "createCanvasFigure", "Ljetbrains/datalore/plot/base/geom/LiveMapProvider$LiveMapData;", "layer", "Ljetbrains/datalore/plot/builder/GeomLayer;", "bounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final LiveMapProvider.LiveMapData createCanvasFigure(GeomLayer layer, DoubleRectangle bounds) {
            Geom geom = layer.getGeom();
            Intrinsics.checkNotNull((Object)geom, (String)"null cannot be cast to non-null type jetbrains.datalore.plot.base.geom.LiveMapGeom");
            return ((LiveMapGeom)geom).createCanvasFigure(bounds);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

