/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import jetbrains.datalore.plot.base.stat.math3.AllowedSolution;
import jetbrains.datalore.plot.base.stat.math3.BracketedUnivariateSolver;
import jetbrains.datalore.plot.base.stat.math3.BrentSolver;
import jetbrains.datalore.plot.base.stat.math3.UnivariateFunction;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007JD\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bJ\u001e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bJ\u0016\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bJ\u001e\u0010\"\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bJ&\u0010\"\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bJ\u001e\u0010&\u001a\u00020'2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bJ\u0016\u0010(\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bJ\u001e\u0010)\u001a\u00020'2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\b\u00a8\u0006*"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/UnivariateSolverUtils;", "", "()V", "bracket", "", "function", "Ljetbrains/datalore/plot/base/stat/math3/UnivariateFunction;", "initial", "", "lowerBound", "upperBound", "maximumIterations", "", "forceSide", "maxEval", "f", "bracketing", "Ljetbrains/datalore/plot/base/stat/math3/BracketedUnivariateSolver;", "baseRoot", "min", "max", "allowedSolution", "Ljetbrains/datalore/plot/base/stat/math3/AllowedSolution;", "isBracketing", "", "lower", "upper", "isSequence", "start", "mid", "end", "midpoint", "a", "b", "solve", "x0", "x1", "absoluteAccuracy", "verifyBracketing", "", "verifyInterval", "verifySequence", "plot-base-portable"})
public final class UnivariateSolverUtils {
    @NotNull
    public static final UnivariateSolverUtils INSTANCE = new UnivariateSolverUtils();

    private UnivariateSolverUtils() {
    }

    public final double solve(@NotNull UnivariateFunction function, double x0, double x1) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        BrentSolver solver = new BrentSolver(0.0, 1, null);
        return solver.solve(Integer.MAX_VALUE, function, x0, x1);
    }

    public final double solve(@NotNull UnivariateFunction function, double x0, double x1, double absoluteAccuracy) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        BrentSolver solver = new BrentSolver(absoluteAccuracy);
        return solver.solve(Integer.MAX_VALUE, function, x0, x1);
    }

    public final double forceSide(int maxEval, @NotNull UnivariateFunction f, @NotNull BracketedUnivariateSolver<UnivariateFunction> bracketing, double baseRoot, double min, double max, @NotNull AllowedSolution allowedSolution) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        Intrinsics.checkNotNullParameter(bracketing, (String)"bracketing");
        Intrinsics.checkNotNullParameter((Object)((Object)allowedSolution), (String)"allowedSolution");
        if (allowedSolution == AllowedSolution.ANY_SIDE) {
            return baseRoot;
        }
        double step = Math.max(bracketing.getAbsoluteAccuracy(), Math.abs(baseRoot * bracketing.getRelativeAccuracy()));
        double xLo = Math.max(min, baseRoot - step);
        double fLo = f.value(xLo);
        double xHi = Math.min(max, baseRoot + step);
        double fHi = f.value(xHi);
        int remainingEval = maxEval - 2;
        while (remainingEval > 0) {
            if (fLo >= 0.0 && fHi <= 0.0 || fLo <= 0.0 && fHi >= 0.0) {
                return bracketing.solve(remainingEval, f, xLo, xHi, baseRoot, allowedSolution);
            }
            boolean changeLo = false;
            boolean changeHi = false;
            if (fLo < fHi) {
                if (fLo >= 0.0) {
                    changeLo = true;
                } else {
                    changeHi = true;
                }
            } else if (fLo > fHi) {
                if (fLo <= 0.0) {
                    changeLo = true;
                } else {
                    changeHi = true;
                }
            } else {
                changeLo = true;
                changeHi = true;
            }
            if (changeLo) {
                xLo = Math.max(min, xLo - step);
                fLo = f.value(xLo);
                --remainingEval;
            }
            if (!changeHi) continue;
            xHi = Math.min(max, xHi + step);
            fHi = f.value(xHi);
            --remainingEval;
        }
        throw new IllegalStateException("NoBracketing".toString());
    }

    @JvmOverloads
    @NotNull
    public final double[] bracket(@NotNull UnivariateFunction function, double initial, double lowerBound, double upperBound, int maximumIterations) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (maximumIterations <= 0) {
            throw new IllegalStateException("NotStrictlyPositive".toString());
        }
        this.verifySequence(lowerBound, initial, upperBound);
        double a2 = initial;
        double b2 = initial;
        double fa = 0.0;
        double fb = 0.0;
        int numIterations = 0;
        do {
            a2 = Math.max(a2 - 1.0, lowerBound);
            b2 = Math.min(b2 + 1.0, upperBound);
            fa = function.value(a2);
            fb = function.value(b2);
        } while (fa * fb > 0.0 && ++numIterations < maximumIterations && (a2 > lowerBound || b2 < upperBound));
        if (fa * fb > 0.0) {
            throw new IllegalStateException("NoBracketing".toString());
        }
        double[] dArray = new double[]{a2, b2};
        return dArray;
    }

    public static /* synthetic */ double[] bracket$default(UnivariateSolverUtils univariateSolverUtils, UnivariateFunction univariateFunction, double d, double d2, double d3, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = Integer.MAX_VALUE;
        }
        return univariateSolverUtils.bracket(univariateFunction, d, d2, d3, n);
    }

    public final double midpoint(double a2, double b2) {
        return (a2 + b2) * 0.5;
    }

    public final boolean isBracketing(@NotNull UnivariateFunction function, double lower, double upper) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        double fLo = function.value(lower);
        double fHi = function.value(upper);
        return fLo >= 0.0 && fHi <= 0.0 || fLo <= 0.0 && fHi >= 0.0;
    }

    public final boolean isSequence(double start2, double mid, double end) {
        return start2 < mid && mid < end;
    }

    public final void verifyInterval(double lower, double upper) {
        if (lower >= upper) {
            throw new IllegalStateException("NumberIsTooLarge".toString());
        }
    }

    public final void verifySequence(double lower, double initial, double upper) {
        this.verifyInterval(lower, initial);
        this.verifyInterval(initial, upper);
    }

    public final void verifyBracketing(@NotNull UnivariateFunction function, double lower, double upper) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.verifyInterval(lower, upper);
        if (!this.isBracketing(function, lower, upper)) {
            throw new IllegalStateException("NoBracketing".toString());
        }
    }

    @JvmOverloads
    @NotNull
    public final double[] bracket(@NotNull UnivariateFunction function, double initial, double lowerBound, double upperBound) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return UnivariateSolverUtils.bracket$default(this, function, initial, lowerBound, upperBound, 0, 16, null);
    }
}

