/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.base.gcommon.collect.Ordering;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.Transform;
import jetbrains.datalore.plot.base.data.Dummies;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.scale.ScaleUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004J*\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\b2\b\b\u0002\u0010\u0016\u001a\u00020\bH\u0007J\u0016\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\bJ\u0016\u0010\u0019\u001a\u00020\u00042\u000e\u0010\u001a\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001bJ\u000e\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0004J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\bJ\u0016\u0010 \u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\bJ\u001c\u0010!\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0&J\u001e\u0010'\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0\u001b2\u0006\u0010\u001d\u001a\u00020\u0004J\u0012\u0010(\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010J\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\u001b2\u0006\u0010\u001d\u001a\u00020\u0004\u00a8\u0006)"}, d2={"Ljetbrains/datalore/plot/base/data/DataFrameUtil;", "", "()V", "addDateTimeVariables", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "dateTimeVars", "", "", "appendReplace", "df0", "df1", "applyTransform", "variable", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "aes", "Ljetbrains/datalore/plot/base/Aes;", "transform", "Ljetbrains/datalore/plot/base/Transform;", "transformVar", "createVariable", "name", "label", "findVariableOrFail", "varName", "fromMap", "map", "", "getSummaryText", "df", "hasVariable", "", "isNumeric", "removeAllExcept", "keepNames", "sortedCopy", "", "variables", "", "toMap", "transformVarFor", "plot-base-portable"})
public final class DataFrameUtil {
    @NotNull
    public static final DataFrameUtil INSTANCE = new DataFrameUtil();

    private DataFrameUtil() {
    }

    @NotNull
    public final DataFrame.Variable transformVarFor(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        return TransformVar.INSTANCE.forAes(aes);
    }

    @NotNull
    public final DataFrame applyTransform(@NotNull DataFrame data, @NotNull DataFrame.Variable variable, @NotNull Aes<?> aes, @NotNull Transform transform2) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        DataFrame.Variable transformVar = this.transformVarFor(aes);
        return this.applyTransform(data, variable, transformVar, transform2);
    }

    @NotNull
    public final DataFrame applyTransform(@NotNull DataFrame data, @NotNull DataFrame.Variable variable, @NotNull DataFrame.Variable transformVar, @NotNull Transform transform2) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)transformVar, (String)"transformVar");
        Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
        List<Double> transformed = ScaleUtil.INSTANCE.applyTransform(data.get(variable), transform2);
        return data.builder().putNumeric(transformVar, transformed).build();
    }

    public final boolean hasVariable(@NotNull DataFrame data, @NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        for (DataFrame.Variable v : data.variables()) {
            if (!Intrinsics.areEqual((Object)varName, (Object)v.getName())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final DataFrame.Variable findVariableOrFail(@NotNull DataFrame data, @NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        for (DataFrame.Variable variable : data.variables()) {
            if (!Intrinsics.areEqual((Object)varName, (Object)variable.getName())) continue;
            return variable;
        }
        throw new IllegalArgumentException(data.undefinedVariableErrorMessage(varName));
    }

    public final boolean isNumeric(@NotNull DataFrame data, @NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        return data.isNumeric(this.findVariableOrFail(data, varName));
    }

    @NotNull
    public final List<DataFrame.Variable> sortedCopy(@NotNull Iterable<DataFrame.Variable> variables) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        Ordering ordering = Ordering.Companion.from(DataFrameUtil::sortedCopy$lambda$0);
        return ordering.sortedCopy(variables);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, DataFrame.Variable> variables(@NotNull DataFrame df) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        Iterable $this$associateBy$iv = df.variables();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            DataFrame.Variable variable = (DataFrame.Variable)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(p0.getName(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final DataFrame appendReplace(@NotNull DataFrame df0, @NotNull DataFrame df1) {
        DataFrame.Variable it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)df0, (String)"df0");
        Intrinsics.checkNotNullParameter((Object)df1, (String)"df1");
        Iterable iterable = df0.variables();
        DataFrame.Builder builder = new DataFrame.Builder();
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DataFrame.Variable)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !INSTANCE.variables(df1).containsKey(it.getName());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = df0.variables();
        builder = DataFrameUtil.appendReplace$put(builder, (List)destination$iv$iv, df0);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DataFrame.Variable)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.variables(df1).containsKey(it.getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = df1.variables();
        builder = DataFrameUtil.appendReplace$put(builder, (List)destination$iv$iv, df1);
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DataFrame.Variable)element$iv$iv;
            boolean bl = false;
            boolean bl3 = !INSTANCE.variables(df0).containsKey(it.getName());
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return DataFrameUtil.appendReplace$put(builder, (List)destination$iv$iv, df1).build();
    }

    @NotNull
    public final Map<String, List<?>> toMap(@NotNull DataFrame df) {
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        HashMap result2 = new HashMap();
        Set<DataFrame.Variable> variables = df.variables();
        for (DataFrame.Variable variable : variables) {
            ((Map)result2).put(variable.getName(), df.get(variable));
        }
        return result2;
    }

    @NotNull
    public final DataFrame fromMap(@NotNull Map<?, ?> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        DataFrame.Builder frameBuilder = new DataFrame.Builder();
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof String)) {
                boolean $i$a$-require-DataFrameUtil$fromMap$32 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Map to data-frame: key expected a String but was ");
                Object obj = key;
                Intrinsics.checkNotNull(obj);
                String $i$a$-require-DataFrameUtil$fromMap$32 = stringBuilder.append(Reflection.getOrCreateKotlinClass(obj.getClass()).getSimpleName()).append(" : ").append(key).toString();
                throw new IllegalArgumentException($i$a$-require-DataFrameUtil$fromMap$32.toString());
            }
            if (!(value instanceof List)) {
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("Map to data-frame: value expected a List but was ");
                Object obj = value;
                Intrinsics.checkNotNull(obj);
                String string = stringBuilder.append(Reflection.getOrCreateKotlinClass(obj.getClass()).getSimpleName()).append(" : ").append(value).toString();
                throw new IllegalArgumentException(string.toString());
            }
            frameBuilder.put(DataFrameUtil.createVariable$default(this, (String)key, null, 2, null), (List)value);
        }
        return frameBuilder.build();
    }

    @JvmOverloads
    @NotNull
    public final DataFrame.Variable createVariable(@NotNull String name, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return TransformVar.INSTANCE.isTransformVar(name) ? TransformVar.INSTANCE.get(name) : (Stats.INSTANCE.isStatVar(name) ? Stats.INSTANCE.statVar(name) : (Dummies.INSTANCE.isDummyVar(name) ? Dummies.INSTANCE.newDummy(name) : new DataFrame.Variable(name, DataFrame.Variable.Source.ORIGIN, label)));
    }

    public static /* synthetic */ DataFrame.Variable createVariable$default(DataFrameUtil dataFrameUtil, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = string;
        }
        return dataFrameUtil.createVariable(string, string2);
    }

    @NotNull
    public final String getSummaryText(@NotNull DataFrame df) {
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        StringBuilder sb = new StringBuilder();
        for (DataFrame.Variable variable : df.variables()) {
            sb.append(variable.toSummaryString()).append(" numeric: " + df.isNumeric(variable)).append(" size: " + df.get(variable).size()).append('\n');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final DataFrame removeAllExcept(@NotNull DataFrame df, @NotNull Set<String> keepNames) {
        Intrinsics.checkNotNullParameter((Object)df, (String)"df");
        Intrinsics.checkNotNullParameter(keepNames, (String)"keepNames");
        DataFrame.Builder b2 = df.builder();
        for (DataFrame.Variable variable : df.variables()) {
            if (keepNames.contains(variable.getName())) continue;
            b2.remove(variable);
        }
        return b2.build();
    }

    @NotNull
    public final DataFrame addDateTimeVariables(@NotNull DataFrame data, @NotNull Set<String> dateTimeVars) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(dateTimeVars, (String)"dateTimeVars");
        DataFrame.Builder $this$addDateTimeVariables_u24lambda_u249 = data.builder();
        boolean bl = false;
        Iterable $this$forEach$iv = data.variables();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataFrame.Variable variable = (DataFrame.Variable)element$iv;
            boolean bl2 = false;
            if (!dateTimeVars.contains(variable.getName())) continue;
            $this$addDateTimeVariables_u24lambda_u249.remove(variable);
            $this$addDateTimeVariables_u24lambda_u249.putDateTime(variable, data.get(variable));
        }
        return $this$addDateTimeVariables_u24lambda_u249.build();
    }

    @JvmOverloads
    @NotNull
    public final DataFrame.Variable createVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return DataFrameUtil.createVariable$default(this, name, null, 2, null);
    }

    private static final int sortedCopy$lambda$0(DataFrame.Variable o1, DataFrame.Variable o2) {
        return o1.getName().compareTo(o2.getName());
    }

    private static final DataFrame.Builder appendReplace$put(DataFrame.Builder $this$appendReplace_u24put, Collection<DataFrame.Variable> destVars, DataFrame df) {
        DataFrame.Builder builder;
        DataFrame.Builder $this$appendReplace_u24put_u24lambda_u242 = builder = $this$appendReplace_u24put;
        boolean bl = false;
        Iterable $this$forEach$iv = destVars;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataFrame.Variable destVar = (DataFrame.Variable)element$iv;
            boolean bl2 = false;
            DataFrame.Variable srcVar = INSTANCE.findVariableOrFail(df, destVar.getName());
            boolean bl3 = df.isNumeric(srcVar);
            if (bl3) {
                $this$appendReplace_u24put_u24lambda_u242.putNumeric(destVar, df.getNumeric(srcVar));
                continue;
            }
            if (bl3) continue;
            $this$appendReplace_u24put_u24lambda_u242.putDiscrete(destVar, df.get(srcVar));
        }
        return builder;
    }
}

