/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.openmodel.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.gui.AbstractThreadGroupGui;
import org.apache.jmeter.threads.openmodel.DefaultThreadSchedule;
import org.apache.jmeter.threads.openmodel.OpenModelThreadGroup;
import org.apache.jmeter.threads.openmodel.ThreadSchedule;
import org.apache.jmeter.threads.openmodel.ThreadScheduleStep;
import org.apache.jmeter.threads.openmodel.ThreadScheduleUtils;
import org.apache.jmeter.threads.openmodel.TimeUnitExtensionsKt;
import org.apache.jmeter.threads.openmodel.gui.TargetRateChart;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JFactory;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@API(status=API.Status.EXPERIMENTAL, since="5.5")
@TestElementMetadata(labelResource="openmodelthreadgroup")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0017H\u0002J\b\u0010\u001e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/apache/jmeter/threads/openmodel/gui/OpenModelThreadGroupGui;", "Lorg/apache/jmeter/threads/gui/AbstractThreadGroupGui;", "()V", "explanation", "Ljavax/swing/JLabel;", "randomSeedEditor", "Ljavax/swing/JTextField;", "scheduleStringEditor", "Ljavax/swing/JTextArea;", "kotlin.jvm.PlatformType", "scheduleSummaryFormat", "Ljava/text/MessageFormat;", "targetRateChart", "Lorg/apache/jmeter/threads/openmodel/gui/TargetRateChart;", "clearGui", "", "configure", "tg", "Lorg/apache/jmeter/testelement/TestElement;", "createPanel", "Ljavax/swing/JPanel;", "createTestElement", "evaluate", "", "input", "getLabelResource", "modifyTestElement", "templateButton", "Ljavax/swing/JButton;", "title", "updateExplanation", "ApacheJMeter_core"})
@SourceDebugExtension(value={"SMAP\nOpenModelThreadGroupGui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenModelThreadGroupGui.kt\norg/apache/jmeter/threads/openmodel/gui/OpenModelThreadGroupGui\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1#2:168\n*E\n"})
public final class OpenModelThreadGroupGui
extends AbstractThreadGroupGui {
    @NotNull
    private final JTextField randomSeedEditor = new JTextField();
    private final JTextArea scheduleStringEditor = JFactory.tabMovesFocus((JTextArea)new JTextArea());
    @NotNull
    private final JLabel explanation = new JLabel();
    @NotNull
    private final TargetRateChart targetRateChart = new TargetRateChart();
    @NotNull
    private final MessageFormat scheduleSummaryFormat = new MessageFormat(JMeterUtils.getResString("openmodelthreadgroup_schedule_summary"));

    public OpenModelThreadGroupGui() {
        this.add(this.createPanel());
        this.scheduleStringEditor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(@Nullable DocumentEvent e) {
                this.updateExplanation();
            }

            @Override
            public void removeUpdate(@Nullable DocumentEvent e) {
                this.updateExplanation();
            }

            @Override
            public void changedUpdate(@Nullable DocumentEvent e) {
                this.updateExplanation();
            }
        });
    }

    @Override
    @NotNull
    public String getLabelResource() {
        return "openmodelthreadgroup";
    }

    private final JPanel createPanel() {
        JPanel jPanel;
        JPanel $this$createPanel_u24lambda_u240 = jPanel = new JPanel((LayoutManager)new MigLayout("fillx, wrap1", "[fill, grow]"));
        boolean bl = false;
        $this$createPanel_u24lambda_u240.add((Component)JMeterUtils.labelFor(this.scheduleStringEditor, "openmodelthreadgroup_schedule_string"), "grow 0, split 6");
        $this$createPanel_u24lambda_u240.add((Component)this.templateButton("rate(1/min)"), "grow 0");
        $this$createPanel_u24lambda_u240.add((Component)this.templateButton("random_arrivals(10 min)"), "grow 0");
        $this$createPanel_u24lambda_u240.add((Component)this.templateButton("pause(1 min)"), "grow 0");
        $this$createPanel_u24lambda_u240.add((Component)this.templateButton("/* comment */"), "grow 0");
        $this$createPanel_u24lambda_u240.add(new JPanel());
        $this$createPanel_u24lambda_u240.add(this.scheduleStringEditor);
        $this$createPanel_u24lambda_u240.add((Component)JMeterUtils.labelFor(this.randomSeedEditor, "openmodelthreadgroup_random_seed"), "grow 0, split 3");
        $this$createPanel_u24lambda_u240.add((Component)this.randomSeedEditor, "width 100pt, grow 0");
        $this$createPanel_u24lambda_u240.add(new JPanel());
        $this$createPanel_u24lambda_u240.add(this.explanation);
        $this$createPanel_u24lambda_u240.add((Component)this.targetRateChart, "height 200");
        return jPanel;
    }

    private final JButton templateButton(String title) {
        JButton jButton;
        JButton $this$templateButton_u24lambda_u242 = jButton = new JButton(title);
        boolean bl = false;
        $this$templateButton_u24lambda_u242.setRequestFocusEnabled(false);
        $this$templateButton_u24lambda_u242.addActionListener(arg_0 -> OpenModelThreadGroupGui.templateButton$lambda$2$lambda$1(this, title, arg_0));
        return jButton;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateExplanation() {
        String string;
        JLabel jLabel;
        String string2 = this.scheduleStringEditor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"scheduleStringEditor.text");
        String schedule = this.evaluate(string2);
        JLabel jLabel2 = this.explanation;
        try {
            double d;
            ThreadSchedule threadSchedule = ThreadScheduleUtils.ThreadSchedule(schedule);
            this.targetRateChart.updateSchedule(threadSchedule);
            Duration duration = Duration.ofSeconds(MathKt.roundToLong((double)threadSchedule.getTotalDuration()));
            Iterable iterable = threadSchedule.getSteps();
            JLabel jLabel3 = jLabel2;
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            ThreadScheduleStep it = (ThreadScheduleStep)iterator.next();
            boolean bl = false;
            ThreadScheduleStep.RateStep rateStep = it instanceof ThreadScheduleStep.RateStep ? (ThreadScheduleStep.RateStep)it : null;
            double d2 = d = rateStep != null ? rateStep.getRate() : 0.0;
            while (iterator.hasNext()) {
                ThreadScheduleStep it2 = (ThreadScheduleStep)iterator.next();
                $i$a$-maxOf-OpenModelThreadGroupGui$updateExplanation$maxRate$1 = false;
                ThreadScheduleStep.RateStep rateStep2 = it2 instanceof ThreadScheduleStep.RateStep ? (ThreadScheduleStep.RateStep)it2 : null;
                double d3 = rateStep2 != null ? rateStep2.getRate() : 0.0;
                d = Math.max(d, d3);
            }
            double d4 = d;
            jLabel = jLabel3;
            double maxRate = d4;
            TimeUnit rateUnit = TimeUnitExtensionsKt.rateUnitFor(maxRate);
            double rate = maxRate * TimeUnitExtensionsKt.getAsSeconds(TimeUnitExtensionsKt.rateUnitFor(maxRate));
            String string3 = rateUnit.toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String rateUnitLabel = StringsKt.removeSuffix((String)string3, (CharSequence)"s");
            String string4 = duration.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"duration.toString()");
            String string5 = StringsKt.removePrefix((String)string4, (CharSequence)"PT").toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String readableDuration = string5;
            String[] stringArray = new String[]{readableDuration, rate + " / " + rateUnitLabel};
            String sheduleSummary = this.scheduleSummaryFormat.format(stringArray);
            string = "<html><body>" + sheduleSummary + "</body></html>";
        }
        catch (Exception duration) {
            void expected;
            jLabel = jLabel2;
            string = expected.getMessage();
        }
        jLabel.setText(string);
    }

    private final String evaluate(String input) {
        String string = new CompoundVariable(input).execute();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CompoundVariable(input).execute()");
        return string;
    }

    @Override
    @NotNull
    public TestElement createTestElement() {
        OpenModelThreadGroup openModelThreadGroup;
        OpenModelThreadGroup it = openModelThreadGroup = new OpenModelThreadGroup();
        boolean bl = false;
        this.modifyTestElement(it);
        return openModelThreadGroup;
    }

    @Override
    public void modifyTestElement(@NotNull TestElement tg) {
        Intrinsics.checkNotNullParameter((Object)tg, (String)"tg");
        this.configureTestElement(tg);
        OpenModelThreadGroup cfr_ignored_0 = (OpenModelThreadGroup)tg;
        OpenModelThreadGroup openModelThreadGroup = (OpenModelThreadGroup)tg;
        String string = this.scheduleStringEditor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scheduleStringEditor.text");
        openModelThreadGroup.setScheduleString(string);
        OpenModelThreadGroup openModelThreadGroup2 = (OpenModelThreadGroup)tg;
        String string2 = this.randomSeedEditor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomSeedEditor.text");
        openModelThreadGroup2.setRandomSeedString(string2);
    }

    @Override
    public void configure(@NotNull TestElement tg) {
        Intrinsics.checkNotNullParameter((Object)tg, (String)"tg");
        super.configure(tg);
        OpenModelThreadGroup cfr_ignored_0 = (OpenModelThreadGroup)tg;
        this.scheduleStringEditor.setText(((OpenModelThreadGroup)tg).getScheduleString());
        this.randomSeedEditor.setText(((OpenModelThreadGroup)tg).getRandomSeedString());
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.scheduleStringEditor.setText("");
        this.randomSeedEditor.setText("");
        Object[] objectArray = new ThreadScheduleStep[]{new ThreadScheduleStep.RateStep(0.0), new ThreadScheduleStep.ArrivalsStep(ThreadScheduleStep.ArrivalType.RANDOM, 1.0)};
        this.targetRateChart.updateSchedule(new DefaultThreadSchedule(CollectionsKt.listOf((Object[])objectArray)));
    }

    private static final void templateButton$lambda$2$lambda$1(OpenModelThreadGroupGui this$0, String $title, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$title, (String)"$title");
        JTextArea editor = this$0.scheduleStringEditor;
        String originalText = editor.getText();
        String replacement = $title;
        if (editor.getSelectionStart() > 0 && !CharsKt.isWhitespace((char)originalText.charAt(editor.getSelectionStart() - 1))) {
            replacement = ' ' + replacement;
        }
        if (editor.getSelectionEnd() < originalText.length() && !CharsKt.isWhitespace((char)originalText.charAt(editor.getSelectionEnd()))) {
            replacement = replacement + ' ';
        }
        editor.replaceSelection(replacement);
    }
}

