/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.regression;

import java.util.List;
import jetbrains.datalore.plot.base.stat.math3.LoessInterpolator;
import jetbrains.datalore.plot.base.stat.math3.PolynomialSplineFunction;
import jetbrains.datalore.plot.base.stat.math3.TDistribution;
import jetbrains.datalore.plot.base.stat.regression.EvalResult;
import jetbrains.datalore.plot.base.stat.regression.RegressionEvaluator;
import jetbrains.datalore.plot.base.stat.regression.RegressionUtilKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/base/stat/regression/LocalPolynomialRegression;", "Ljetbrains/datalore/plot/base/stat/regression/RegressionEvaluator;", "xs", "", "", "ys", "confidenceLevel", "bandwidth", "(Ljava/util/List;Ljava/util/List;DD)V", "canCompute", "", "getCanCompute", "()Z", "meanX", "n", "", "polynomial", "Ljetbrains/datalore/plot/base/stat/math3/PolynomialSplineFunction;", "sumXX", "sy", "tcritical", "evalX", "Ljetbrains/datalore/plot/base/stat/regression/EvalResult;", "x", "getPoly", "xVals", "", "yVals", "plot-base-portable"})
public final class LocalPolynomialRegression
extends RegressionEvaluator {
    private final double bandwidth;
    private final boolean canCompute;
    private final int n;
    private final double meanX;
    private final double sumXX;
    private final double sy;
    private final double tcritical;
    private PolynomialSplineFunction polynomial;

    /*
     * WARNING - void declaration
     */
    public LocalPolynomialRegression(@NotNull List<Double> xs, @NotNull List<Double> ys, double confidenceLevel, double bandwidth) {
        double d;
        void $this$_init__u24lambda_u243;
        double d2;
        double d3;
        double d4;
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        super(xs, ys, confidenceLevel);
        this.bandwidth = bandwidth;
        Pair<double[], double[]> pair = RegressionUtilKt.averageByX(xs, ys);
        double[] xVals = (double[])pair.component1();
        double[] yVals = (double[])pair.component2();
        this.n = xVals.length;
        double degreesOfFreedom = (double)this.n - 2.0;
        int bandwidthInPoints = (int)(this.bandwidth * (double)this.n);
        boolean bandwidthInPointsOk = bandwidthInPoints >= 2;
        this.canCompute = this.n >= 3 && degreesOfFreedom > 0.0 && bandwidthInPointsOk;
        this.meanX = ArraysKt.average((double[])xVals);
        double[] dArray = xVals;
        LocalPolynomialRegression localPolynomialRegression = this;
        double d5 = 0.0;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            void it22;
            double d6 = d4 = dArray[i];
            d3 = d5;
            boolean bl = false;
            double d7 = Math.pow((double)(it22 - this.meanX), 2);
            d5 = d3 + d7;
        }
        localPolynomialRegression.sumXX = d3 = d5;
        double meanY = ArraysKt.average((double[])yVals);
        double[] dArray2 = yVals;
        d4 = 0.0;
        int n2 = dArray2.length;
        for (int it22 = 0; it22 < n2; ++it22) {
            void it;
            double bl;
            double d8 = bl = dArray2[it22];
            double d9 = d4;
            boolean bl2 = false;
            d2 = Math.pow((double)(it - meanY), 2);
            d4 = d9 + d2;
        }
        double sumYY = d4;
        Iterable iterable = ArraysKt.zip((double[])xVals, (double[])yVals);
        double it22 = 0.0;
        for (Object t : iterable) {
            Pair pair2 = (Pair)t;
            double d10 = it22;
            boolean bl = false;
            double x = ((Number)pair2.component1()).doubleValue();
            double y = ((Number)pair2.component2()).doubleValue();
            d2 = (x - this.meanX) * (y - meanY);
            it22 = d10 + d2;
        }
        double sumXY = it22;
        LocalPolynomialRegression it22 = this;
        localPolynomialRegression = this;
        boolean bl = false;
        double sse = Math.max(0.0, sumYY - sumXY * sumXY / $this$_init__u24lambda_u243.sumXX);
        d3 = Math.sqrt(sse / (double)($this$_init__u24lambda_u243.n - 2));
        localPolynomialRegression.sy = d3;
        if (this.canCompute) {
            this.polynomial = this.getPoly(xVals, yVals);
        }
        if (this.canCompute) {
            double alpha = 1.0 - confidenceLevel;
            d = new TDistribution(degreesOfFreedom, 0.0, 2, null).inverseCumulativeProbability(1.0 - alpha / 2.0);
        } else {
            d = Double.NaN;
        }
        this.tcritical = d;
    }

    public final boolean getCanCompute() {
        return this.canCompute;
    }

    @Override
    @NotNull
    public EvalResult evalX(double x) {
        LocalPolynomialRegression $this$evalX_u24lambda_u244 = this;
        boolean bl = false;
        double dxSquare = Math.pow(x - $this$evalX_u24lambda_u244.meanX, 2);
        double se = $this$evalX_u24lambda_u244.sy * Math.sqrt(1.0 / (double)$this$evalX_u24lambda_u244.n + dxSquare / $this$evalX_u24lambda_u244.sumXX);
        double halfConfidenceInterval = this.tcritical * se;
        PolynomialSplineFunction polynomialSplineFunction = this.polynomial;
        if (polynomialSplineFunction == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"polynomial");
            polynomialSplineFunction = null;
        }
        Double d = polynomialSplineFunction.value(x);
        Intrinsics.checkNotNull((Object)d);
        double yHat = d;
        return new EvalResult(yHat, yHat - halfConfidenceInterval, yHat + halfConfidenceInterval, se);
    }

    private final PolynomialSplineFunction getPoly(double[] xVals, double[] yVals) {
        return new LoessInterpolator(this.bandwidth, 4, 0.0, 4, null).interpolate(xVals, yVals);
    }
}

