/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import jetbrains.datalore.base.algorithms.AdaptiveResampler;
import jetbrains.datalore.base.collections.UtilsKt;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleSegment;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.observable.collections.list.ObservableList;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.base.values.Colors;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AesScaling;
import jetbrains.datalore.plot.base.aes.AestheticsBuilder;
import jetbrains.datalore.plot.base.aes.AestheticsUtil;
import jetbrains.datalore.plot.base.annotations.Annotations;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.TextGeom;
import jetbrains.datalore.plot.base.geom.WithHeight;
import jetbrains.datalore.plot.base.geom.WithWidth;
import jetbrains.datalore.plot.base.geom.util.DataPointAestheticsDelegate;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.geom.util.TextUtil;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.svg.LinePath;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.vis.TextStyle;
import jetbrains.datalore.vis.svg.SvgCircleElement;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgPathDataBuilder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 E2\u00020\u00012\u00020\u00022\u00020\u0003:\u0003EFGB\u0005\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u00060 R\u00020\u00000\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J\u001c\u0010#\u001a\u00020\u00192\n\u0010$\u001a\u00060 R\u00020\u00002\u0006\u0010%\u001a\u00020&H\u0002J0\u0010'\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010!\u001a\u00020\"H\u0014J\u0014\u0010.\u001a\u00020/2\n\u0010$\u001a\u00060 R\u00020\u0000H\u0002J(\u00100\u001a\f\u0012\b\u0012\u00060 R\u00020\u00000\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u001fH\u0002J \u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u0002022\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000607H\u0002J>\u00108\u001a\u0002092\n\u0010$\u001a\u00060 R\u00020\u00002\u0006\u0010:\u001a\u00020;2\u0018\u0010<\u001a\u0014\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u001d0=2\u0006\u0010?\u001a\u00020\u0006H\u0002J0\u0010@\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u0002022\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u0006072\u0006\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u00020CH\u0016J0\u0010D\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u0002022\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u0006072\u0006\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u00020CH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\b\"\u0004\b\u0017\u0010\n\u00a8\u0006H"}, d2={"Ljetbrains/datalore/plot/base/geom/PieGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "Ljetbrains/datalore/plot/base/geom/WithWidth;", "Ljetbrains/datalore/plot/base/geom/WithHeight;", "()V", "holeSize", "", "getHoleSize", "()D", "setHoleSize", "(D)V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "strokeColor", "Ljetbrains/datalore/base/values/Color;", "getStrokeColor", "()Ljetbrains/datalore/base/values/Color;", "setStrokeColor", "(Ljetbrains/datalore/base/values/Color;)V", "strokeWidth", "getStrokeWidth", "setStrokeWidth", "buildAnnotations", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "pieCenter", "Ljetbrains/datalore/base/geometry/DoubleVector;", "sectors", "", "Ljetbrains/datalore/plot/base/geom/PieGeom$Sector;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "buildHint", "sector", "targetCollector", "Ljetbrains/datalore/plot/base/interact/GeomTargetCollector;", "buildIntern", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "buildSvgSector", "Ljetbrains/datalore/plot/base/render/svg/LinePath;", "computeSectors", "dataPoints", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "dimensionSpan", "Ljetbrains/datalore/base/interval/DoubleSpan;", "p", "coordAes", "Ljetbrains/datalore/plot/base/Aes;", "getAnnotationLabel", "Ljetbrains/datalore/plot/base/geom/PieGeom$Companion$AnnotationLabel;", "annotations", "Ljetbrains/datalore/plot/base/annotations/Annotations;", "textSizeGetter", "Lkotlin/Function2;", "", "offsetForPointer", "heightSpan", "resolution", "isDiscrete", "", "widthSpan", "Companion", "PieLegendKeyElementFactory", "Sector", "plot-base-portable"})
public final class PieGeom
extends GeomBase
implements WithWidth,
WithHeight {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double holeSize;
    private double strokeWidth;
    @NotNull
    private Color strokeColor = Color.Companion.getWHITE();
    public static final boolean HANDLES_GROUPS = false;
    private static final double INTERVAL_BETWEEN_ANNOTATIONS = 4.0;

    public final double getHoleSize() {
        return this.holeSize;
    }

    public final void setHoleSize(double d) {
        this.holeSize = d;
    }

    public final double getStrokeWidth() {
        return this.strokeWidth;
    }

    public final void setStrokeWidth(double d) {
        this.strokeWidth = d;
    }

    @NotNull
    public final Color getStrokeColor() {
        return this.strokeColor;
    }

    public final void setStrokeColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.strokeColor = color;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new PieLegendKeyElementFactory();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        void $this$forEach$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx);
        Iterable<DataPointAesthetics> iterable = GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getSLICE());
        boolean $i$f$groupBy = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DataPointAesthetics p = (DataPointAesthetics)element$iv$iv;
            boolean bl = false;
            Double d = p.x();
            Intrinsics.checkNotNull((Object)d);
            double d2 = d;
            Double d3 = p.y();
            Intrinsics.checkNotNull((Object)d3);
            key$iv$iv = geomHelper.toClient(d2, d3, p);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = UtilsKt.filterNotNullKeys((Map)destination$iv$iv);
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterator $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            DoubleVector pieCenter = (DoubleVector)entry.getKey();
            List dataPoints2 = (List)entry.getValue();
            List<Sector> pieSectors = this.computeSectors(pieCenter, dataPoints2);
            key$iv$iv = pieSectors;
            GeomBase.Companion companion = GeomBase.Companion;
            boolean $i$f$map = false;
            value$iv$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void p0;
                Object item$iv$iv = iterator2.next();
                Sector sector = (Sector)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(this.buildSvgSector((Sector)p0));
            }
            companion.appendNodes((List)destination$iv$iv2, root);
            Iterable $this$forEach$iv2 = pieSectors;
            boolean $i$f$forEach2 = false;
            $this$mapTo$iv$iv = $this$forEach$iv2.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                Object element$iv2 = $this$mapTo$iv$iv.next();
                Sector it = (Sector)element$iv2;
                boolean bl4 = false;
                this.buildHint(it, ctx.getTargetCollector());
            }
            if (ctx.getAnnotations() == null) continue;
            boolean bl5 = false;
            this.buildAnnotations(root, pieCenter, pieSectors, ctx);
        }
    }

    private final LinePath buildSvgSector(Sector sector) {
        Object object = new SvgPathDataBuilder(false, 1, null);
        SvgPathDataBuilder $this$buildSvgSector_u24lambda_u244 = object;
        boolean bl = false;
        $this$buildSvgSector_u24lambda_u244.moveTo(sector.getInnerArcStart());
        $this$buildSvgSector_u24lambda_u244.lineTo(sector.getOuterArcStart());
        $this$buildSvgSector_u24lambda_u244.ellipticalArc(sector.getRadius(), sector.getRadius(), 0.0, sector.getAngle() > Math.PI, true, sector.getOuterArcEnd());
        $this$buildSvgSector_u24lambda_u244.lineTo(sector.getInnerArcEnd());
        $this$buildSvgSector_u24lambda_u244.ellipticalArc(sector.getHoleRadius(), sector.getHoleRadius(), 0.0, sector.getAngle() > Math.PI, false, sector.getInnerArcStart());
        SvgPathDataBuilder svgPathDataBuilder = object;
        Object $this$buildSvgSector_u24lambda_u245 = object = new LinePath(svgPathDataBuilder);
        boolean bl2 = false;
        Color color = sector.getP().fill();
        Intrinsics.checkNotNull((Object)color);
        Color fill = color;
        double fillAlpha = AestheticsUtil.INSTANCE.alpha(fill, sector.getP());
        ((LinePath)$this$buildSvgSector_u24lambda_u245).fill().set((Object)Colors.INSTANCE.withOpacity(fill, fillAlpha));
        ((LinePath)$this$buildSvgSector_u24lambda_u245).width().set((Object)this.strokeWidth);
        ((LinePath)$this$buildSvgSector_u24lambda_u245).color().set((Object)this.strokeColor);
        return object;
    }

    private final void buildHint(Sector sector, GeomTargetCollector targetCollector) {
        List list2 = CollectionsKt.plus((Collection)PieGeom.buildHint$resampleArc(sector, true), (Iterable)CollectionsKt.reversed((Iterable)PieGeom.buildHint$resampleArc(sector, false)));
        Function1 function1 = (Function1)new Function1<Integer, Integer>(sector){
            final /* synthetic */ Sector $sector;
            {
                this.$sector = $sector;
                super(1);
            }

            @NotNull
            public final Integer invoke(int it) {
                return this.$sector.getP().index();
            }
        };
        Color color = sector.getP().fill();
        Intrinsics.checkNotNull((Object)color);
        Double d = sector.getP().alpha();
        Intrinsics.checkNotNull((Object)d);
        GeomTargetCollector.DefaultImpls.addPolygon$default(targetCollector, list2, function1, new GeomTargetCollector.TooltipParams(null, null, null, CollectionsKt.listOf((Object)HintColorUtil.INSTANCE.applyAlpha(color, d)), 7, null), null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Sector> computeSectors(DoubleVector pieCenter, List<? extends DataPointAesthetics> dataPoints2) {
        void $this$mapTo$iv$iv;
        Iterable iterable = dataPoints2;
        double d = 0.0;
        for (Object t : iterable) {
            void it;
            DataPointAesthetics dataPointAesthetics = (DataPointAesthetics)t;
            double d2 = d;
            boolean bl = false;
            Double d3 = it.slice();
            Intrinsics.checkNotNull((Object)d3);
            double d4 = Math.abs(d3);
            d = d2 + d4;
        }
        double sum = d;
        double currentAngle = 0.0;
        currentAngle = -1.5707963267948966;
        currentAngle -= PieGeom.computeSectors$angle(sum, dataPoints2, (DataPointAesthetics)CollectionsKt.first(dataPoints2));
        Iterable $this$map$iv = dataPoints2;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Sector sector;
            void p;
            DataPointAesthetics dataPointAesthetics = (DataPointAesthetics)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double d5 = currentAngle;
            double d6 = currentAngle + PieGeom.computeSectors$angle(sum, dataPoints2, (DataPointAesthetics)p);
            Sector sector2 = sector = new Sector(pieCenter, (DataPointAesthetics)p, d5, d6);
            boolean bl2 = false;
            currentAngle = sector2.getEndAngle();
            collection.add(sector);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void buildAnnotations(SvgRoot root, DoubleVector pieCenter, List<Sector> sectors, GeomContext ctx) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Object t;
        Object t2;
        List<Sector> list2;
        void $this$filterTo$iv$iv;
        List<Sector> $this$filter$iv;
        List<Sector> list3;
        Sector it;
        void $this$filterTo$iv$iv2;
        List<Sector> $this$filter$iv2;
        if (ctx.getAnnotations() == null || sectors.isEmpty()) {
            return;
        }
        Iterable iterable = sectors;
        boolean $i$f$filter = false;
        void var8_9 = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (Sector)element$iv$iv;
            boolean bl = false;
            if (!(it.getOuterArcStart().getX() < pieCenter.getX() || it.getOuterArcEnd().getX() < pieCenter.getX() || it.getSectorCenter().getX() < pieCenter.getX())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        if ($this$filter$iv2.isEmpty()) {
            boolean bl = false;
            list3 = sectors;
        } else {
            list3 = $this$filter$iv2;
        }
        List leftSectors = list3;
        Iterable bl = sectors;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Sector it2 = (Sector)element$iv$iv;
            boolean bl2 = false;
            if (!(it2.getOuterArcStart().getX() > pieCenter.getX() || it2.getOuterArcEnd().getX() > pieCenter.getX() || it2.getSectorCenter().getX() > pieCenter.getX())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        if ($this$filter$iv.isEmpty()) {
            boolean bl3 = false;
            list2 = sectors;
        } else {
            list2 = $this$filter$iv;
        }
        List rightSectors = list2;
        double expand = 20.0;
        Iterator iterator = ((Iterable)leftSectors).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        it = (Sector)iterator.next();
        boolean $i$a$-minOf-PieGeom$buildAnnotations$leftBorder$22 = false;
        double bl2 = it.getPieCenter().getX() - it.getRadius();
        while (iterator.hasNext()) {
            Sector it3 = (Sector)iterator.next();
            $i$a$-minOf-PieGeom$buildAnnotations$leftBorder$1 = false;
            double d = it3.getPieCenter().getX() - it3.getRadius();
            bl2 = Math.min(bl2, d);
        }
        double leftBorder = bl2 - expand;
        Iterator $i$a$-minOf-PieGeom$buildAnnotations$leftBorder$22 = ((Iterable)rightSectors).iterator();
        if (!$i$a$-minOf-PieGeom$buildAnnotations$leftBorder$22.hasNext()) {
            throw new NoSuchElementException();
        }
        Sector it4 = (Sector)$i$a$-minOf-PieGeom$buildAnnotations$leftBorder$22.next();
        boolean bl4 = false;
        double it3 = it4.getPieCenter().getX() + it4.getRadius();
        while ($i$a$-minOf-PieGeom$buildAnnotations$leftBorder$22.hasNext()) {
            Sector it5 = (Sector)$i$a$-minOf-PieGeom$buildAnnotations$leftBorder$22.next();
            $i$a$-maxOf-PieGeom$buildAnnotations$rightBorder$1 = false;
            double d = it5.getPieCenter().getX() + it5.getRadius();
            it3 = Math.max(it3, d);
        }
        double rightBorder = it3 + expand;
        Function2 textSizeGetter2 = (Function2)new Function2<String, DataPointAesthetics, DoubleVector>(ctx){
            final /* synthetic */ GeomContext $ctx;
            {
                this.$ctx = $ctx;
                super(2);
            }

            @NotNull
            public final DoubleVector invoke(@NotNull String text, @NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Annotations annotations = this.$ctx.getAnnotations();
                Intrinsics.checkNotNull((Object)annotations);
                return TextUtil.measure$default(TextUtil.INSTANCE, text, jetbrains.datalore.plot.base.geom.PieGeom$Companion.toTextDataPointAesthetics$default(PieGeom.Companion, p, annotations.getTextStyle(), null, null, 12, null), this.$ctx, 0.0, 8, null);
            }
        };
        Iterable $this$maxBy$iv = leftSectors;
        boolean $i$f$maxByOrThrow = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t2 = maxElem$iv;
        } else {
            Sector p0 = (Sector)maxElem$iv;
            boolean bl5 = false;
            double maxValue$iv = p0.getRadius();
            do {
                Object e$iv = iterator$iv.next();
                Sector p02 = (Sector)e$iv;
                $i$a$-maxByOrThrow-PieGeom$buildAnnotations$leftMaxOffsetForOuter$1 = false;
                double v$iv = p02.getRadius();
                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t2 = maxElem$iv;
        }
        Sector it2 = (Sector)t2;
        boolean bl6 = false;
        double leftMaxOffsetForOuter = it2.getHoleRadius() + 1.2 * (it2.getRadius() - it2.getHoleRadius());
        Iterable $this$maxBy$iv2 = rightSectors;
        boolean $i$f$maxByOrThrow2 = false;
        Iterator iterator$iv2 = $this$maxBy$iv2.iterator();
        if (!iterator$iv2.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv2 = iterator$iv2.next();
        if (!iterator$iv2.hasNext()) {
            t = maxElem$iv2;
        } else {
            Sector p0 = (Sector)maxElem$iv2;
            boolean bl7 = false;
            double maxValue$iv = p0.getRadius();
            do {
                Object e$iv = iterator$iv2.next();
                Sector p03 = (Sector)e$iv;
                $i$a$-maxByOrThrow-PieGeom$buildAnnotations$rightMaxOffsetForOuter$1 = false;
                double v$iv = p03.getRadius();
                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                maxElem$iv2 = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv2.hasNext());
            t = maxElem$iv2;
        }
        Sector it6 = (Sector)t;
        boolean bl8 = false;
        double rightMaxOffsetForOuter = it6.getHoleRadius() + 1.2 * (it6.getRadius() - it6.getHoleRadius());
        Iterable $this$map$iv = sectors;
        boolean $i$f$map = false;
        maxElem$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void sector;
            Sector sector2 = (Sector)item$iv$iv;
            Collection collection = destination$iv$iv3;
            boolean bl9 = false;
            double offsetForPointer = leftSectors.contains(sector) && rightSectors.contains(sector) ? Math.max(leftMaxOffsetForOuter, rightMaxOffsetForOuter) : (leftSectors.contains(sector) ? leftMaxOffsetForOuter : rightMaxOffsetForOuter);
            Annotations annotations = ctx.getAnnotations();
            Intrinsics.checkNotNull((Object)annotations);
            collection.add(this.getAnnotationLabel((Sector)sector, annotations, (Function2<? super String, ? super DataPointAesthetics, DoubleVector>)textSizeGetter2, offsetForPointer));
        }
        List annotationLabels = (List)destination$iv$iv3;
        Annotations annotations = ctx.getAnnotations();
        Intrinsics.checkNotNull((Object)annotations);
        $this$map$iv = PieGeom.Companion.createAnnotationElements(pieCenter, annotationLabels, annotations.getTextStyle(), new DoubleSpan(leftBorder, rightBorder), ctx);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgGElement it7 = (SvgGElement)element$iv;
            boolean bl10 = false;
            root.add((SvgNode)it7);
        }
    }

    private final Companion.AnnotationLabel getAnnotationLabel(Sector sector, Annotations annotations, Function2<? super String, ? super DataPointAesthetics, DoubleVector> textSizeGetter2, double offsetForPointer) {
        Color color;
        DoubleVector doubleVector;
        boolean canBePlacedInside;
        DoubleVector textSize;
        String text;
        block8: {
            boolean bl;
            Iterator $this$flatMapTo$iv$iv;
            text = annotations.getAnnotationText(sector.getP().index());
            textSize = (DoubleVector)textSizeGetter2.invoke((Object)text, (Object)sector.getP());
            DoubleRectangle textRect = new DoubleRectangle(sector.getSectorCenter().subtract(textSize.mul(0.5)), textSize);
            Iterable $this$flatMap$iv = textRect.getParts();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                DoubleSegment it = (DoubleSegment)element$iv$iv;
                boolean bl2 = false;
                Object[] objectArray = new DoubleVector[]{it.getStart(), it.getEnd()};
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$all$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    DoubleVector p0 = (DoubleVector)element$iv;
                    boolean bl3 = false;
                    if (PieGeom.getAnnotationLabel$isPointInsideSector(sector, p0)) continue;
                    bl = false;
                    break block8;
                }
                bl = canBePlacedInside = true;
            }
        }
        if (canBePlacedInside) {
            doubleVector = sector.getSectorCenter();
        } else {
            double offset = sector.getHoleRadius() + 0.8 * (sector.getRadius() - sector.getHoleRadius());
            doubleVector = sector.getPosition().add(new DoubleVector(offset * Math.cos(sector.getDirection()), offset * Math.sin(sector.getDirection())));
        }
        DoubleVector pointerLocation = doubleVector;
        Companion.Side side = canBePlacedInside ? Companion.Side.INSIDE : (pointerLocation.getX() < sector.getPieCenter().getX() ? Companion.Side.LEFT : Companion.Side.RIGHT);
        DoubleVector outerPointerCoord = canBePlacedInside ? null : sector.getPosition().add(new DoubleVector(offsetForPointer * Math.cos(sector.getDirection()), offsetForPointer * Math.sin(sector.getDirection())));
        if (side != Companion.Side.INSIDE) {
            color = annotations.getTextStyle().getColor();
        } else {
            Color color2 = sector.getP().fill();
            Intrinsics.checkNotNull((Object)color2);
            color = Colors.INSTANCE.luminance(color2) < 0.5 ? Color.Companion.getWHITE() : Color.Companion.getBLACK();
        }
        Color textColor2 = color;
        return new Companion.AnnotationLabel(text, textSize, pointerLocation, outerPointerCoord, textColor2, side);
    }

    private final DoubleSpan dimensionSpan(DataPointAesthetics p, Aes<Double> coordAes) {
        DoubleSpan doubleSpan;
        Double size;
        Double loc = p.get(coordAes);
        if (SeriesUtil.INSTANCE.allFinite(loc, size = p.get(Aes.Companion.getSIZE()))) {
            Intrinsics.checkNotNull((Object)loc);
            Double d = size;
            Intrinsics.checkNotNull((Object)d);
            double expand = d / 2.0;
            doubleSpan = new DoubleSpan(loc - expand, loc + expand);
        } else {
            doubleSpan = null;
        }
        return doubleSpan;
    }

    @Override
    @Nullable
    public DoubleSpan widthSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        if (!isDiscrete) {
            return null;
        }
        return this.dimensionSpan(p, coordAes);
    }

    @Override
    @Nullable
    public DoubleSpan heightSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        if (!isDiscrete) {
            return null;
        }
        return this.dimensionSpan(p, coordAes);
    }

    private static final List<DoubleVector> buildHint$resampleArc(Sector $sector, boolean outerArc) {
        DoubleVector doubleVector;
        DoubleVector doubleVector2;
        KFunction kFunction;
        boolean bl = outerArc;
        if (bl) {
            kFunction = (KFunction)new Function1<Double, DoubleVector>((Object)$sector){

                @NotNull
                public final DoubleVector invoke(double p0) {
                    return ((Sector)this.receiver).outerArcPoint(p0);
                }
            };
        } else if (!bl) {
            kFunction = (KFunction)new Function1<Double, DoubleVector>((Object)$sector){

                @NotNull
                public final DoubleVector invoke(double p0) {
                    return ((Sector)this.receiver).innerArcPoint(p0);
                }
            };
        } else {
            throw new NoWhenBranchMatchedException();
        }
        KFunction arcPoint2 = kFunction;
        boolean bl2 = outerArc;
        if (bl2) {
            doubleVector2 = $sector.getOuterArcStart();
        } else if (!bl2) {
            doubleVector2 = $sector.getInnerArcStart();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DoubleVector startPoint = doubleVector2;
        boolean bl3 = outerArc;
        if (bl3) {
            doubleVector = $sector.getOuterArcEnd();
        } else if (!bl3) {
            doubleVector = $sector.getInnerArcEnd();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DoubleVector endPoint = doubleVector;
        double segmentLength = startPoint.subtract(endPoint).length();
        Function1 arc2 = (Function1)new Function1<DoubleVector, DoubleVector>(startPoint, segmentLength, (KFunction<DoubleVector>)arcPoint2, $sector){
            final /* synthetic */ DoubleVector $startPoint;
            final /* synthetic */ double $segmentLength;
            final /* synthetic */ KFunction<DoubleVector> $arcPoint;
            final /* synthetic */ Sector $sector;
            {
                this.$startPoint = $startPoint;
                this.$segmentLength = $segmentLength;
                this.$arcPoint = $arcPoint;
                this.$sector = $sector;
                super(1);
            }

            @NotNull
            public final DoubleVector invoke(@NotNull DoubleVector p) {
                double ratio;
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                double d = ratio = p.subtract(this.$startPoint).length() / this.$segmentLength;
                return !Double.isInfinite(d) && !Double.isNaN(d) ? (DoubleVector)((Function1)this.$arcPoint).invoke((Object)(this.$sector.getStartAngle() + this.$sector.getAngle() * ratio)) : p;
            }
        };
        return AdaptiveResampler.Companion.forDoubleVector(arc2, 2.0).resample((Object)startPoint, (Object)endPoint);
    }

    private static final double computeSectors$angle(double sum, List<? extends DataPointAesthetics> $dataPoints, DataPointAesthetics p) {
        double d;
        if (sum == 0.0) {
            d = 1.0 / (double)$dataPoints.size();
        } else {
            Double d2 = p.slice();
            Intrinsics.checkNotNull((Object)d2);
            d = Math.abs(d2) / sum;
        }
        double it = d;
        boolean bl = false;
        return Math.PI * 2 * it;
    }

    private static final boolean getAnnotationLabel$isPointInsideSector(Sector $sector, DoubleVector pnt) {
        DoubleVector v = pnt.subtract($sector.getPosition());
        double d = $sector.getHoleRadius();
        double d2 = $sector.getRadius();
        double d3 = v.length();
        if (!(d <= d3 ? d3 <= d2 : false)) {
            return false;
        }
        double it = Math.atan2(v.getY(), v.getX());
        boolean bl = false;
        double angle = (-1.5707963267948966 <= it ? it <= Math.PI : false) && Math.abs($sector.getStartAngle()) > Math.PI ? it - Math.PI * 2 : ((-Math.PI <= it ? it <= -1.5707963267948966 : false) && Math.abs($sector.getEndAngle()) > Math.PI ? it + Math.PI * 2 : it);
        return $sector.getStartAngle() <= angle && angle < $sector.getEndAngle();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b#\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010'\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u000e\u0010(\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010)\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0007R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u001b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0011\u0010 \u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0016R\u0011\u0010\"\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\fR\u0011\u0010$\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\f\u00a8\u0006*"}, d2={"Ljetbrains/datalore/plot/base/geom/PieGeom$Sector;", "", "pieCenter", "Ljetbrains/datalore/base/geometry/DoubleVector;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "startAngle", "", "endAngle", "(Ljetbrains/datalore/plot/base/geom/PieGeom;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/base/DataPointAesthetics;DD)V", "angle", "getAngle", "()D", "direction", "getDirection", "getEndAngle", "explode", "fullCircleDrawingFix", "holeRadius", "getHoleRadius", "innerArcEnd", "getInnerArcEnd", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "innerArcStart", "getInnerArcStart", "outerArcEnd", "getOuterArcEnd", "outerArcStart", "getOuterArcStart", "getP", "()Ljetbrains/datalore/plot/base/DataPointAesthetics;", "getPieCenter", "position", "getPosition", "radius", "getRadius", "sectorCenter", "getSectorCenter", "getStartAngle", "arcPoint", "innerArcPoint", "outerArcPoint", "plot-base-portable"})
    private final class Sector {
        @NotNull
        private final DoubleVector pieCenter;
        @NotNull
        private final DataPointAesthetics p;
        private final double startAngle;
        private final double endAngle;
        private final double angle;
        private final double radius;
        private final double holeRadius;
        private final double direction;
        private final double explode;
        @NotNull
        private final DoubleVector position;
        private final double fullCircleDrawingFix;
        @NotNull
        private final DoubleVector outerArcStart;
        @NotNull
        private final DoubleVector outerArcEnd;
        @NotNull
        private final DoubleVector innerArcStart;
        @NotNull
        private final DoubleVector innerArcEnd;

        /*
         * WARNING - void declaration
         */
        public Sector(@NotNull DoubleVector pieCenter, DataPointAesthetics p, double startAngle, double endAngle) {
            double d;
            Intrinsics.checkNotNullParameter((Object)pieCenter, (String)"pieCenter");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            this.pieCenter = pieCenter;
            this.p = p;
            this.startAngle = startAngle;
            this.endAngle = endAngle;
            this.angle = this.endAngle - this.startAngle;
            this.radius = AesScaling.INSTANCE.pieDiameter(this.p) / (double)2;
            this.holeRadius = this.radius * PieGeom.this.getHoleSize();
            this.direction = this.startAngle + this.angle / (double)2;
            Sector sector = this;
            Double d2 = this.p.explode();
            if (d2 != null) {
                void it;
                double d3 = ((Number)d2).doubleValue();
                Sector sector2 = sector;
                boolean bl = false;
                double d4 = this.radius * it;
                sector = sector2;
                d = d4;
            } else {
                d = 0.0;
            }
            sector.explode = d;
            this.position = this.pieCenter.add(new DoubleVector(this.explode * Math.cos(this.direction), this.explode * Math.sin(this.direction)));
            this.fullCircleDrawingFix = this.angle % (Math.PI * 2) == 0.0 ? 1.0E-4 : 0.0;
            this.outerArcStart = this.outerArcPoint(this.startAngle);
            this.outerArcEnd = this.outerArcPoint(this.endAngle - this.fullCircleDrawingFix);
            this.innerArcStart = this.innerArcPoint(this.startAngle);
            this.innerArcEnd = this.innerArcPoint(this.endAngle - this.fullCircleDrawingFix);
        }

        @NotNull
        public final DoubleVector getPieCenter() {
            return this.pieCenter;
        }

        @NotNull
        public final DataPointAesthetics getP() {
            return this.p;
        }

        public final double getStartAngle() {
            return this.startAngle;
        }

        public final double getEndAngle() {
            return this.endAngle;
        }

        public final double getAngle() {
            return this.angle;
        }

        public final double getRadius() {
            return this.radius;
        }

        public final double getHoleRadius() {
            return this.holeRadius;
        }

        public final double getDirection() {
            return this.direction;
        }

        @NotNull
        public final DoubleVector getPosition() {
            return this.position;
        }

        @NotNull
        public final DoubleVector getOuterArcStart() {
            return this.outerArcStart;
        }

        @NotNull
        public final DoubleVector getOuterArcEnd() {
            return this.outerArcEnd;
        }

        @NotNull
        public final DoubleVector getInnerArcStart() {
            return this.innerArcStart;
        }

        @NotNull
        public final DoubleVector getInnerArcEnd() {
            return this.innerArcEnd;
        }

        @NotNull
        public final DoubleVector outerArcPoint(double angle) {
            return this.arcPoint(this.radius, angle);
        }

        @NotNull
        public final DoubleVector innerArcPoint(double angle) {
            return this.arcPoint(this.holeRadius, angle);
        }

        private final DoubleVector arcPoint(double radius, double angle) {
            return this.position.add(new DoubleVector(radius * Math.cos(angle), radius * Math.sin(angle)));
        }

        @NotNull
        public final DoubleVector getSectorCenter() {
            double offset = 0.5 * (this.radius - this.holeRadius);
            return this.position.add(new DoubleVector(this.holeRadius * Math.cos(this.direction), this.holeRadius * Math.sin(this.direction))).add(new DoubleVector(offset * Math.cos(this.direction), offset * Math.sin(this.direction)));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/base/geom/PieGeom$PieLegendKeyElementFactory;", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "(Ljetbrains/datalore/plot/base/geom/PieGeom;)V", "createKeyElement", "Ljetbrains/datalore/vis/svg/SvgGElement;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "size", "Ljetbrains/datalore/base/geometry/DoubleVector;", "minimumKeySize", "shapeSize", "", "plot-base-portable"})
    private final class PieLegendKeyElementFactory
    implements LegendKeyElementFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size) {
            void $this$createKeyElement_u24lambda_u241_u24lambda_u240;
            SvgCircleElement svgCircleElement;
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            SvgGElement svgGElement = new SvgGElement();
            PieGeom pieGeom = PieGeom.this;
            SvgGElement $this$createKeyElement_u24lambda_u241 = svgGElement;
            boolean bl = false;
            SvgCircleElement svgCircleElement2 = svgCircleElement = new SvgCircleElement(size.getX() / (double)2, size.getY() / (double)2, this.shapeSize(p) / (double)2);
            ObservableList observableList = $this$createKeyElement_u24lambda_u241.children();
            boolean bl2 = false;
            Color color = p.fill();
            Intrinsics.checkNotNull((Object)color);
            Color fill = color;
            $this$createKeyElement_u24lambda_u241_u24lambda_u240.fillColor().set((Object)fill);
            $this$createKeyElement_u24lambda_u241_u24lambda_u240.strokeColor().set((Object)(Intrinsics.areEqual((Object)fill, (Object)Color.Companion.getTRANSPARENT()) ? Color.Companion.getBLACK() : pieGeom.getStrokeColor()));
            $this$createKeyElement_u24lambda_u241_u24lambda_u240.strokeWidth().set((Object)1.5);
            observableList.add((Object)svgCircleElement);
            return svgGElement;
        }

        @Override
        @NotNull
        public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            double shapeSize = this.shapeSize(p);
            double size = shapeSize + 4.0;
            return new DoubleVector(size, size);
        }

        private final double shapeSize(DataPointAesthetics p) {
            return AesScaling.INSTANCE.pieDiameter(p);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J<\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J2\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ljetbrains/datalore/plot/base/geom/PieGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "INTERVAL_BETWEEN_ANNOTATIONS", "", "createAnnotationElement", "Ljetbrains/datalore/vis/svg/SvgGElement;", "label", "Ljetbrains/datalore/plot/base/geom/PieGeom$Companion$AnnotationLabel;", "textLocation", "Ljetbrains/datalore/base/geometry/DoubleVector;", "textStyle", "Ljetbrains/datalore/vis/TextStyle;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "createAnnotationElements", "", "pieCenter", "annotationLabels", "xRange", "Ljetbrains/datalore/base/interval/DoubleSpan;", "toTextDataPointAesthetics", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "p", "color", "Ljetbrains/datalore/base/values/Color;", "hjust", "", "AnnotationLabel", "Side", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final DataPointAesthetics toTextDataPointAesthetics(DataPointAesthetics p, TextStyle textStyle, Color color, String hjust) {
            return new DataPointAestheticsDelegate(p, textStyle, color, hjust){
                final /* synthetic */ TextStyle $textStyle;
                final /* synthetic */ Color $color;
                final /* synthetic */ String $hjust;
                {
                    this.$textStyle = $textStyle;
                    this.$color = $color;
                    this.$hjust = $hjust;
                    super($p);
                }

                @Nullable
                public <T> T get(@NotNull Aes<T> aes) {
                    Object object;
                    Intrinsics.checkNotNullParameter(aes, (String)"aes");
                    Aes<T> aes2 = aes;
                    if (Intrinsics.areEqual(aes2, Aes.Companion.getSIZE())) {
                        object = this.$textStyle.getSize() / (double)2;
                    } else if (Intrinsics.areEqual(aes2, Aes.Companion.getFAMILY())) {
                        object = this.$textStyle.getFamily();
                    } else if (Intrinsics.areEqual(aes2, Aes.Companion.getFONTFACE())) {
                        object = this.$textStyle.getFace().toString();
                    } else if (Intrinsics.areEqual(aes2, Aes.Companion.getCOLOR())) {
                        object = this.$color;
                    } else if (Intrinsics.areEqual(aes2, Aes.Companion.getHJUST())) {
                        object = this.$hjust;
                        if (object == null) {
                            object = "middle";
                        }
                    } else {
                        object = Intrinsics.areEqual(aes2, Aes.Companion.getVJUST()) ? "center" : super.get(aes);
                    }
                    Object value = object;
                    return (T)value;
                }
            };
        }

        static /* synthetic */ DataPointAesthetics toTextDataPointAesthetics$default(Companion companion, DataPointAesthetics dataPointAesthetics, TextStyle textStyle, Color color, String string, int n, Object object) {
            if ((n & 1) != 0) {
                dataPointAesthetics = new AestheticsBuilder(0, 1, null).build().dataPointAt(0);
            }
            if ((n & 4) != 0) {
                color = null;
            }
            if ((n & 8) != 0) {
                string = null;
            }
            return companion.toTextDataPointAesthetics(dataPointAesthetics, textStyle, color, string);
        }

        /*
         * WARNING - void declaration
         */
        private final List<SvgGElement> createAnnotationElements(DoubleVector pieCenter, List<AnnotationLabel> annotationLabels, TextStyle textStyle, DoubleSpan xRange, GeomContext ctx) {
            void $this$flatMapTo$iv$iv;
            Side[] $this$flatMap$iv = Side.values();
            boolean $i$f$flatMap = false;
            Side[] sideArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void side = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl = false;
                Iterable list$iv$iv = jetbrains.datalore.plot.base.geom.PieGeom$Companion.createAnnotationElements$createForSide(annotationLabels, xRange, textStyle, ctx, pieCenter, (Side)side);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final SvgGElement createAnnotationElement(AnnotationLabel label, DoubleVector textLocation, TextStyle textStyle, GeomContext ctx) {
            void $this$createAnnotationElement_u24lambda_u2411;
            void $this$forEach$iv;
            SvgGElement g = new TextGeom().buildTextComponent(jetbrains.datalore.plot.base.geom.PieGeom$Companion.toTextDataPointAesthetics$default(this, null, textStyle, label.getTextColor(), label.getSide().getHJust(), 1, null), textLocation, label.getText(), 1.0, ctx, null);
            if (label.getOuterPointerCoord() == null) {
                return g;
            }
            double startXPos = label.getSide() == Side.LEFT ? textLocation.getX() + 5.0 : textLocation.getX() - 5.0;
            double midXPos = label.getSide() == Side.RIGHT && label.getOuterPointerCoord().getX() > startXPos || label.getSide() == Side.LEFT && label.getOuterPointerCoord().getX() < startXPos ? startXPos : label.getOuterPointerCoord().getX();
            DoubleVector middlePoint = new DoubleVector(midXPos, textLocation.getY());
            SvgLineElement[] svgLineElementArray = new SvgLineElement[]{new SvgLineElement(startXPos, textLocation.getY(), middlePoint.getX(), middlePoint.getY()), new SvgLineElement(middlePoint.getX(), middlePoint.getY(), label.getLocation().getX(), label.getLocation().getY())};
            svgLineElementArray = CollectionsKt.listOf((Object[])svgLineElementArray);
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                SvgLineElement line = (SvgLineElement)element$iv;
                boolean bl = false;
                line.strokeColor().set((Object)label.getTextColor());
                line.strokeWidth().set((Object)0.7);
                g.children().add((Object)line);
            }
            SvgLineElement[] $i$f$forEach22 = svgLineElementArray = new SvgCircleElement(label.getLocation().getX(), label.getLocation().getY(), 1.5);
            ObservableList observableList = g.children();
            boolean bl = false;
            $this$createAnnotationElement_u24lambda_u2411.fillColor().set((Object)label.getTextColor());
            observableList.add((Object)svgLineElementArray);
            return g;
        }

        /*
         * WARNING - void declaration
         */
        private static final List<SvgGElement> createAnnotationElements$createForSide(List<AnnotationLabel> $annotationLabels, DoubleSpan $xRange, TextStyle $textStyle, GeomContext $ctx, DoubleVector $pieCenter, Side side) {
            void $this$mapTo$iv$iv;
            List outsideLabels;
            List list2;
            boolean bl;
            Double d;
            void $this$filterTo$iv$iv;
            if (side == Side.INSIDE) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                AnnotationLabel it;
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv;
                Iterable iterable = $annotationLabels;
                boolean $i$f$filter = false;
                void var8_10 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it = (AnnotationLabel)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it.getSide() == side)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv2 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    it = (AnnotationLabel)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(Companion.createAnnotationElement(it, it.getLocation(), $textStyle, $ctx));
                }
                return (List)destination$iv$iv;
            }
            Ref.BooleanRef startFromTheTop = new Ref.BooleanRef();
            Iterable $this$filter$iv = $annotationLabels;
            boolean $i$f$filter = false;
            Iterable $i$f$mapTo = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AnnotationLabel it = (AnnotationLabel)element$iv$iv;
                boolean bl4 = false;
                if (!(it.getSide() == side)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List l = (List)destination$iv$iv;
            boolean bl5 = false;
            destination$iv$iv = l;
            Object $i$f$filterTo22 = startFromTheTop;
            Iterator<Object> it = destination$iv$iv.iterator();
            if (!it.hasNext()) {
                d = null;
            } else {
                AnnotationLabel it2 = (AnnotationLabel)it.next();
                boolean bl6 = false;
                double bl4 = it2.getLocation().getY();
                while (it.hasNext()) {
                    AnnotationLabel it3 = (AnnotationLabel)it.next();
                    $i$a$-minOfOrNull-PieGeom$Companion$createAnnotationElements$createForSide$outsideLabels$2$1 = false;
                    double d2 = it3.getLocation().getY();
                    bl4 = Math.min(bl4, d2);
                }
                d = bl4;
            }
            Ref.BooleanRef booleanRef = $i$f$filterTo22;
            if (d != null) {
                void it4;
                double d3 = ((Number)d).doubleValue();
                $i$f$filterTo22 = booleanRef;
                boolean bl7 = false;
                booleanRef = $i$f$filterTo22;
                bl = it4 < $pieCenter.getY();
            } else {
                bl = booleanRef.element = false;
            }
            if (startFromTheTop.element) {
                Iterable $this$sortedBy$iv = l;
                boolean $i$f$sortedBy = false;
                list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a2, T b2) {
                        AnnotationLabel it = (AnnotationLabel)a2;
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(it.getLocation().getY());
                        it = (AnnotationLabel)b2;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getLocation().getY()));
                    }
                });
            } else {
                Iterable $this$sortedByDescending$iv = l;
                boolean $i$f$sortedByDescending = false;
                list2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a2, T b2) {
                        AnnotationLabel it = (AnnotationLabel)b2;
                        boolean bl = false;
                        Comparable comparable = Double.valueOf(it.getLocation().getY());
                        it = (AnnotationLabel)a2;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getLocation().getY()));
                    }
                });
            }
            if ((outsideLabels = list2).isEmpty()) {
                return CollectionsKt.emptyList();
            }
            double d4 = side == Side.LEFT ? $xRange.getLowerEnd().doubleValue() : $xRange.getUpperEnd().doubleValue();
            DoubleVector doubleVector = ((AnnotationLabel)CollectionsKt.first((List)outsideLabels)).getOuterPointerCoord();
            Intrinsics.checkNotNull((Object)doubleVector);
            DoubleVector startPosition = new DoubleVector(d4, doubleVector.getY());
            double yOffset = 0.0;
            Iterable $this$map$iv = outsideLabels;
            boolean $i$f$map = false;
            $i$f$filterTo22 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void label;
                AnnotationLabel annotationLabel = (AnnotationLabel)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl8 = false;
                DoubleVector loc = startFromTheTop.element ? new DoubleVector(startPosition.getX(), startPosition.getY() + yOffset) : new DoubleVector(startPosition.getX(), startPosition.getY() - yOffset);
                yOffset += label.getTextSize().getY() + 4.0;
                collection.add(Companion.createAnnotationElement((AnnotationLabel)label, loc, $textStyle, $ctx));
            }
            return (List)destination$iv$iv2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Ljetbrains/datalore/plot/base/geom/PieGeom$Companion$Side;", "", "(Ljava/lang/String;I)V", "getHJust", "", "INSIDE", "LEFT", "RIGHT", "plot-base-portable"})
        private static final abstract class Side
        extends Enum<Side> {
            public static final /* enum */ Side INSIDE = new INSIDE("INSIDE", 0);
            public static final /* enum */ Side LEFT = new LEFT("LEFT", 1);
            public static final /* enum */ Side RIGHT = new RIGHT("RIGHT", 2);
            private static final /* synthetic */ Side[] $VALUES;

            private Side() {
            }

            @NotNull
            public abstract String getHJust();

            public static Side[] values() {
                return (Side[])$VALUES.clone();
            }

            public static Side valueOf(String value) {
                return Enum.valueOf(Side.class, value);
            }

            public /* synthetic */ Side(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
                this();
            }

            static {
                $VALUES = sideArray = new Side[]{Side.INSIDE, Side.LEFT, Side.RIGHT};
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Ljetbrains/datalore/plot/base/geom/PieGeom$Companion$Side$INSIDE;", "Ljetbrains/datalore/plot/base/geom/PieGeom$Companion$Side;", "getHJust", "", "plot-base-portable"})
            static final class INSIDE
            extends Side {
                /*
                 * WARNING - void declaration
                 */
                INSIDE() {
                    void var1_1;
                }

                @Override
                @NotNull
                public String getHJust() {
                    return "middle";
                }
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Ljetbrains/datalore/plot/base/geom/PieGeom$Companion$Side$LEFT;", "Ljetbrains/datalore/plot/base/geom/PieGeom$Companion$Side;", "getHJust", "", "plot-base-portable"})
            static final class LEFT
            extends Side {
                /*
                 * WARNING - void declaration
                 */
                LEFT() {
                    void var1_1;
                }

                @Override
                @NotNull
                public String getHJust() {
                    return "right";
                }
            }

            @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Ljetbrains/datalore/plot/base/geom/PieGeom$Companion$Side$RIGHT;", "Ljetbrains/datalore/plot/base/geom/PieGeom$Companion$Side;", "getHJust", "", "plot-base-portable"})
            static final class RIGHT
            extends Side {
                /*
                 * WARNING - void declaration
                 */
                RIGHT() {
                    void var1_1;
                }

                @Override
                @NotNull
                public String getHJust() {
                    return "left";
                }
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u000bH\u00c6\u0003JG\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006$"}, d2={"Ljetbrains/datalore/plot/base/geom/PieGeom$Companion$AnnotationLabel;", "", "text", "", "textSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "location", "outerPointerCoord", "textColor", "Ljetbrains/datalore/base/values/Color;", "side", "Ljetbrains/datalore/plot/base/geom/PieGeom$Companion$Side;", "(Ljava/lang/String;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/base/values/Color;Ljetbrains/datalore/plot/base/geom/PieGeom$Companion$Side;)V", "getLocation", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "getOuterPointerCoord", "getSide", "()Ljetbrains/datalore/plot/base/geom/PieGeom$Companion$Side;", "getText", "()Ljava/lang/String;", "getTextColor", "()Ljetbrains/datalore/base/values/Color;", "getTextSize", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "plot-base-portable"})
        private static final class AnnotationLabel {
            @NotNull
            private final String text;
            @NotNull
            private final DoubleVector textSize;
            @NotNull
            private final DoubleVector location;
            @Nullable
            private final DoubleVector outerPointerCoord;
            @NotNull
            private final Color textColor;
            @NotNull
            private final Side side;

            public AnnotationLabel(@NotNull String text, @NotNull DoubleVector textSize, @NotNull DoubleVector location, @Nullable DoubleVector outerPointerCoord, @NotNull Color textColor2, @NotNull Side side) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)textSize, (String)"textSize");
                Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                Intrinsics.checkNotNullParameter((Object)textColor2, (String)"textColor");
                Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
                this.text = text;
                this.textSize = textSize;
                this.location = location;
                this.outerPointerCoord = outerPointerCoord;
                this.textColor = textColor2;
                this.side = side;
            }

            @NotNull
            public final String getText() {
                return this.text;
            }

            @NotNull
            public final DoubleVector getTextSize() {
                return this.textSize;
            }

            @NotNull
            public final DoubleVector getLocation() {
                return this.location;
            }

            @Nullable
            public final DoubleVector getOuterPointerCoord() {
                return this.outerPointerCoord;
            }

            @NotNull
            public final Color getTextColor() {
                return this.textColor;
            }

            @NotNull
            public final Side getSide() {
                return this.side;
            }

            @NotNull
            public final String component1() {
                return this.text;
            }

            @NotNull
            public final DoubleVector component2() {
                return this.textSize;
            }

            @NotNull
            public final DoubleVector component3() {
                return this.location;
            }

            @Nullable
            public final DoubleVector component4() {
                return this.outerPointerCoord;
            }

            @NotNull
            public final Color component5() {
                return this.textColor;
            }

            @NotNull
            public final Side component6() {
                return this.side;
            }

            @NotNull
            public final AnnotationLabel copy(@NotNull String text, @NotNull DoubleVector textSize, @NotNull DoubleVector location, @Nullable DoubleVector outerPointerCoord, @NotNull Color textColor2, @NotNull Side side) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)textSize, (String)"textSize");
                Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                Intrinsics.checkNotNullParameter((Object)textColor2, (String)"textColor");
                Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
                return new AnnotationLabel(text, textSize, location, outerPointerCoord, textColor2, side);
            }

            public static /* synthetic */ AnnotationLabel copy$default(AnnotationLabel annotationLabel, String string, DoubleVector doubleVector, DoubleVector doubleVector2, DoubleVector doubleVector3, Color color, Side side, int n, Object object) {
                if ((n & 1) != 0) {
                    string = annotationLabel.text;
                }
                if ((n & 2) != 0) {
                    doubleVector = annotationLabel.textSize;
                }
                if ((n & 4) != 0) {
                    doubleVector2 = annotationLabel.location;
                }
                if ((n & 8) != 0) {
                    doubleVector3 = annotationLabel.outerPointerCoord;
                }
                if ((n & 0x10) != 0) {
                    color = annotationLabel.textColor;
                }
                if ((n & 0x20) != 0) {
                    side = annotationLabel.side;
                }
                return annotationLabel.copy(string, doubleVector, doubleVector2, doubleVector3, color, side);
            }

            @NotNull
            public String toString() {
                return "AnnotationLabel(text=" + this.text + ", textSize=" + this.textSize + ", location=" + this.location + ", outerPointerCoord=" + this.outerPointerCoord + ", textColor=" + this.textColor + ", side=" + (Object)((Object)this.side) + ')';
            }

            public int hashCode() {
                int result = this.text.hashCode();
                result = result * 31 + this.textSize.hashCode();
                result = result * 31 + this.location.hashCode();
                result = result * 31 + (this.outerPointerCoord == null ? 0 : this.outerPointerCoord.hashCode());
                result = result * 31 + this.textColor.hashCode();
                result = result * 31 + this.side.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AnnotationLabel)) {
                    return false;
                }
                AnnotationLabel annotationLabel = (AnnotationLabel)other;
                if (!Intrinsics.areEqual((Object)this.text, (Object)annotationLabel.text)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.textSize, (Object)annotationLabel.textSize)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.location, (Object)annotationLabel.location)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.outerPointerCoord, (Object)annotationLabel.outerPointerCoord)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.textColor, (Object)annotationLabel.textColor)) {
                    return false;
                }
                return this.side == annotationLabel.side;
            }
        }
    }
}

