/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.geom.TextGeom;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.TextUtil;
import jetbrains.datalore.plot.base.render.svg.MultilineLabel;
import jetbrains.datalore.plot.base.render.svg.Text;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgPathDataBuilder;
import jetbrains.datalore.vis.svg.SvgPathElement;
import jetbrains.datalore.vis.svg.SvgTransformable;
import jetbrains.datalore.vis.svg.SvgUtils;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014H\u0016J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\b\u00a8\u0006$"}, d2={"Ljetbrains/datalore/plot/base/geom/LabelGeom;", "Ljetbrains/datalore/plot/base/geom/TextGeom;", "()V", "borderWidth", "", "getBorderWidth", "()D", "setBorderWidth", "(D)V", "paddingFactor", "getPaddingFactor", "setPaddingFactor", "radiusFactor", "getRadiusFactor", "setRadiusFactor", "buildTextComponent", "Ljetbrains/datalore/vis/svg/SvgGElement;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "location", "Ljetbrains/datalore/base/geometry/DoubleVector;", "text", "", "sizeUnitRatio", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "boundsCenter", "rectangleForText", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "textSize", "padding", "hAnchor", "Ljetbrains/datalore/plot/base/render/svg/Text$HorizontalAnchor;", "vAnchor", "Ljetbrains/datalore/plot/base/render/svg/Text$VerticalAnchor;", "Companion", "plot-base-portable"})
public final class LabelGeom
extends TextGeom {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double paddingFactor = 0.25;
    private double radiusFactor = 0.15;
    private double borderWidth = 1.0;

    public final double getPaddingFactor() {
        return this.paddingFactor;
    }

    public final void setPaddingFactor(double d) {
        this.paddingFactor = d;
    }

    public final double getRadiusFactor() {
        return this.radiusFactor;
    }

    public final void setRadiusFactor(double d) {
        this.radiusFactor = d;
    }

    public final double getBorderWidth() {
        return this.borderWidth;
    }

    public final void setBorderWidth(double d) {
        this.borderWidth = d;
    }

    @Override
    @NotNull
    public SvgGElement buildTextComponent(@NotNull DataPointAesthetics p, @NotNull DoubleVector location, @NotNull String text, double sizeUnitRatio, @NotNull GeomContext ctx, @Nullable DoubleVector boundsCenter) {
        double d;
        SvgPathElement svgPathElement;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        DoubleVector textSize = TextUtil.INSTANCE.measure(text, p, ctx, sizeUnitRatio);
        Text.HorizontalAnchor hAnchor = TextUtil.INSTANCE.hAnchor(p, location, boundsCenter);
        Text.VerticalAnchor vAnchor = TextUtil.INSTANCE.vAnchor(p, location, boundsCenter);
        double fontSize = TextUtil.INSTANCE.fontSize(p, sizeUnitRatio);
        double padding = fontSize * this.paddingFactor;
        DoubleRectangle rectangle = this.rectangleForText(location, textSize, padding, hAnchor, vAnchor);
        SvgPathElement $this$buildTextComponent_u24lambda_u240 = svgPathElement = new SvgPathElement();
        boolean bl = false;
        $this$buildTextComponent_u24lambda_u240.d().set((Object)LabelGeom.Companion.roundedRectangle(rectangle, this.radiusFactor * rectangle.getHeight()).build());
        SvgPathElement backgroundRect = svgPathElement;
        GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)backgroundRect, p, false, null, 12, null);
        backgroundRect.strokeWidth().set((Object)this.borderWidth);
        MultilineLabel label = new MultilineLabel(text);
        TextUtil.INSTANCE.decorate(label, p, sizeUnitRatio, false);
        switch (WhenMappings.$EnumSwitchMapping$0[hAnchor.ordinal()]) {
            case 1: {
                d = location.getX() + padding;
                break;
            }
            case 2: {
                d = location.getX() - padding;
                break;
            }
            case 3: {
                d = location.getX();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double xPosition = d;
        DoubleVector textPosition = new DoubleVector(xPosition, rectangle.getOrigin().getY() + padding + fontSize * 0.8);
        label.setHorizontalAnchor(hAnchor);
        label.moveTo(textPosition);
        SvgGElement g = new SvgGElement();
        g.children().add((Object)backgroundRect);
        g.children().add((Object)label.getRootGroup());
        SvgUtils.INSTANCE.transformRotate((SvgTransformable)g, TextUtil.INSTANCE.angle(p), location.getX(), location.getY());
        return g;
    }

    private final DoubleRectangle rectangleForText(DoubleVector location, DoubleVector textSize, double padding, Text.HorizontalAnchor hAnchor, Text.VerticalAnchor vAnchor) {
        double d;
        double d2;
        double width2 = textSize.getX() + padding * (double)2;
        double height = textSize.getY() + padding * (double)2;
        switch (WhenMappings.$EnumSwitchMapping$0[hAnchor.ordinal()]) {
            case 1: {
                d2 = location.getX();
                break;
            }
            case 2: {
                d2 = location.getX() - width2;
                break;
            }
            case 3: {
                d2 = location.getX() - width2 / (double)2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double originX = d2;
        switch (WhenMappings.$EnumSwitchMapping$1[vAnchor.ordinal()]) {
            case 1: {
                d = location.getY();
                break;
            }
            case 2: {
                d = location.getY() - height;
                break;
            }
            case 3: {
                d = location.getY() - height / (double)2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double originY = d;
        return new DoubleRectangle(originX, originY, width2, height);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/geom/LabelGeom$Companion;", "", "()V", "roundedRectangle", "Ljetbrains/datalore/vis/svg/SvgPathDataBuilder;", "rect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "radius", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final SvgPathDataBuilder roundedRectangle(DoubleRectangle rect, double radius) {
            SvgPathDataBuilder svgPathDataBuilder;
            SvgPathDataBuilder $this$roundedRectangle_u24lambda_u241 = svgPathDataBuilder = new SvgPathDataBuilder(false, 1, null);
            boolean bl = false;
            DoubleRectangle $this$roundedRectangle_u24lambda_u241_u24lambda_u240 = rect;
            boolean bl2 = false;
            double r = Math.min(radius, Math.min($this$roundedRectangle_u24lambda_u241_u24lambda_u240.getWidth() / (double)2, $this$roundedRectangle_u24lambda_u241_u24lambda_u240.getHeight() / (double)2));
            SvgPathDataBuilder.moveTo$default((SvgPathDataBuilder)$this$roundedRectangle_u24lambda_u241, (double)($this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight() - r), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom(), (boolean)false, (int)4, null);
            SvgPathDataBuilder.curveTo$default((SvgPathDataBuilder)$this$roundedRectangle_u24lambda_u241, (double)($this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight() - r), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom(), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight(), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom(), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight(), (double)($this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom() - r), (boolean)false, (int)64, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$roundedRectangle_u24lambda_u241, (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight(), (double)($this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop() + r), (boolean)false, (int)4, null);
            SvgPathDataBuilder.curveTo$default((SvgPathDataBuilder)$this$roundedRectangle_u24lambda_u241, (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight(), (double)($this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop() + r), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight(), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop(), (double)($this$roundedRectangle_u24lambda_u241_u24lambda_u240.getRight() - r), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop(), (boolean)false, (int)64, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$roundedRectangle_u24lambda_u241, (double)($this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft() + r), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop(), (boolean)false, (int)4, null);
            SvgPathDataBuilder.curveTo$default((SvgPathDataBuilder)$this$roundedRectangle_u24lambda_u241, (double)($this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft() + r), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop(), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft(), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop(), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft(), (double)($this$roundedRectangle_u24lambda_u241_u24lambda_u240.getTop() + r), (boolean)false, (int)64, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$roundedRectangle_u24lambda_u241, (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft(), (double)($this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom() - r), (boolean)false, (int)4, null);
            SvgPathDataBuilder.curveTo$default((SvgPathDataBuilder)$this$roundedRectangle_u24lambda_u241, (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft(), (double)($this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom() - r), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft(), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom(), (double)($this$roundedRectangle_u24lambda_u241_u24lambda_u240.getLeft() + r), (double)$this$roundedRectangle_u24lambda_u241_u24lambda_u240.getBottom(), (boolean)false, (int)64, null);
            $this$roundedRectangle_u24lambda_u241.closePath();
            return svgPathDataBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Text.HorizontalAnchor.values().length];
            try {
                nArray[Text.HorizontalAnchor.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.HorizontalAnchor.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.HorizontalAnchor.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Text.VerticalAnchor.values().length];
            try {
                nArray[Text.VerticalAnchor.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

