/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.svg;

import jetbrains.datalore.base.observable.property.Property;
import jetbrains.datalore.base.observable.property.WritableProperty;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.vis.svg.SvgAttributeSpec;
import jetbrains.datalore.vis.svg.SvgColor;
import jetbrains.datalore.vis.svg.SvgElement;
import jetbrains.datalore.vis.svg.SvgPlatformPeer;
import jetbrains.datalore.vis.svg.SvgTextContent;
import jetbrains.datalore.vis.svg.SvgTextNode;
import jetbrains.datalore.vis.svg.SvgUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tB\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0016J\u0010\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0016J\u0010\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0014H\u0016J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0016J\u0010\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0016J\u0010\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0014H\u0016J\u0010\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0014H\u0016J\u0010\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0014H\u0016J\u0010\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0014H\u0016J\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0014J\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0014R\u0014\u0010\u000b\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Ljetbrains/datalore/vis/svg/SvgTSpanElement;", "Ljetbrains/datalore/vis/svg/SvgElement;", "Ljetbrains/datalore/vis/svg/SvgTextContent;", "text", "", "(Ljava/lang/String;)V", "x", "", "y", "(DDLjava/lang/String;)V", "()V", "computedTextLength", "getComputedTextLength", "()D", "elementName", "getElementName", "()Ljava/lang/String;", "addText", "", "fill", "Ljetbrains/datalore/base/observable/property/Property;", "Ljetbrains/datalore/vis/svg/SvgColor;", "fillColor", "Ljetbrains/datalore/base/observable/property/WritableProperty;", "Ljetbrains/datalore/base/values/Color;", "fillOpacity", "setText", "stroke", "strokeColor", "strokeOpacity", "strokeWidth", "textAnchor", "textDy", "Companion", "vis-svg-portable"})
public final class SvgTSpanElement
extends SvgElement
implements SvgTextContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String elementName;
    @NotNull
    private static final SvgAttributeSpec<Double> X = SvgAttributeSpec.Companion.createSpec("x");
    @NotNull
    private static final SvgAttributeSpec<Double> Y = SvgAttributeSpec.Companion.createSpec("y");

    public SvgTSpanElement() {
        this.elementName = "tspan";
    }

    @Override
    @NotNull
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public double getComputedTextLength() {
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.getComputedTextLength(this);
    }

    public SvgTSpanElement(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this();
        this.setText(text);
    }

    public SvgTSpanElement(double x, double y, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(text);
        this.setAttribute(X, x);
        this.setAttribute(Y, y);
    }

    @NotNull
    public final Property<Double> x() {
        return this.getAttribute(X);
    }

    @NotNull
    public final Property<Double> y() {
        return this.getAttribute(Y);
    }

    public final void setText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.children().clear();
        this.addText(text);
    }

    public final void addText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SvgTextNode node = new SvgTextNode(text);
        this.children().add((Object)node);
    }

    @Override
    @NotNull
    public Property<SvgColor> fill() {
        return this.getAttribute(SvgTextContent.Companion.getFILL());
    }

    @Override
    @NotNull
    public WritableProperty<Color> fillColor() {
        return SvgUtils.INSTANCE.colorAttributeTransform$vis_svg_portable(this.fill(), this.fillOpacity());
    }

    @Override
    @NotNull
    public Property<Double> fillOpacity() {
        return this.getAttribute(SvgTextContent.Companion.getFILL_OPACITY());
    }

    @Override
    @NotNull
    public Property<SvgColor> stroke() {
        return this.getAttribute(SvgTextContent.Companion.getSTROKE());
    }

    @Override
    @NotNull
    public WritableProperty<Color> strokeColor() {
        return SvgUtils.INSTANCE.colorAttributeTransform$vis_svg_portable(this.stroke(), this.strokeOpacity());
    }

    @Override
    @NotNull
    public Property<Double> strokeOpacity() {
        return this.getAttribute(SvgTextContent.Companion.getSTROKE_OPACITY());
    }

    @Override
    @NotNull
    public Property<Double> strokeWidth() {
        return this.getAttribute(SvgTextContent.Companion.getSTROKE_WIDTH());
    }

    @Override
    @NotNull
    public Property<String> textAnchor() {
        return this.getAttribute(SvgTextContent.Companion.getTEXT_ANCHOR());
    }

    @Override
    @NotNull
    public Property<String> textDy() {
        return this.getAttribute(SvgTextContent.Companion.getTEXT_DY());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/vis/svg/SvgTSpanElement$Companion;", "", "()V", "X", "Ljetbrains/datalore/vis/svg/SvgAttributeSpec;", "", "Y", "vis-svg-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

