/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.Map;
import jetbrains.datalore.plot.builder.sampling.Sampling;
import jetbrains.datalore.plot.builder.sampling.Samplings;
import jetbrains.datalore.plot.config.OptionsAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\b\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/config/SamplingProto;", "", "()V", "createSampling", "Ljetbrains/datalore/plot/builder/sampling/Sampling;", "name", "", "options", "", "plot-config-portable"})
public final class SamplingProto {
    @NotNull
    public static final SamplingProto INSTANCE = new SamplingProto();

    private SamplingProto() {
    }

    @NotNull
    public final Sampling createSampling(@NotNull String name, @NotNull Map<String, ? extends Object> options) {
        Sampling sampling;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        OptionsAccessor opts = OptionsAccessor.Companion.over(options);
        switch (name) {
            case "none": {
                sampling = (Sampling)Samplings.INSTANCE.getNONE();
                break;
            }
            case "random": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = (Sampling)Samplings.INSTANCE.random(n.intValue(), opts.getLong("seed"));
                break;
            }
            case "pick": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = (Sampling)Samplings.INSTANCE.pick(n.intValue());
                break;
            }
            case "systematic": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = Samplings.INSTANCE.systematic(n.intValue());
                break;
            }
            case "group_random": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = Samplings.INSTANCE.randomGroup(n.intValue(), opts.getLong("seed"));
                break;
            }
            case "group_systematic": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = Samplings.INSTANCE.systematicGroup(n.intValue());
                break;
            }
            case "random_stratified": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = Samplings.INSTANCE.randomStratified(n.intValue(), opts.getLong("seed"), opts.getInteger("min_subsample"));
                break;
            }
            case "vertex_vw": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = Samplings.INSTANCE.vertexVw(n.intValue());
                break;
            }
            case "vertex_dp": {
                Integer n = opts.getInteger("n");
                Intrinsics.checkNotNull((Object)n);
                sampling = Samplings.INSTANCE.vertexDp(n.intValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown sampling method: '" + name + '\'');
            }
        }
        return sampling;
    }
}

